/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.module.tweaks;

import betterwithmods.module.Feature;
import betterwithmods.util.InvUtils;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityMinecartHopper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityHopper;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.minecart.MinecartUpdateEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class HopperMinecarts
extends Feature {
    private static final ResourceLocation COUNTER = new ResourceLocation("betterwithmods", "counter");
    private static final int STACK_SIZE = 1;
    private static final Predicate<TileEntity> IGNORE_INVENTORIES_THAT_PULL = tile -> !(tile instanceof TileEntityHopper);
    @CapabilityInject(value=Counter.class)
    private static Capability<Counter> CAPABILITY_COUNTER;

    @Override
    public boolean hasSubscriptions() {
        return true;
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        CapabilityManager.INSTANCE.register(Counter.class, (Capability.IStorage)new Counter.Storage(), Counter::new);
    }

    @Override
    public String getFeatureDescription() {
        return "Allow Hopper Minecarts to output to inventories below them";
    }

    @SubscribeEvent
    public void onCapabilityAttach(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof EntityMinecartHopper) {
            event.addCapability(COUNTER, (ICapabilityProvider)new Counter());
        }
    }

    public Counter getCounter(EntityMinecartHopper entity) {
        return (Counter)entity.getCapability(CAPABILITY_COUNTER, null);
    }

    @SubscribeEvent
    public void onTick(MinecartUpdateEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof EntityMinecartHopper) {
            Counter c;
            EntityMinecartHopper cart = (EntityMinecartHopper)event.getEntity();
            World world = cart.func_145831_w();
            IItemHandler cartInv = (IItemHandler)cart.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.DOWN);
            Optional<IItemHandler> inv = InvUtils.getItemHandler(world, cart.func_180425_c().func_177977_b(), EnumFacing.UP, IGNORE_INVENTORIES_THAT_PULL);
            if (!world.field_72995_K && entity.func_70089_S() && cartInv != null && inv != null && (c = this.getCounter(cart)) != null) {
                int ejectCounter = c.getCounter();
                if (ejectCounter > 2) {
                    int slot = InvUtils.getFirstOccupiedStackInRange(cartInv, 0, 4);
                    if (slot != -1) {
                        ItemStack stack = cartInv.getStackInSlot(slot);
                        if (inv.isPresent() && InvUtils.canInsert(inv.get(), stack, 1)) {
                            ItemStack insert = InvUtils.insert(inv.get(), stack, 1, false);
                            InvUtils.consumeItemsInInventory(cartInv, stack, 1 - insert.func_190916_E(), false);
                        }
                    }
                    c.reset();
                } else {
                    c.increase();
                }
            }
        }
    }

    public static class Counter
    implements ICapabilitySerializable<NBTTagCompound> {
        private int counter;

        public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
            return CAPABILITY_COUNTER == capability;
        }

        @Nullable
        public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
            if (this.hasCapability(capability, facing)) {
                return (T)CAPABILITY_COUNTER.cast((Object)this);
            }
            return null;
        }

        public NBTTagCompound serializeNBT() {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74768_a("counter", this.counter);
            return tag;
        }

        public void deserializeNBT(NBTTagCompound nbt) {
            this.counter = nbt.func_74762_e("counter");
        }

        public int getCounter() {
            return this.counter;
        }

        public void setCounter(int counter) {
            this.counter = counter;
        }

        public void increase() {
            this.setCounter(this.getCounter() + 1);
        }

        public void reset() {
            this.setCounter(0);
        }

        public static class Storage
        implements Capability.IStorage<Counter> {
            @Nullable
            public NBTBase writeNBT(Capability<Counter> capability, Counter instance, EnumFacing side) {
                return instance.serializeNBT();
            }

            public void readNBT(Capability<Counter> capability, Counter instance, EnumFacing side, NBTBase nbt) {
                instance.deserializeNBT((NBTTagCompound)nbt);
            }
        }
    }
}

