/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.module.hardcore.world.stumping;

import betterwithmods.api.util.IWood;
import betterwithmods.common.BWMBlocks;
import betterwithmods.common.BWMItems;
import betterwithmods.common.BWOreDictionary;
import betterwithmods.module.Feature;
import betterwithmods.module.hardcore.world.HCBonemeal;
import betterwithmods.module.hardcore.world.stumping.PlacedCapability;
import betterwithmods.network.BWNetwork;
import betterwithmods.network.messages.MessagePlaced;
import betterwithmods.util.item.ToolsManager;
import betterwithmods.util.player.PlayerHelper;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLog;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;

public class HCStumping
extends Feature {
    private static final ResourceLocation PLACED_LOG = new ResourceLocation("betterwithmods", "placed_log");
    public static boolean CTM;
    public static boolean SPEED_UP_WITH_TOOLS;
    public static float STUMP_BREAK_SPEED;
    public static float ROOT_BREAK_SPEED;
    public static Set<Block> STUMP_BLACKLIST;
    public static String[] BLACKLIST_CONFIG;

    public static boolean isStump(World world, BlockPos pos) {
        return HCStumping.isLog(world.func_180495_p(pos)) && !HCStumping.isPlaced(world, pos) && HCStumping.isSoil(world.func_180495_p(pos.func_177977_b()), world, pos);
    }

    public static boolean isRoots(World world, BlockPos pos) {
        return HCStumping.isLog(world.func_180495_p(pos.func_177984_a())) && !HCStumping.isPlaced(world, pos.func_177984_a()) && HCStumping.isSoil(world.func_180495_p(pos), world, pos);
    }

    public static boolean isLog(IBlockState state) {
        if (!STUMP_BLACKLIST.contains(state.func_177230_c()) && state.func_177230_c() instanceof BlockLog) {
            if (state.func_177227_a().contains(BlockLog.field_176299_a)) {
                return ((BlockLog.EnumAxis)state.func_177229_b((IProperty)BlockLog.field_176299_a)).equals((Object)BlockLog.EnumAxis.Y);
            }
            return true;
        }
        return BWOreDictionary.getWoodFromState(state) != null;
    }

    public static boolean isSoil(IBlockState state, World world, BlockPos pos) {
        return state.isSideSolid((IBlockAccess)world, pos, EnumFacing.UP) && (state.func_185904_a() == Material.field_151578_c || state.func_185904_a() == Material.field_151577_b);
    }

    public static PlacedCapability getCapability(World world) {
        if (world.hasCapability(PlacedCapability.PLACED_CAPABILITY, null)) {
            return (PlacedCapability)world.getCapability(PlacedCapability.PLACED_CAPABILITY, null);
        }
        return null;
    }

    public static boolean addPlacedLog(World world, EntityPlayerMP player, BlockPos pos) {
        PlacedCapability capability = HCStumping.getCapability(world);
        if (capability != null && capability.addPlaced(pos)) {
            BWNetwork.sendTo(new MessagePlaced(pos), player);
            return true;
        }
        return false;
    }

    public static boolean isPlaced(World world, BlockPos pos) {
        PlacedCapability capability = HCStumping.getCapability(world);
        if (capability != null) {
            return capability.isPlaced(pos);
        }
        return false;
    }

    @Override
    public String getFeatureDescription() {
        return "Makes the bottom block of trees into stumps which cannot be removed by hand, making your mark on the world more obvious";
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        CapabilityManager.INSTANCE.register(PlacedCapability.class, (Capability.IStorage)new PlacedCapability.Storage(), PlacedCapability::new);
    }

    @Override
    public boolean requiresMinecraftRestartToEnable() {
        return true;
    }

    @Override
    public boolean hasSubscriptions() {
        return true;
    }

    @Override
    public void setupConfig() {
        for (String block : BLACKLIST_CONFIG = this.loadPropStringList("Stump Blacklist", "Logs which do not create stumps", new String[0])) {
            STUMP_BLACKLIST.add((Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(block)));
        }
        SPEED_UP_WITH_TOOLS = this.loadPropBool("Speed up with tool", "Speed up Stump mining with tools", true);
        STUMP_BREAK_SPEED = (float)this.loadPropDouble("Stump Break speed", "Base break speed of stumps, scaled by tool speed option", 0.03f);
        ROOT_BREAK_SPEED = (float)this.loadPropDouble("Root Break speed", "Base break speed of roots, scaled by tool speed option", 0.01f);
        CTM = this.loadPropBool("CTM Support", "Use ConnectedTextureMod to show the stumps", true) && this.enabled;
    }

    @SubscribeEvent
    public void onBlockPlaced(BlockEvent.PlaceEvent event) {
        World world = event.getWorld();
        if (world.field_72995_K || !(event.getPlayer() instanceof EntityPlayerMP)) {
            return;
        }
        if (PlayerHelper.isHolding(event.getPlayer(), HCBonemeal.FERTILIZERS)) {
            return;
        }
        if (HCStumping.isLog(event.getState())) {
            HCStumping.addPlacedLog(world, (EntityPlayerMP)event.getPlayer(), event.getPos());
        }
    }

    @SubscribeEvent
    public void getHarvest(PlayerEvent.BreakSpeed event) {
        float scale;
        World world = event.getEntityPlayer().func_130014_f_();
        if (HCStumping.isStump(world, event.getPos())) {
            scale = SPEED_UP_WITH_TOOLS ? ToolsManager.getSpeed(event.getEntityPlayer().func_184614_ca(), event.getState()) : 1.0f;
            event.setNewSpeed(STUMP_BREAK_SPEED * scale);
        }
        if (HCStumping.isRoots(world, event.getPos())) {
            scale = SPEED_UP_WITH_TOOLS ? ToolsManager.getSpeed(event.getEntityPlayer().func_184614_ca(), event.getState()) : 1.0f;
            event.setNewSpeed(ROOT_BREAK_SPEED * scale);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onHarvest(BlockEvent.HarvestDropsEvent event) {
        IWood wood;
        if (HCStumping.isStump(event.getWorld(), event.getPos()) && (wood = BWOreDictionary.getWoodFromState(event.getState())) != null) {
            event.getDrops().clear();
            event.getDrops().addAll(Lists.newArrayList((Object[])new ItemStack[]{wood.getSawdust(1), wood.getBark(1)}));
        }
        if (HCStumping.isRoots(event.getWorld(), event.getPos()) && (wood = BWOreDictionary.getWoodFromState(event.getWorld().func_180495_p(event.getPos().func_177984_a()))) != null) {
            event.setResult(Event.Result.DENY);
            event.getDrops().clear();
            event.getDrops().addAll(Lists.newArrayList((Object[])new ItemStack[]{new ItemStack(BWMItems.DIRT_PILE, 2), wood.getSawdust(1), wood.getBark(1)}));
        }
    }

    @SubscribeEvent
    public void attachWorldCapability(AttachCapabilitiesEvent<World> evt) {
        evt.addCapability(PLACED_LOG, (ICapabilityProvider)new PlacedCapability());
    }

    @SubscribeEvent
    public void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        PlacedCapability capability;
        if (event.player instanceof EntityPlayerMP && (capability = HCStumping.getCapability(event.player.field_70170_p)) != null) {
            BWNetwork.sendTo(new MessagePlaced(capability.getPlaced().toArray(new BlockPos[0])), (EntityPlayerMP)event.player);
        }
    }

    static {
        STUMP_BLACKLIST = Sets.newHashSet((Object[])new Block[]{BWMBlocks.BLOOD_LOG});
    }
}

