/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.module.hardcore.beacons;

import betterwithmods.common.registry.block.recipe.BlockIngredient;
import betterwithmods.module.ConfigHelper;
import betterwithmods.module.hardcore.beacons.PotionBeaconEffect;
import java.awt.Color;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class HellfireBeaconEffect
extends PotionBeaconEffect {
    @GameRegistry.ObjectHolder(value="minecraft:fire")
    public static final Block fire = null;
    private static boolean catchFire = true;

    public HellfireBeaconEffect() {
        super("hellfire", new BlockIngredient("blockConcentratedHellfire"), EntityPlayer.class);
        this.addPotionEffect(MobEffects.field_76426_n, 120, PotionBeaconEffect.Amplification.LEVEL);
        this.setBaseBeamColor(Color.ORANGE);
        this.setActivationSound(SoundEvents.field_187606_E);
    }

    @Override
    public void setupConfig(String categoryName) {
        super.setupConfig(categoryName);
        catchFire = ConfigHelper.loadPropBool("catchFire", categoryName, "The beacon will catch fire when it applies it effect", true);
    }

    @Override
    public void onBeaconCreate(@Nonnull World world, @Nonnull BlockPos pos, int beaconLevel) {
        BlockPos.MutableBlockPos firePos = new BlockPos.MutableBlockPos();
        if (catchFire) {
            for (int range = 1; range <= beaconLevel; ++range) {
                for (int x = -range; x <= range; ++x) {
                    for (int z = -range; z <= range; ++z) {
                        firePos.func_181079_c(pos.func_177958_n() + x, pos.func_177956_o() - range + 1, pos.func_177952_p() + z);
                        IBlockState state = world.func_180495_p((BlockPos)firePos);
                        if (!state.func_177230_c().func_176200_f((IBlockAccess)world, (BlockPos)firePos)) continue;
                        world.func_175656_a((BlockPos)firePos, fire.func_176223_P());
                    }
                }
            }
        }
        super.onBeaconCreate(world, pos, beaconLevel);
    }
}

