/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.module.hardcore.beacons;

import betterwithmods.common.registry.block.recipe.BlockIngredient;
import betterwithmods.module.hardcore.beacons.BeaconEffect;
import betterwithmods.util.ColorUtils;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class CosmeticBeaconEffect
extends BeaconEffect {
    private Map<BlockPos, float[]> colorCache = new HashMap<BlockPos, float[]>();

    public CosmeticBeaconEffect(String name, BlockIngredient structureBlock) {
        super(name, structureBlock, EntityLivingBase.class);
        this.setBaseBeamColor(Color.white);
    }

    @Override
    public NonNullList<EntityLivingBase> getEntitiesInRange(World world, BlockPos pos, int beaconLevel) {
        return NonNullList.func_191196_a();
    }

    @Override
    public void onBeaconCreate(@Nonnull World world, @Nonnull BlockPos pos, int beaconLevel) {
        float[] colors = null;
        for (int r = 1; r <= beaconLevel; ++r) {
            for (int x = -r; x <= r; ++x) {
                for (int z = -r; z <= r; ++z) {
                    BlockPos glassPos = new BlockPos(pos.func_177958_n() + x, pos.func_177956_o() - r, pos.func_177952_p() + z);
                    colors = colors == null ? ColorUtils.getColorFromBlock(world, glassPos, pos) : ColorUtils.average(colors, ColorUtils.getColorFromBlock(world, glassPos, pos));
                }
            }
        }
        this.colorCache.put(pos, colors);
    }

    @Override
    public float[] getBaseBeaconBeamColor(BlockPos beaconPos) {
        return this.colorCache.containsKey(beaconPos) ? this.colorCache.get(beaconPos) : super.getBaseBeaconBeamColor(beaconPos);
    }

    @Override
    public void apply(NonNullList<EntityLivingBase> entitiesInRange, @Nonnull World world, @Nonnull BlockPos pos, int beaconLevel) {
    }

    @Override
    public boolean onPlayerInteracted(World world, BlockPos pos, int level, EntityPlayer player, EnumHand hand, ItemStack stack) {
        return false;
    }

    @Override
    public void onBeaconBreak(World world, BlockPos pos, int level) {
    }
}

