/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.module.gameplay;

import betterwithmods.common.BWMBlocks;
import betterwithmods.common.blocks.BlockBUD;
import betterwithmods.common.blocks.BlockDetector;
import betterwithmods.common.blocks.BlockHemp;
import betterwithmods.common.blocks.mechanical.tile.TileEntityWaterwheel;
import betterwithmods.common.registry.block.recipe.BlockDropIngredient;
import betterwithmods.common.registry.block.recipe.BlockIngredientSpecial;
import betterwithmods.common.registry.block.recipe.StateIngredient;
import betterwithmods.module.ConfigHelper;
import betterwithmods.module.Module;
import betterwithmods.module.gameplay.AnvilRecipes;
import betterwithmods.module.gameplay.CauldronRecipes;
import betterwithmods.module.gameplay.CraftingRecipes;
import betterwithmods.module.gameplay.CrucibleRecipes;
import betterwithmods.module.gameplay.HarderSteelRecipe;
import betterwithmods.module.gameplay.HopperRecipes;
import betterwithmods.module.gameplay.KilnRecipes;
import betterwithmods.module.gameplay.MechanicalBreakage;
import betterwithmods.module.gameplay.MetalReclaming;
import betterwithmods.module.gameplay.MillRecipes;
import betterwithmods.module.gameplay.NetherGrowth;
import betterwithmods.module.gameplay.NuggetCompression;
import betterwithmods.module.gameplay.PlayerDataHandler;
import betterwithmods.module.gameplay.ReadTheFingManual;
import betterwithmods.module.gameplay.SawRecipes;
import betterwithmods.module.gameplay.TurntableRecipes;
import betterwithmods.module.gameplay.breeding_harness.BreedingHarness;
import betterwithmods.module.gameplay.miniblocks.MiniBlocks;
import betterwithmods.util.SetBlockIngredient;
import betterwithmods.util.WorldUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.BlockNetherWart;
import net.minecraft.block.BlockReed;
import net.minecraft.block.BlockVine;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;

public class Gameplay
extends Module {
    public static double generatorRenderDistance;
    public static double crankExhaustion;
    public static boolean kidFriendly;
    public static boolean disableBlastingOilEvents;
    public static float cauldronNormalSpeedFactor;
    public static float cauldronStokedSpeedFactor;
    public static float cauldronMultipleFiresFactor;
    public static boolean dropHempSeeds;
    public static List<String> blacklistDamageSources;
    private String[] waterwheelFluidConfig;

    @Override
    public void addFeatures() {
        this.registerFeature(new MechanicalBreakage());
        this.registerFeature(new MetalReclaming());
        this.registerFeature(new NuggetCompression());
        this.registerFeature(new HarderSteelRecipe());
        this.registerFeature(new AnvilRecipes());
        this.registerFeature(new CraftingRecipes());
        this.registerFeature(new CauldronRecipes());
        this.registerFeature(new CrucibleRecipes());
        this.registerFeature(new KilnRecipes());
        this.registerFeature(new MillRecipes());
        this.registerFeature(new SawRecipes());
        this.registerFeature(new TurntableRecipes());
        this.registerFeature(new HopperRecipes());
        this.registerFeature(new NetherGrowth());
        this.registerFeature(new BreedingHarness().recipes());
        this.registerFeature(new PlayerDataHandler());
        this.registerFeature(new ReadTheFingManual());
        this.registerFeature(new MiniBlocks());
    }

    @Override
    public void setupConfig() {
        generatorRenderDistance = this.loadPropDouble("Render Distance for Axle Generators", "Allows expanding the render distance radius for Windmills and Waterwheels", 256.0);
        crankExhaustion = this.loadPropDouble("Crank Exhaustion", "How much saturation turning the crank eats. Set to 0.0 to disable.", 6.0, 0.0, 6.0);
        kidFriendly = this.loadPropBool("Kid Friendly", "Makes some features more kid friendly", false);
        disableBlastingOilEvents = this.loadPropBool("Disable Blasting Oil", "Don't process blasting oil explosions, as they are have major performance impact", false);
        this.loadRecipeCondition("higheff", "High Efficiency Recipes", "Enables High Efficiency Recipes", true);
        cauldronNormalSpeedFactor = (float)this.loadPropDouble("Cauldron normal speed factor", "Cooking speed multiplier for unstoked cauldrons.", 1.0);
        cauldronStokedSpeedFactor = (float)this.loadPropDouble("Cauldron stoked speed factor", "Cooking speed multiplier for stoked cauldrons and crucibles.", 1.0);
        cauldronMultipleFiresFactor = (float)this.loadPropDouble("Cauldron Multiple fires factor", "Sets how strongly multiple fire sources (in a 3x3 grid below the pot) affect cooking times.", 1.0);
        dropHempSeeds = this.loadPropBool("Drop Hemp Seeds", "Adds Hemp seeds to the grass seed drop list.", true);
        this.waterwheelFluidConfig = ConfigHelper.loadPropStringList("Waterwheel fluids", this.name, "Additional Fluids which will allow the Waterwheel to turn and screw pump to pump, format fluid_name. (Vanilla water will always work)", new String[]{"swamp_water"});
        blacklistDamageSources = Lists.newArrayList((Object[])ConfigHelper.loadPropStringList("Blasting oil damage source blacklist", this.name, "Disallow these damage sources from disturbing blasting oil", new String[]{"drown", "cramming", "generic", "wither", "starve", "outOfWorld"}));
        super.setupConfig();
    }

    @Override
    public void init(FMLInitializationEvent event) {
        super.init(event);
        if (dropHempSeeds) {
            MinecraftForge.addGrassSeed((ItemStack)new ItemStack(BWMBlocks.HEMP, 1), (int)5);
        }
    }

    @Override
    public void postInit(FMLPostInitializationEvent event) {
        super.postInit(event);
        Arrays.stream(this.waterwheelFluidConfig).map(FluidRegistry::getFluid).filter(Objects::nonNull).collect(Collectors.toList()).forEach(fluid -> TileEntityWaterwheel.registerWater(fluid.getBlock()));
        BlockBUD.BLACKLIST = new SetBlockIngredient(new StateIngredient((Block)Blocks.field_150488_af, Items.field_151137_ax), new StateIngredient((Block)Blocks.field_150416_aS, Items.field_151107_aW), new StateIngredient((Block)Blocks.field_150413_aR, Items.field_151107_aW), new StateIngredient(Blocks.field_150437_az), new StateIngredient(Blocks.field_150429_aA), new BlockDropIngredient(new ItemStack(BWMBlocks.LIGHT)), new BlockDropIngredient(new ItemStack(BWMBlocks.BUDDY_BLOCK)));
        BlockDetector.DETECTION_HANDLERS = Sets.newHashSet((Object[])new BlockDetector.IDetection[]{new BlockDetector.IngredientDetection(new BlockIngredientSpecial(WorldUtils::isPrecipitationAt), facing -> facing == EnumFacing.UP), new BlockDetector.IngredientDetection(new BlockIngredientSpecial((world, pos) -> world.func_180495_p(pos).func_185904_a().func_76220_a())), new BlockDetector.IngredientDetection(new BlockIngredientSpecial((world, pos) -> world.func_180495_p(pos).func_177230_c() instanceof BlockVine)), new BlockDetector.IngredientDetection(new BlockIngredientSpecial((world, pos) -> world.func_180495_p(pos).func_177230_c() instanceof BlockReed)), new BlockDetector.IngredientDetection(new BlockIngredientSpecial((world, pos) -> world.func_180495_p(pos).func_177230_c().equals(BWMBlocks.LIGHT_SOURCE))), new BlockDetector.IngredientDetection(new StateIngredient(Lists.newArrayList((Object[])new IBlockState[]{BWMBlocks.HEMP.func_176223_P().func_177226_a((IProperty)BlockHemp.TOP, (Comparable)Boolean.valueOf(true))}), Lists.newArrayList((Object[])new ItemStack[]{new ItemStack(BWMBlocks.HEMP)}))), new BlockDetector.EntityDetection(), new BlockDetector.IngredientDetection(new BlockIngredientSpecial((world, pos) -> {
            BlockPos downOffset = pos.func_177977_b();
            IBlockState downState = world.func_180495_p(downOffset);
            Block downBlock = downState.func_177230_c();
            if (!(downBlock instanceof BlockHemp) && downBlock instanceof BlockCrops) {
                return ((BlockCrops)downBlock).func_185525_y(downState);
            }
            if (downBlock == Blocks.field_150388_bm) {
                return (Integer)downState.func_177229_b((IProperty)BlockNetherWart.field_176486_a) >= 3;
            }
            return false;
        }))});
    }

    @Override
    public boolean canBeDisabled() {
        return false;
    }
}

