/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.module.compat.thaumcraft;

import betterwithmods.BWMod;
import betterwithmods.common.BWMBlocks;
import betterwithmods.common.BWMItems;
import betterwithmods.common.BWMRecipes;
import betterwithmods.common.blocks.BlockAesthetic;
import betterwithmods.common.blocks.BlockDirtSlab;
import betterwithmods.common.blocks.BlockPlanter;
import betterwithmods.common.blocks.BlockRawPastry;
import betterwithmods.common.blocks.BlockUnfiredPottery;
import betterwithmods.common.blocks.BlockUrn;
import betterwithmods.common.blocks.mechanical.BlockCookingPot;
import betterwithmods.common.items.ItemArcaneScroll;
import betterwithmods.common.items.ItemMaterial;
import betterwithmods.common.registry.anvil.AnvilCraftingManager;
import betterwithmods.module.CompatFeature;
import betterwithmods.module.gameplay.miniblocks.ItemMini;
import betterwithmods.module.gameplay.miniblocks.MiniBlocks;
import betterwithmods.module.gameplay.miniblocks.MiniType;
import betterwithmods.module.gameplay.miniblocks.blocks.BlockMini;
import betterwithmods.module.tweaks.LongBoi;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSand;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.capabilities.IPlayerKnowledge;
import thaumcraft.api.capabilities.ThaumcraftCapabilities;
import thaumcraft.common.config.ConfigItems;
import thaumcraft.common.lib.crafting.ThaumcraftCraftingManager;

public class Thaumcraft
extends CompatFeature {
    public static boolean changeStart;

    public Thaumcraft() {
        super("thaumcraft");
    }

    private static AspectList getMini(ItemStack stack) {
        IBlockState state = ItemMini.getState(stack);
        AspectList list = new AspectList(BWMRecipes.getStackFromState(state));
        for (Aspect aspect : list.getAspects()) {
            int count = list.getAmount(aspect);
            list.remove(aspect, count / 2);
        }
        return list.copy();
    }

    public static void registerAnvilRecipeAspects() {
        ArrayList history = new ArrayList();
        for (IRecipe recipe : AnvilCraftingManager.ANVIL_CRAFTING) {
            AspectList tmp = null;
            try {
                Method method = ReflectionHelper.findMethod(ThaumcraftCraftingManager.class, (String)"getAspectsFromIngredients", (String)"getAspectsFromIngredients", (Class[])new Class[]{NonNullList.class, ItemStack.class, IRecipe.class, ArrayList.class});
                method.setAccessible(true);
                try {
                    tmp = (AspectList)method.invoke(null, recipe.func_192400_c(), recipe.func_77571_b(), null, history);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    e.printStackTrace();
                }
                if (tmp == null) continue;
                ThaumcraftApi.registerComplexObjectTag((ItemStack)recipe.func_77571_b(), tmp);
            }
            catch (ReflectionHelper.UnableToFindMethodException error) {
                BWMod.logger.warn((Object)error);
            }
        }
        ThaumcraftApi.registerObjectTag((ItemStack)new ItemStack(BWMBlocks.STEEL_BROKEN_GEARBOX), (AspectList)new AspectList(new ItemStack(BWMBlocks.STEEL_GEARBOX)));
        ThaumcraftApi.registerComplexObjectTag((ItemStack)BlockAesthetic.getStack(BlockAesthetic.EnumType.CHOPBLOCKBLOOD), (AspectList)new AspectList(BlockAesthetic.getStack(BlockAesthetic.EnumType.CHOPBLOCK)).add(Aspect.DEATH, 5));
    }

    @Override
    public void setupConfig() {
        changeStart = this.loadPropBool("Change Thaumcraft Start", "Due to HCBeds stopping sleeping, Thaumcraft can not be started the normal way. This changes it to only require you to right click on a bed to have the dream", true);
        if (changeStart) {
            MinecraftForge.EVENT_BUS.register((Object)new StartChanges());
        }
    }

    @Override
    public void postInit(FMLPostInitializationEvent event) {
        this.registerAspectOverrides();
        this.registerAspects();
        Thaumcraft.registerAnvilRecipeAspects();
    }

    public void registerAspectOverrides() {
        ThaumcraftApi.registerComplexObjectTag((String)"plankWood", (AspectList)new AspectList().add(Aspect.PLANT, 1));
        ThaumcraftApi.registerObjectTag((ItemStack)ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.LEATHER_CUT), (AspectList)new AspectList().add(Aspect.BEAST, 2).add(Aspect.PROTECT, 2));
        ThaumcraftApi.registerObjectTag((ItemStack)new ItemStack(Blocks.field_150424_aL), (AspectList)new AspectList(new ItemStack(Blocks.field_150424_aL)).add(Aspect.SOUL, 1));
    }

    public AspectList fromItemStacks(ItemStack ... stacks) {
        AspectList tmp = new AspectList();
        for (ItemStack stack : stacks) {
            AspectList l = new AspectList(stack);
            for (int i = 0; i < stack.func_190916_E(); ++i) {
                tmp.add(l);
            }
        }
        return tmp;
    }

    public AspectList getEnchantmentAspects(Enchantment enchantment) {
        int lvl;
        AspectList tmp = new AspectList();
        int magic = lvl = enchantment.func_77325_b();
        if (enchantment == Enchantments.field_185299_g) {
            tmp.merge(Aspect.WATER, lvl);
        } else if (enchantment == Enchantments.field_180312_n) {
            tmp.merge(Aspect.BEAST, lvl / 2).merge(Aspect.AVERSION, lvl / 2);
        } else if (enchantment == Enchantments.field_185297_d) {
            tmp.merge(Aspect.PROTECT, lvl / 2).merge(Aspect.ENTROPY, lvl / 2);
        } else if (enchantment == Enchantments.field_185305_q) {
            tmp.merge(Aspect.TOOL, lvl);
        } else if (enchantment == Enchantments.field_180309_e) {
            tmp.merge(Aspect.FLIGHT, lvl);
        } else if (enchantment == Enchantments.field_77334_n) {
            tmp.merge(Aspect.FIRE, lvl / 2).merge(Aspect.AVERSION, lvl / 2);
        } else if (enchantment == Enchantments.field_77329_d) {
            tmp.merge(Aspect.PROTECT, lvl / 2).merge(Aspect.FIRE, lvl / 2);
        } else if (enchantment == Enchantments.field_185311_w) {
            tmp.merge(Aspect.FIRE, lvl);
        } else if (enchantment == Enchantments.field_185308_t) {
            tmp.merge(Aspect.DESIRE, lvl);
        } else if (enchantment == Enchantments.field_185312_x) {
            tmp.merge(Aspect.CRAFT, lvl);
        } else if (enchantment == Enchantments.field_180313_o) {
            tmp.merge(Aspect.AIR, lvl);
        } else if (enchantment == Enchantments.field_185304_p) {
            tmp.merge(Aspect.DESIRE, lvl);
        } else if (enchantment == Enchantments.field_185309_u) {
            tmp.merge(Aspect.AVERSION, lvl);
        } else if (enchantment == Enchantments.field_180308_g) {
            tmp.merge(Aspect.PROTECT, lvl);
        } else if (enchantment == Enchantments.field_180310_c) {
            tmp.merge(Aspect.PROTECT, lvl);
        } else if (enchantment == Enchantments.field_185310_v) {
            tmp.merge(Aspect.AIR, lvl);
        } else if (enchantment == Enchantments.field_185298_f) {
            tmp.merge(Aspect.AIR, lvl);
        } else if (enchantment == Enchantments.field_185302_k) {
            tmp.merge(Aspect.AVERSION, lvl);
        } else if (enchantment == Enchantments.field_185306_r) {
            tmp.merge(Aspect.EXCHANGE, lvl);
        } else if (enchantment == Enchantments.field_92091_k) {
            tmp.merge(Aspect.AVERSION, lvl);
        } else if (enchantment == Enchantments.field_185303_l) {
            tmp.merge(Aspect.UNDEAD, lvl / 2).merge(Aspect.AVERSION, lvl / 2);
        } else if (enchantment == Enchantments.field_185307_s) {
            tmp.merge(Aspect.EARTH, lvl);
        } else if (enchantment == Enchantments.field_185300_i) {
            tmp.merge(Aspect.WATER, lvl);
        } else if (enchantment == Enchantments.field_151370_z) {
            tmp.merge(Aspect.DESIRE, lvl);
        } else if (enchantment == Enchantments.field_151369_A) {
            tmp.merge(Aspect.BEAST, lvl);
        } else if (enchantment == Enchantments.field_185301_j) {
            tmp.merge(Aspect.COLD, lvl);
        } else if (enchantment == Enchantments.field_185296_A) {
            tmp.merge(Aspect.CRAFT, lvl);
        }
        if (enchantment.func_77324_c() == Enchantment.Rarity.UNCOMMON) {
            magic += 2;
        }
        if (enchantment.func_77324_c() == Enchantment.Rarity.RARE) {
            magic += 4;
        }
        if (enchantment.func_77324_c() == Enchantment.Rarity.VERY_RARE) {
            magic += 6;
        }
        if (magic > 0) {
            tmp.merge(Aspect.MAGIC, magic);
        }
        return tmp;
    }

    public void registerAspects() {
        ThaumcraftApi.registerEntityTag((String)"longboi", (AspectList)new AspectList().add(Aspect.BEAST, 15).add(Aspect.EARTH, 10).add(Aspect.CRAFT, 5).add(Aspect.MAN, 5), (ThaumcraftApi.EntityTagsNBT[])new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag((String)"bwm_jungle_spider", (AspectList)new AspectList().add(Aspect.BEAST, 5).add(Aspect.DEATH, 10).add(Aspect.TRAP, 10), (ThaumcraftApi.EntityTagsNBT[])new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerObjectTag((ItemStack)new ItemStack(BWMBlocks.WOLF), (AspectList)new AspectList().add(Aspect.BEAST, 15).add(Aspect.EARTH, 10).add(Aspect.AVERSION, 5));
        ThaumcraftApi.registerObjectTag((ItemStack)new ItemStack(LongBoi.LONG_FRIEND), (AspectList)new AspectList().add(Aspect.BEAST, 15).add(Aspect.EARTH, 10).add(Aspect.CRAFT, 5).add(Aspect.MAN, 5));
        ThaumcraftApi.registerObjectTag((String)"barkWood", (AspectList)new AspectList().add(Aspect.PLANT, 2));
        ThaumcraftApi.registerObjectTag((String)"dustWood", (AspectList)new AspectList().add(Aspect.PLANT, 2));
        ThaumcraftApi.registerComplexObjectTag((ItemStack)ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.SOUL_DUST), (AspectList)new AspectList().add(Aspect.SOUL, 2));
        ThaumcraftApi.registerObjectTag((String)"cropHemp", (AspectList)new AspectList().add(Aspect.PLANT, 6).add(Aspect.CRAFT, 6));
        ThaumcraftApi.registerObjectTag((ItemStack)new ItemStack(BWMBlocks.HEMP), (AspectList)new AspectList().add(Aspect.PLANT, 5).add(Aspect.LIFE, 1));
        ThaumcraftApi.registerObjectTag((String)"fiberHemp", (AspectList)new AspectList().add(Aspect.PLANT, 2).add(Aspect.CRAFT, 2));
        ThaumcraftApi.registerObjectTag((String)"fabricHemp", (AspectList)new AspectList().add(Aspect.PLANT, 18).add(Aspect.CRAFT, 18));
        ThaumcraftApi.registerObjectTag((ItemStack)new ItemStack(BWMItems.CREEPER_OYSTER), (AspectList)new AspectList().add(Aspect.PLANT, 5).add(Aspect.FIRE, 5).add(Aspect.ENERGY, 5));
        ThaumcraftApi.registerObjectTag((ItemStack)ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.ELEMENT), (AspectList)this.fromItemStacks(new ItemStack(Items.field_151065_br), new ItemStack(Items.field_151007_F), new ItemStack(Items.field_151137_ax)));
        ThaumcraftApi.registerObjectTag((ItemStack)ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.FILAMENT), (AspectList)this.fromItemStacks(new ItemStack(Items.field_151114_aO), new ItemStack(Items.field_151007_F), new ItemStack(Items.field_151137_ax)));
        ThaumcraftApi.registerObjectTag((ItemStack)ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.DUNG), (AspectList)new AspectList().add(Aspect.BEAST, 5).add(Aspect.UNDEAD, 2));
        ThaumcraftApi.registerObjectTag((ItemStack)ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.GLUE), (AspectList)new AspectList(ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.GLUE)).add(Aspect.BEAST, 5));
        ThaumcraftApi.registerObjectTag((ItemStack)ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.POTASH), (AspectList)new AspectList().add(Aspect.FIRE, 4).add(Aspect.ENTROPY, 4).add(Aspect.EARTH, 4));
        ThaumcraftApi.registerObjectTag((ItemStack)ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.NETHER_SLUDGE), (AspectList)this.fromItemStacks(ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.HELLFIRE_DUST, 4), ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.POTASH)));
        ThaumcraftApi.registerObjectTag((ItemStack)new ItemStack(Items.field_151130_bT), (AspectList)new AspectList().add(Aspect.ORDER, 4).add(Aspect.FIRE, 4).add(Aspect.EARTH, 4));
        ThaumcraftApi.registerObjectTag((ItemStack)ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.GROUND_NETHERRACK), (AspectList)new AspectList(new ItemStack(Blocks.field_150424_aL)));
        ThaumcraftApi.registerObjectTag((ItemStack)ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.HELLFIRE_DUST), (AspectList)new AspectList().add(Aspect.FIRE, 4));
        ThaumcraftApi.registerObjectTag((ItemStack)ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.CONCENTRATED_HELLFIRE), (AspectList)new AspectList().add(Aspect.FIRE, 32));
        ThaumcraftApi.registerObjectTag((ItemStack)ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.SOAP), (AspectList)this.fromItemStacks(ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.POTASH), ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.TALLOW)));
        ThaumcraftApi.registerObjectTag((ItemStack)ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.NETHERCOAL), (AspectList)new AspectList().add(Aspect.FIRE, 10).add(Aspect.ENERGY, 10));
        ThaumcraftApi.registerObjectTag((ItemStack)BlockAesthetic.getStack(BlockAesthetic.EnumType.NETHERCLAY), (AspectList)new AspectList(new ItemStack(BWMBlocks.NETHER_CLAY)).add(Aspect.FIRE, 2));
        ThaumcraftApi.registerObjectTag((ItemStack)BlockAesthetic.getStack(BlockAesthetic.EnumType.PADDING), (AspectList)this.fromItemStacks(ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.PADDING, 9)));
        ThaumcraftApi.registerObjectTag((ItemStack)BlockAesthetic.getStack(BlockAesthetic.EnumType.WHITECOBBLE), (AspectList)new AspectList().add(Aspect.EARTH, 5).add(Aspect.ENTROPY, 1));
        ThaumcraftApi.registerObjectTag((ItemStack)BlockAesthetic.getStack(BlockAesthetic.EnumType.WHITESTONE), (AspectList)new AspectList().add(Aspect.EARTH, 5));
        ThaumcraftApi.registerObjectTag((ItemStack)BlockAesthetic.getStack(BlockAesthetic.EnumType.WICKER), (AspectList)this.fromItemStacks(new ItemStack(BWMBlocks.WICKER, 4)));
        ThaumcraftApi.registerObjectTag((ItemStack)BlockAesthetic.getStack(BlockAesthetic.EnumType.ROPE), (AspectList)this.fromItemStacks(new ItemStack(BWMBlocks.ROPE, 9)));
        ThaumcraftApi.registerObjectTag((ItemStack)new ItemStack(BWMItems.FERTILIZER), (AspectList)new AspectList().add(Aspect.LIFE, 5).add(Aspect.UNDEAD, 1).add(Aspect.PLANT, 1));
        ThaumcraftApi.registerObjectTag((ItemStack)new ItemStack(BWMItems.FERTILIZER), (AspectList)new AspectList().add(Aspect.LIFE, 5).add(Aspect.UNDEAD, 1).add(Aspect.PLANT, 1));
        ThaumcraftApi.registerObjectTag((ItemStack)ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.ENDER_SLAG), (AspectList)new AspectList().add(Aspect.DARKNESS, 5));
        ThaumcraftApi.registerObjectTag((ItemStack)ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.SOUL_FLUX), (AspectList)new AspectList().add(Aspect.MAGIC, 5));
        ThaumcraftApi.registerObjectTag((ItemStack)ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.BRIMSTONE), (AspectList)new AspectList().add(Aspect.ALCHEMY, 5).add(Aspect.ENTROPY, 5));
        ThaumcraftApi.registerObjectTag((ItemStack)ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.BLASTING_OIL), (AspectList)this.fromItemStacks(ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.TALLOW), ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.HELLFIRE_DUST)).add(Aspect.ALCHEMY, 5));
        ThaumcraftApi.registerObjectTag((ItemStack)ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.NITER), (AspectList)new AspectList().add(Aspect.ENTROPY, 5));
        ThaumcraftApi.registerObjectTag((ItemStack)ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.FUSE), (AspectList)this.fromItemStacks(new ItemStack(Items.field_151016_H), new ItemStack(Items.field_151007_F)));
        ThaumcraftApi.registerObjectTag((ItemStack)ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.DIAMOND_NUGGET), (AspectList)new AspectList().add(Aspect.METAL, 1).add(Aspect.CRYSTAL, 1).add(Aspect.DESIRE, 1));
        ThaumcraftApi.registerObjectTag((ItemStack)new ItemStack(BWMItems.KIBBLE), (AspectList)new AspectList().add(Aspect.LIFE, 10).add(Aspect.MAN, 10).add(Aspect.ENTROPY, 10).add(Aspect.SENSES, 5).add(Aspect.ENERGY, 1));
        ThaumcraftApi.registerComplexObjectTag((ItemStack)new ItemStack(BWMBlocks.SAW), (AspectList)new AspectList().add(Aspect.TRAP, 5));
        ThaumcraftApi.registerComplexObjectTag((ItemStack)new ItemStack(BWMBlocks.DETECTOR), (AspectList)new AspectList().add(Aspect.SENSES, 5));
        ThaumcraftApi.registerComplexObjectTag((ItemStack)new ItemStack(BWMBlocks.BUDDY_BLOCK), (AspectList)new AspectList().add(Aspect.SENSES, 5));
        ThaumcraftApi.registerComplexObjectTag((String)"blockCandle", (AspectList)new AspectList().add(Aspect.LIGHT, 8));
        ThaumcraftApi.registerComplexObjectTag((ItemStack)new ItemStack(BWMBlocks.STEEL_PRESSURE_PLATE), (AspectList)new AspectList().add(Aspect.MECHANISM, 5));
        ThaumcraftApi.registerObjectTag((ItemStack)new ItemStack(BWMBlocks.NETHER_GROWTH), (AspectList)this.fromItemStacks(BlockUrn.getStack(BlockUrn.EnumType.FULL, 8), new ItemStack((Block)Blocks.field_150338_P), new ItemStack((Block)Blocks.field_150337_Q), new ItemStack(Items.field_151075_bm), new ItemStack(Items.field_151078_bh)));
        ThaumcraftApi.registerObjectTag((ItemStack)new ItemStack(BWMBlocks.FERTILE_FARMLAND), (AspectList)new AspectList(new ItemStack(Blocks.field_150458_ak)).merge(new AspectList(new ItemStack(Items.field_151100_aR, EnumDyeColor.WHITE.func_176767_b()))));
        ThaumcraftApi.registerObjectTag((ItemStack)new ItemStack(BWMBlocks.DIRT_SLAB, 1, BlockDirtSlab.DirtSlabType.GRASS.getMetadata()), (AspectList)new AspectList().add(Aspect.PLANT, 1).add(Aspect.EARTH, 1));
        ThaumcraftApi.registerObjectTag((ItemStack)new ItemStack(BWMBlocks.DIRT_SLAB, 1, BlockDirtSlab.DirtSlabType.MYCELIUM.getMetadata()), (AspectList)new AspectList().add(Aspect.PLANT, 1).add(Aspect.EARTH, 1).add(Aspect.FLUX, 1));
        ThaumcraftApi.registerObjectTag((ItemStack)new ItemStack(BWMBlocks.SHAFT), (AspectList)new AspectList(new ItemStack(Items.field_151055_y)));
        ThaumcraftApi.registerObjectTag((ItemStack)ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.SCOURED_LEATHER), (AspectList)new AspectList().add(Aspect.BEAST, 5).add(Aspect.PROTECT, 5));
        ThaumcraftApi.registerObjectTag((ItemStack)ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.SCOURED_LEATHER_CUT), (AspectList)new AspectList().add(Aspect.BEAST, 2).add(Aspect.PROTECT, 2));
        ThaumcraftApi.registerObjectTag((ItemStack)ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.TANNED_LEATHER), (AspectList)new AspectList().add(Aspect.BEAST, 4).add(Aspect.PROTECT, 6));
        ThaumcraftApi.registerObjectTag((ItemStack)ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.TANNED_LEATHER_CUT), (AspectList)new AspectList().add(Aspect.BEAST, 2).add(Aspect.PROTECT, 3));
        ThaumcraftApi.registerObjectTag((ItemStack)ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.LEATHER_STRAP), (AspectList)new AspectList().add(Aspect.BEAST, 1).add(Aspect.CRAFT, 1));
        ThaumcraftApi.registerObjectTag((ItemStack)ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.LEATHER_BELT), (AspectList)new AspectList().add(Aspect.BEAST, 4).add(Aspect.CRAFT, 4));
        ThaumcraftApi.registerObjectTag((ItemStack)new ItemStack(BWMItems.LEATHER_TANNED_HELMET), (AspectList)new AspectList(new ItemStack((Item)Items.field_151024_Q)).add(Aspect.PROTECT, 4));
        ThaumcraftApi.registerObjectTag((ItemStack)new ItemStack(BWMItems.LEATHER_TANNED_CHEST), (AspectList)new AspectList(new ItemStack((Item)Items.field_151027_R)).add(Aspect.PROTECT, 4));
        ThaumcraftApi.registerObjectTag((ItemStack)new ItemStack(BWMItems.LEATHER_TANNED_PANTS), (AspectList)new AspectList(new ItemStack((Item)Items.field_151026_S)).add(Aspect.PROTECT, 4));
        ThaumcraftApi.registerObjectTag((ItemStack)new ItemStack(BWMItems.LEATHER_TANNED_BOOTS), (AspectList)new AspectList(new ItemStack((Item)Items.field_151021_T)).add(Aspect.PROTECT, 4));
        ThaumcraftApi.registerObjectTag((ItemStack)BlockUnfiredPottery.getStack(BlockUnfiredPottery.EnumType.CRUCIBLE), (AspectList)new AspectList().add(Aspect.WATER, 15).add(Aspect.EARTH, 15));
        ThaumcraftApi.registerObjectTag((ItemStack)BlockUnfiredPottery.getStack(BlockUnfiredPottery.EnumType.PLANTER), (AspectList)new AspectList().add(Aspect.WATER, 15).add(Aspect.EARTH, 15));
        ThaumcraftApi.registerObjectTag((ItemStack)BlockUnfiredPottery.getStack(BlockUnfiredPottery.EnumType.VASE), (AspectList)new AspectList().add(Aspect.WATER, 10).add(Aspect.EARTH, 10));
        ThaumcraftApi.registerObjectTag((ItemStack)BlockUnfiredPottery.getStack(BlockUnfiredPottery.EnumType.URN), (AspectList)new AspectList().add(Aspect.WATER, 5).add(Aspect.EARTH, 5));
        ThaumcraftApi.registerObjectTag((ItemStack)BlockUnfiredPottery.getStack(BlockUnfiredPottery.EnumType.BRICK), (AspectList)new AspectList().add(Aspect.WATER, 5).add(Aspect.EARTH, 5));
        ThaumcraftApi.registerObjectTag((String)"blockVase", (AspectList)new AspectList(BlockUnfiredPottery.getStack(BlockUnfiredPottery.EnumType.VASE)).add(Aspect.FIRE, 1));
        ThaumcraftApi.registerObjectTag((String)"blockUrn", (AspectList)new AspectList(BlockUnfiredPottery.getStack(BlockUnfiredPottery.EnumType.URN)).add(Aspect.FIRE, 1));
        ThaumcraftApi.registerObjectTag((String)"blockSoulUrn", (AspectList)new AspectList(BlockUnfiredPottery.getStack(BlockUnfiredPottery.EnumType.URN)).add(Aspect.FIRE, 1).add(Aspect.SOUL, 16));
        ThaumcraftApi.registerObjectTag((ItemStack)BlockCookingPot.getStack(BlockCookingPot.EnumType.CRUCIBLE), (AspectList)new AspectList(BlockUnfiredPottery.getStack(BlockUnfiredPottery.EnumType.CRUCIBLE)).add(Aspect.FIRE, 1).add(Aspect.VOID, 10));
        ThaumcraftApi.registerObjectTag((ItemStack)BlockCookingPot.getStack(BlockCookingPot.EnumType.DRAGONVESSEL), (AspectList)new AspectList().add(Aspect.MIND, 10).add(Aspect.ELDRITCH, 10).add(Aspect.MAGIC, 10).add(Aspect.VOID, 10));
        ThaumcraftApi.registerObjectTag((String)"slats", (AspectList)new AspectList().add(Aspect.PLANT, 1).add(Aspect.CRAFT, 1));
        ThaumcraftApi.registerObjectTag((String)"grates", (AspectList)new AspectList().add(Aspect.PLANT, 1).add(Aspect.CRAFT, 1));
        ThaumcraftApi.registerObjectTag((String)"blockWoodTable", (AspectList)new AspectList().add(Aspect.PLANT, 1).add(Aspect.CRAFT, 1));
        ThaumcraftApi.registerObjectTag((String)"blockWoodBench", (AspectList)new AspectList().add(Aspect.PLANT, 1).add(Aspect.CRAFT, 1));
        ThaumcraftApi.registerObjectTag((ItemStack)BlockPlanter.getStack(BlockPlanter.EnumType.EMPTY), (AspectList)new AspectList(BlockUnfiredPottery.getStack(BlockUnfiredPottery.EnumType.PLANTER)).add(Aspect.FIRE, 1));
        ThaumcraftApi.registerObjectTag((ItemStack)BlockPlanter.getStack(BlockPlanter.EnumType.FARMLAND), (AspectList)new AspectList(BlockPlanter.getStack(BlockPlanter.EnumType.EMPTY)).add(new AspectList(new ItemStack(Blocks.field_150458_ak))));
        ThaumcraftApi.registerObjectTag((ItemStack)BlockPlanter.getStack(BlockPlanter.EnumType.FERTILE), (AspectList)new AspectList(BlockPlanter.getStack(BlockPlanter.EnumType.EMPTY)).add(new AspectList(new ItemStack(BWMBlocks.FERTILE_FARMLAND))));
        ThaumcraftApi.registerObjectTag((ItemStack)BlockPlanter.getStack(BlockPlanter.EnumType.GRASS), (AspectList)new AspectList(BlockPlanter.getStack(BlockPlanter.EnumType.EMPTY)).add(new AspectList(new ItemStack((Block)Blocks.field_150349_c))));
        ThaumcraftApi.registerObjectTag((ItemStack)BlockPlanter.getStack(BlockPlanter.EnumType.DIRT), (AspectList)new AspectList(BlockPlanter.getStack(BlockPlanter.EnumType.EMPTY)).add(new AspectList(new ItemStack(Blocks.field_150346_d))));
        ThaumcraftApi.registerObjectTag((ItemStack)BlockPlanter.getStack(BlockPlanter.EnumType.SOULSAND), (AspectList)new AspectList(BlockPlanter.getStack(BlockPlanter.EnumType.EMPTY)).add(new AspectList(new ItemStack(Blocks.field_150425_aM))));
        ThaumcraftApi.registerObjectTag((ItemStack)BlockPlanter.getStack(BlockPlanter.EnumType.SAND), (AspectList)new AspectList(BlockPlanter.getStack(BlockPlanter.EnumType.EMPTY)).add(new AspectList(new ItemStack((Block)Blocks.field_150354_m))));
        ThaumcraftApi.registerObjectTag((ItemStack)BlockPlanter.getStack(BlockPlanter.EnumType.REDSAND), (AspectList)new AspectList(BlockPlanter.getStack(BlockPlanter.EnumType.EMPTY)).add(new AspectList(new ItemStack((Block)Blocks.field_150354_m, 1, BlockSand.EnumType.RED_SAND.func_176688_a()))));
        ThaumcraftApi.registerObjectTag((ItemStack)BlockPlanter.getStack(BlockPlanter.EnumType.GRAVEL), (AspectList)new AspectList(BlockPlanter.getStack(BlockPlanter.EnumType.EMPTY)).add(new AspectList(new ItemStack(Blocks.field_150351_n))));
        ThaumcraftApi.registerObjectTag((ItemStack)BlockPlanter.getStack(BlockPlanter.EnumType.WATER), (AspectList)new AspectList(BlockPlanter.getStack(BlockPlanter.EnumType.EMPTY)).add(Aspect.WATER, 20));
        ThaumcraftApi.registerObjectTag((ItemStack)ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.REDSTONE_LATCH), (AspectList)new AspectList().add(Aspect.METAL, 3).add(Aspect.DESIRE, 3).add(Aspect.ENERGY, 10));
        ThaumcraftApi.registerObjectTag((ItemStack)new ItemStack(BWMBlocks.WOODEN_GEARBOX), (AspectList)new AspectList(new ItemStack(BWMBlocks.WOODEN_GEARBOX)).add(new AspectList(ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.REDSTONE_LATCH))));
        ThaumcraftApi.registerObjectTag((ItemStack)ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.CHARCOAL_DUST), (AspectList)new AspectList().add(Aspect.ENERGY, 10).add(Aspect.FIRE, 10));
        ThaumcraftApi.registerObjectTag((ItemStack)ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.COAL_DUST), (AspectList)new AspectList().add(Aspect.ENERGY, 10).add(Aspect.FIRE, 10));
        ThaumcraftApi.registerObjectTag((ItemStack)ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.INGOT_STEEL), (AspectList)new AspectList().add(Aspect.METAL, 15).add(Aspect.ENERGY, 10).add(Aspect.FIRE, 10).add(Aspect.SOUL, 16));
        ThaumcraftApi.registerObjectTag((ItemStack)ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.PLATE_STEEL), (AspectList)new AspectList(ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.INGOT_STEEL)));
        ThaumcraftApi.registerObjectTag((ItemStack)ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.TALLOW), (AspectList)new AspectList().add(Aspect.BEAST, 5).add(Aspect.LIFE, 5).add(Aspect.FIRE, 1).add(Aspect.EARTH, 5));
        ThaumcraftApi.registerObjectTag((ItemStack)ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.BROADHEAD), (AspectList)new AspectList().add(Aspect.METAL, 1).add(Aspect.ENERGY, 1).add(Aspect.FIRE, 1).add(Aspect.SOUL, 1));
        AspectList milk = new AspectList().add(Aspect.BEAST, 5).add(Aspect.LIFE, 5).add(Aspect.WATER, 5);
        ThaumcraftApi.registerObjectTag((ItemStack)new ItemStack(Items.field_151105_aU), (AspectList)new AspectList().add(Aspect.PLANT, 15).add(Aspect.LIFE, 13).add(Aspect.WATER, 3).add(Aspect.DESIRE, 2).add(Aspect.ENERGY, 1).add(Aspect.AIR, 1));
        ThaumcraftApi.registerObjectTag((ItemStack)BlockRawPastry.getStack(BlockRawPastry.EnumType.BREAD), (AspectList)new AspectList(new ItemStack(Items.field_151015_O)));
        ThaumcraftApi.registerObjectTag((ItemStack)BlockRawPastry.getStack(BlockRawPastry.EnumType.CAKE), (AspectList)new AspectList(new ItemStack(Items.field_151105_aU)));
        ThaumcraftApi.registerObjectTag((ItemStack)new ItemStack(Items.field_151025_P), (AspectList)new AspectList(BlockRawPastry.getStack(BlockRawPastry.EnumType.BREAD)).add(Aspect.CRAFT, 1));
        ThaumcraftApi.registerObjectTag((ItemStack)new ItemStack(BWMItems.APPLE_PIE), (AspectList)new AspectList(BlockRawPastry.getStack(BlockRawPastry.EnumType.APPLE)).add(Aspect.CRAFT, 1));
        ThaumcraftApi.registerObjectTag((ItemStack)new ItemStack(BWMItems.APPLE_PIE), (AspectList)new AspectList(BlockRawPastry.getStack(BlockRawPastry.EnumType.APPLE)).add(Aspect.CRAFT, 1));
        ThaumcraftApi.registerObjectTag((ItemStack)new ItemStack(BWMItems.RAW_EGG), (AspectList)new AspectList(new ItemStack(Items.field_151110_aK)));
        ThaumcraftApi.registerObjectTag((ItemStack)new ItemStack(BWMItems.COOKED_EGG), (AspectList)new AspectList(new ItemStack(BWMItems.RAW_EGG)).add(Aspect.CRAFT, 1));
        ThaumcraftApi.registerObjectTag((ItemStack)new ItemStack(BWMItems.RAW_SCRAMBLED_EGG), (AspectList)new AspectList(new ItemStack(Items.field_151110_aK)).add(milk));
        ThaumcraftApi.registerObjectTag((ItemStack)new ItemStack(BWMItems.COOKED_SCRAMBLED_EGG), (AspectList)new AspectList(new ItemStack(BWMItems.RAW_SCRAMBLED_EGG)).add(Aspect.CRAFT, 1));
        ThaumcraftApi.registerObjectTag((ItemStack)new ItemStack(BWMItems.COOKED_KEBAB), (AspectList)new AspectList(new ItemStack(BWMItems.COOKED_KEBAB)).add(Aspect.CRAFT, 1));
        ThaumcraftApi.registerObjectTag((ItemStack)new ItemStack(BWMItems.COOKED_OMELET), (AspectList)new AspectList(new ItemStack(BWMItems.RAW_OMELET)).add(Aspect.CRAFT, 1));
        ThaumcraftApi.registerObjectTag((ItemStack)new ItemStack(BWMItems.BAT_WING), (AspectList)new AspectList(new ItemStack(Items.field_151147_al)).add(Aspect.FLIGHT, 5).add(Aspect.DARKNESS, 5));
        ThaumcraftApi.registerObjectTag((ItemStack)new ItemStack(BWMItems.COOKED_BAT_WING), (AspectList)new AspectList(new ItemStack(BWMItems.BAT_WING)).add(Aspect.CRAFT, 1));
        ThaumcraftApi.registerObjectTag((ItemStack)new ItemStack(BWMItems.WOLF_CHOP), (AspectList)new AspectList(new ItemStack(Items.field_151147_al)).add(Aspect.AVERSION, 1));
        ThaumcraftApi.registerObjectTag((ItemStack)new ItemStack(BWMItems.COOKED_WOLF_CHOP), (AspectList)new AspectList(new ItemStack(BWMItems.WOLF_CHOP)).add(Aspect.CRAFT, 1));
        ThaumcraftApi.registerObjectTag((ItemStack)ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.COCOA_POWDER), (AspectList)new AspectList().add(Aspect.DESIRE, 2).add(Aspect.ENERGY, 2));
        ThaumcraftApi.registerObjectTag((ItemStack)ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.POISON_SAC), (AspectList)new AspectList().add(Aspect.DEATH, 2).add(Aspect.BEAST, 2).add(Aspect.TRAP, 2).add(Aspect.ALCHEMY, 2));
        ThaumcraftApi.registerObjectTag((ItemStack)ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.MYSTERY_GLAND), (AspectList)new AspectList().add(Aspect.LIFE, 2).add(Aspect.BEAST, 2).add(Aspect.WATER, 1).add(Aspect.ALCHEMY, 2));
        ThaumcraftApi.registerObjectTag((ItemStack)ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.WITCH_WART), (AspectList)new AspectList().add(Aspect.MAN, 5).add(Aspect.MAGIC, 5).add(Aspect.ALCHEMY, 5));
        ThaumcraftApi.registerObjectTag((ItemStack)new ItemStack(BWMItems.CHICKEN_SOUP), (AspectList)this.fromItemStacks(new ItemStack(Items.field_151054_z), new ItemStack(Items.field_151174_bG), new ItemStack(Items.field_151172_bF), new ItemStack(Items.field_151076_bf)));
        ThaumcraftApi.registerObjectTag((ItemStack)new ItemStack(BWMItems.CHOCOLATE), (AspectList)this.fromItemStacks(ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.COCOA_POWDER), new ItemStack(Items.field_151102_aT)).add(milk));
        ThaumcraftApi.registerObjectTag((ItemStack)new ItemStack(BWMItems.DONUT), (AspectList)new AspectList().add(Aspect.LIFE, 1).add(Aspect.ENERGY, 1).add(Aspect.DESIRE, 1));
        ThaumcraftApi.registerObjectTag((ItemStack)new ItemStack(BWMItems.CHOWDER), (AspectList)this.fromItemStacks(new ItemStack(Items.field_151054_z), new ItemStack(Items.field_151115_aP)).add(milk));
        ThaumcraftApi.registerObjectTag((ItemStack)new ItemStack(BWMItems.MYSTERY_MEAT), (AspectList)new AspectList().add(Aspect.MAN, 5).add(Aspect.LIFE, 5).add(Aspect.ELDRITCH, 1));
        ThaumcraftApi.registerObjectTag((ItemStack)new ItemStack(BWMItems.COOKED_MYSTERY_MEAT), (AspectList)this.fromItemStacks(new ItemStack(BWMItems.MYSTERY_MEAT)).add(Aspect.FIRE, 1));
        ThaumcraftApi.registerObjectTag((ItemStack)new ItemStack(BWMItems.HEARTY_STEW), (AspectList)this.fromItemStacks(new ItemStack(Items.field_151054_z), new ItemStack(Items.field_151174_bG), new ItemStack(Items.field_151172_bF), new ItemStack(Items.field_151083_be), new ItemStack(Items.field_151054_z), new ItemStack((Block)Blocks.field_150338_P, 3)));
        ThaumcraftApi.registerObjectTag((ItemStack)new ItemStack(BWMBlocks.BLOOD_SAPLING), (AspectList)this.fromItemStacks(new ItemStack(Blocks.field_150345_g, 6), new ItemStack(Items.field_151075_bm), BlockUrn.getStack(BlockUrn.EnumType.FULL, 1)));
        ThaumcraftApi.registerObjectTag((ItemStack)new ItemStack(BWMBlocks.BLOOD_LOG), (AspectList)new AspectList().add(Aspect.PLANT, 20).add(Aspect.DEATH, 5).add(Aspect.SOUL, 2));
        ThaumcraftApi.registerObjectTag((ItemStack)new ItemStack(BWMBlocks.BLOOD_LEAVES), (AspectList)new AspectList().add(Aspect.PLANT, 5).add(Aspect.DEATH, 1).add(Aspect.SOUL, 1));
        ThaumcraftApi.registerObjectTag((ItemStack)new ItemStack(BWMBlocks.WOODEN_BROKEN_GEARBOX), (AspectList)new AspectList().add(Aspect.ENERGY, 10).add(Aspect.DESIRE, 3).add(Aspect.METAL, 3).add(Aspect.PLANT, 9));
        CreativeTabs tab = BWMItems.ARCANE_SCROLL.func_77640_w();
        if (tab != null) {
            NonNullList scrolls = NonNullList.func_191196_a();
            BWMItems.ARCANE_SCROLL.func_150895_a(tab, scrolls);
            for (ItemStack scroll : scrolls) {
                Enchantment enchantment = ItemArcaneScroll.getEnchantment(scroll);
                ThaumcraftApi.registerObjectTag((ItemStack)scroll, (AspectList)new AspectList(new ItemStack(Items.field_151121_aF)).merge(this.getEnchantmentAspects(enchantment)));
            }
        }
        for (MiniType type : MiniBlocks.MINI_MATERIAL_BLOCKS.keySet()) {
            for (BlockMini mini : MiniBlocks.MINI_MATERIAL_BLOCKS.get((Object)type).values()) {
                ItemMini item = (ItemMini)Item.func_150898_a((Block)mini);
                if (item.func_77640_w() == null) continue;
                NonNullList subItems = NonNullList.func_191196_a();
                item.func_150895_a(item.func_77640_w(), subItems);
                for (ItemStack stack : subItems) {
                    ThaumcraftApi.registerComplexObjectTag((ItemStack)stack, (AspectList)Thaumcraft.getMini(stack));
                }
            }
        }
    }

    public static class StartChanges {
        @SubscribeEvent
        public void onAttemptSleep(PlayerSleepInBedEvent event) {
            IPlayerKnowledge knowledge = ThaumcraftCapabilities.getKnowledge((EntityPlayer)event.getEntityPlayer());
            if (event.getEntityPlayer() != null && !event.getEntityPlayer().field_70170_p.field_72995_K && knowledge.isResearchKnown("!gotcrystals") && !knowledge.isResearchKnown("!gotdream")) {
                knowledge.addResearch("!gotdream");
                knowledge.sync((EntityPlayerMP)event.getEntityPlayer());
                ItemStack book = ConfigItems.startBook.func_77946_l();
                book.func_77978_p().func_74778_a("author", event.getEntityPlayer().func_70005_c_());
                if (!event.getEntityPlayer().field_71071_by.func_70441_a(book)) {
                    event.getEntityPlayer().func_70099_a(book, 2.0f);
                }
                try {
                    event.getEntityPlayer().func_145747_a((ITextComponent)new TextComponentString(TextFormatting.DARK_PURPLE + I18n.func_74838_a((String)"bwm.got.feverdream")));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

