/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.module.compat.jei.ingredient;

import betterwithmods.api.recipe.IOutput;
import java.awt.Color;
import java.util.List;
import javax.annotation.Nullable;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.color.ColorGetter;
import mezz.jei.startup.StackHelper;
import mezz.jei.util.ErrorUtil;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class OutputHelper<V extends IOutput>
implements IIngredientHelper<V> {
    private final StackHelper stackHelper;

    public OutputHelper(StackHelper stackHelper) {
        this.stackHelper = stackHelper;
    }

    public List<V> expandSubtypes(List<V> contained) {
        return contained;
    }

    @Nullable
    public V getMatch(Iterable<V> ingredients, V ingredientToMatch) {
        for (IOutput r : ingredients) {
            if (!r.equals((IOutput)ingredientToMatch)) continue;
            return (V)r;
        }
        return null;
    }

    public String getDisplayName(V ingredient) {
        return (String)ErrorUtil.checkNotNull((Object)ingredient.getOutput().func_82833_r(), (String)"itemStack.getDisplayName()");
    }

    public String getUniqueId(V ingredient) {
        ErrorUtil.checkNotEmpty((ItemStack)ingredient.getOutput());
        return this.stackHelper.getUniqueIdentifierForStack(ingredient.getOutput());
    }

    public String getWildcardId(V ingredient) {
        ErrorUtil.checkNotEmpty((ItemStack)ingredient.getOutput());
        return this.stackHelper.getUniqueIdentifierForStack(ingredient.getOutput(), StackHelper.UidMode.WILDCARD);
    }

    public String getModId(V ingredient) {
        ErrorUtil.checkNotEmpty((ItemStack)ingredient.getOutput());
        Item item = ingredient.getOutput().func_77973_b();
        ResourceLocation itemName = item.getRegistryName();
        if (itemName == null) {
            String stackInfo = this.getErrorInfo(ingredient);
            throw new IllegalStateException("item.getRegistryName() returned null for: " + stackInfo);
        }
        return itemName.func_110624_b();
    }

    public Iterable<Color> getColors(V ingredient) {
        return ColorGetter.getColors((ItemStack)ingredient.getOutput(), (int)2);
    }

    public String getResourceId(V ingredient) {
        ErrorUtil.checkNotEmpty((ItemStack)ingredient.getOutput());
        Item item = ingredient.getOutput().func_77973_b();
        ResourceLocation itemName = item.getRegistryName();
        if (itemName == null) {
            String stackInfo = this.getErrorInfo(ingredient);
            throw new IllegalStateException("item.getRegistryName() returned null for: " + stackInfo);
        }
        return itemName.func_110623_a();
    }

    public V copyIngredient(V ingredient) {
        return (V)ingredient.copy();
    }

    public String getErrorInfo(V ingredient) {
        return ErrorUtil.getItemStackInfo((ItemStack)ingredient.getOutput());
    }
}

