/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.module.compat.jei.category;

import betterwithmods.api.recipe.IOutput;
import betterwithmods.common.registry.block.recipe.KilnRecipe;
import betterwithmods.common.registry.heat.BWMHeatRegistry;
import betterwithmods.module.compat.jei.category.BWMRecipeCategory;
import betterwithmods.module.compat.jei.wrapper.KilnRecipeWrapper;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IGuiIngredientGroup;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class KilnRecipeCategory
extends BWMRecipeCategory<KilnRecipeWrapper> {
    public static final int width = 145;
    public static final int height = 80;
    public static final String UID = "bwm.kiln";
    private static final ResourceLocation guiTexture = new ResourceLocation("betterwithmods", "textures/gui/jei/kiln.png");
    @Nonnull
    private IDrawableAnimated flame;
    private IGuiHelper helper;

    public KilnRecipeCategory(IGuiHelper helper, String uid) {
        super((IDrawable)helper.createDrawable(guiTexture, 0, 0, 145, 80), uid, String.format("inv.%s.name", uid.substring(4)));
        this.helper = helper;
    }

    public void drawExtras(@Nonnull Minecraft minecraft) {
        this.flame.draw(minecraft, 67, 33);
    }

    public void setRecipe(@Nonnull IRecipeLayout layout, @Nonnull KilnRecipeWrapper wrapper, @Nonnull IIngredients ingredients) {
        IDrawableStatic flameDrawable = this.helper.createDrawable(guiTexture, 145, ((KilnRecipe)wrapper.getRecipe()).getHeat() > 1 ? 14 : 0, 14, 14);
        this.flame = this.helper.createAnimatedDrawable(flameDrawable, 200, IDrawableAnimated.StartDirection.BOTTOM, false);
        IGuiItemStackGroup stacks = layout.getItemStacks();
        IGuiIngredientGroup outputs = layout.getIngredientsGroup(IOutput.class);
        stacks.init(0, true, 20, 31);
        KilnRecipeCategory.createSlotsHorizontal(outputs, false, 3, 1, 87, 32);
        stacks.set(ingredients);
        outputs.set(ingredients);
        int heat = ((KilnRecipe)wrapper.getRecipe()).getHeat();
        List<ItemStack> heatSources = BWMHeatRegistry.getStacks(heat);
        if (!heatSources.isEmpty()) {
            stacks.init(5, true, 65, 52);
            stacks.set(5, heatSources);
        }
    }
}

