/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.module.compat.jei;

import betterwithmods.api.recipe.IOutput;
import betterwithmods.api.recipe.impl.ChanceOutput;
import betterwithmods.api.recipe.impl.RandomOutput;
import betterwithmods.api.recipe.impl.StackOutput;
import betterwithmods.client.container.anvil.ContainerSteelAnvil;
import betterwithmods.client.gui.GuiSteelAnvil;
import betterwithmods.client.gui.bulk.GuiCauldron;
import betterwithmods.client.gui.bulk.GuiCrucible;
import betterwithmods.client.gui.bulk.GuiFilteredHopper;
import betterwithmods.client.gui.bulk.GuiMill;
import betterwithmods.common.BWMBlocks;
import betterwithmods.common.BWMItems;
import betterwithmods.common.BWRegistry;
import betterwithmods.common.blocks.mechanical.BlockCookingPot;
import betterwithmods.common.blocks.mechanical.BlockMechMachines;
import betterwithmods.common.items.ItemMaterial;
import betterwithmods.common.registry.HopperInteractions;
import betterwithmods.common.registry.anvil.AnvilCraftingManager;
import betterwithmods.common.registry.anvil.ShapedAnvilRecipe;
import betterwithmods.common.registry.anvil.ShapelessAnvilRecipe;
import betterwithmods.common.registry.block.recipe.KilnRecipe;
import betterwithmods.common.registry.block.recipe.SawRecipe;
import betterwithmods.common.registry.block.recipe.TurntableRecipe;
import betterwithmods.common.registry.bulk.recipes.CookingPotRecipe;
import betterwithmods.common.registry.bulk.recipes.MillRecipe;
import betterwithmods.common.registry.crafting.ToolBaseRecipe;
import betterwithmods.common.registry.crafting.ToolDamageRecipe;
import betterwithmods.common.registry.heat.BWMHeatRegistry;
import betterwithmods.module.compat.jei.AnvilCraftingTransfer;
import betterwithmods.module.compat.jei.category.CookingPotRecipeCategory;
import betterwithmods.module.compat.jei.category.HopperRecipeCategory;
import betterwithmods.module.compat.jei.category.KilnRecipeCategory;
import betterwithmods.module.compat.jei.category.MillRecipeCategory;
import betterwithmods.module.compat.jei.category.SawRecipeCategory;
import betterwithmods.module.compat.jei.category.SteelAnvilRecipeCategory;
import betterwithmods.module.compat.jei.category.SteelSawRecipeCategory;
import betterwithmods.module.compat.jei.category.TurntableRecipeCategory;
import betterwithmods.module.compat.jei.ingredient.OutputHelper;
import betterwithmods.module.compat.jei.ingredient.OutputRenderer;
import betterwithmods.module.compat.jei.wrapper.BlockRecipeWrapper;
import betterwithmods.module.compat.jei.wrapper.BulkRecipeWrapper;
import betterwithmods.module.compat.jei.wrapper.HopperRecipeWrapper;
import betterwithmods.module.compat.jei.wrapper.KilnRecipeWrapper;
import betterwithmods.module.compat.jei.wrapper.ShapedAnvilRecipeWrapper;
import betterwithmods.module.compat.jei.wrapper.TurntableRecipeWrapper;
import betterwithmods.module.gameplay.miniblocks.MiniBlocks;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import mezz.jei.Internal;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.IJeiRuntime;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.ISubtypeRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.ingredients.IModIngredientRegistration;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import mezz.jei.api.recipe.IVanillaRecipeFactory;
import mezz.jei.api.recipe.transfer.IRecipeTransferInfo;
import mezz.jei.api.recipe.transfer.IRecipeTransferRegistry;
import mezz.jei.gui.Focus;
import mezz.jei.plugins.vanilla.crafting.ShapelessRecipeWrapper;
import mezz.jei.startup.StackHelper;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.oredict.ShapelessOreRecipe;

@JEIPlugin
public class JEI
implements IModPlugin {
    public static IJeiHelpers HELPER;
    public static IJeiRuntime JEI_RUNTIME;
    public static List<Class<? extends IOutput>> ALL_OUTPUTS;

    public static void doAllOutputs(Consumer<Class<? extends IOutput>> consumer) {
        ALL_OUTPUTS.forEach(consumer);
    }

    public static void showRecipe(Ingredient ingredient) {
        ItemStack stack = Lists.newArrayList((Object[])ingredient.func_193365_a()).stream().findFirst().orElse(ItemStack.field_190927_a);
        if (stack.func_190926_b()) {
            return;
        }
        Focus focus = new Focus(IFocus.Mode.OUTPUT, (Object)stack);
        JEI_RUNTIME.getRecipesGui().show((IFocus)focus);
    }

    private static String getHeatUID(String base, int heat) {
        if (heat == 1) {
            return base;
        }
        if (heat == 2) {
            return String.format("%s.%s", base, "stoked");
        }
        return String.format("%s.%s", base, heat);
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        if (JEI_RUNTIME == null) {
            JEI_RUNTIME = jeiRuntime;
        }
    }

    public void registerCategories(IRecipeCategoryRegistration reg) {
        IJeiHelpers helpers = reg.getJeiHelpers();
        IGuiHelper guiHelper = helpers.getGuiHelper();
        for (int heat : BWMHeatRegistry.allHeatLevels()) {
            reg.addRecipeCategories(new IRecipeCategory[]{new CookingPotRecipeCategory(guiHelper, JEI.getHeatUID("bwm.cauldron", heat)), new CookingPotRecipeCategory(guiHelper, JEI.getHeatUID("bwm.crucible", heat)), new KilnRecipeCategory(guiHelper, JEI.getHeatUID("bwm.kiln", heat))});
        }
        reg.addRecipeCategories(new IRecipeCategory[]{new MillRecipeCategory(guiHelper), new SawRecipeCategory(guiHelper), new SteelSawRecipeCategory(guiHelper), new TurntableRecipeCategory(guiHelper), new HopperRecipeCategory(guiHelper), new SteelAnvilRecipeCategory(guiHelper)});
    }

    public void registerItemSubtypes(ISubtypeRegistry subtypeRegistry) {
        this.getAllMiniBlocks().forEach(item -> subtypeRegistry.registerSubtypeInterpreter(item, itemStack -> {
            NBTTagCompound compound = itemStack.func_179543_a("texture");
            return compound != null ? compound.toString() : "";
        }));
    }

    private List<Item> getAllMiniBlocks() {
        ArrayList<Item> list = new ArrayList<Item>();
        MiniBlocks.SIDINGS.values().stream().map(Item::func_150898_a).forEach(list::add);
        MiniBlocks.MOULDINGS.values().stream().map(Item::func_150898_a).forEach(list::add);
        MiniBlocks.CORNERS.values().stream().map(Item::func_150898_a).forEach(list::add);
        return list;
    }

    public void registerIngredients(IModIngredientRegistration registry) {
        StackHelper stackHelper = Internal.getStackHelper();
        JEI.doAllOutputs(clazz -> registry.register(clazz, Collections.emptySet(), new OutputHelper(stackHelper), new OutputRenderer()));
    }

    public void register(@Nonnull IModRegistry reg) {
        HELPER = reg.getJeiHelpers();
        this.registerHeatBasedRecipes(reg);
        reg.handleRecipes(MillRecipe.class, r -> new BulkRecipeWrapper<MillRecipe>(HELPER, (MillRecipe)r, 3), "bwm.mill");
        reg.handleRecipes(SawRecipe.class, r -> new BlockRecipeWrapper<SawRecipe>(HELPER, (SawRecipe)r, 3), "bwm.saw");
        reg.handleRecipes(SawRecipe.class, r -> new BlockRecipeWrapper<SawRecipe>(HELPER, (SawRecipe)r, 3), "bwm.saw.steel");
        reg.handleRecipes(TurntableRecipe.class, recipe -> new TurntableRecipeWrapper(HELPER, (TurntableRecipe)recipe), "bwm.turntable");
        reg.handleRecipes(HopperInteractions.HopperRecipe.class, recipe -> new HopperRecipeWrapper(HELPER, (HopperInteractions.HopperRecipe)recipe), "bwm.hopper");
        reg.handleRecipes(ShapedAnvilRecipe.class, recipe -> new ShapedAnvilRecipeWrapper(HELPER, (ShapedAnvilRecipe)((Object)recipe)), "bwm.steel_anvil");
        reg.handleRecipes(ShapelessAnvilRecipe.class, recipe -> new ShapelessRecipeWrapper(HELPER, (IRecipe)recipe), "bwm.steel_anvil");
        reg.handleRecipes(ShapelessOreRecipe.class, recipe -> new ShapelessRecipeWrapper(HELPER, (IRecipe)recipe), "bwm.steel_anvil");
        reg.handleRecipes(ShapelessRecipes.class, recipe -> new ShapelessRecipeWrapper(HELPER, (IRecipe)recipe), "bwm.steel_anvil");
        reg.handleRecipes(ToolBaseRecipe.class, recipe -> new ShapelessRecipeWrapper(HELPER, (IRecipe)recipe), "bwm.steel_anvil");
        reg.handleRecipes(ToolBaseRecipe.class, recipe -> new ShapelessRecipeWrapper(HELPER, (IRecipe)recipe), "minecraft.crafting");
        reg.handleRecipes(ToolDamageRecipe.class, recipe -> new ShapelessRecipeWrapper(HELPER, (IRecipe)recipe), "bwm.steel_anvil");
        reg.handleRecipes(ToolDamageRecipe.class, recipe -> new ShapelessRecipeWrapper(HELPER, (IRecipe)recipe), "minecraft.crafting");
        reg.addRecipes(BWRegistry.MILLSTONE.getRecipes(), "bwm.mill");
        reg.addRecipes(BWRegistry.WOOD_SAW.getDisplayRecipes(), "bwm.saw");
        reg.addRecipes(BWRegistry.TURNTABLE.getDisplayRecipes(), "bwm.turntable");
        reg.addRecipes(HopperInteractions.getDisplayRecipes(), "bwm.hopper");
        reg.addRecipes(AnvilCraftingManager.ANVIL_CRAFTING, "bwm.steel_anvil");
        reg.addRecipeCatalyst((Object)BlockMechMachines.getStack(BlockMechMachines.EnumType.MILL), new String[]{"bwm.mill"});
        reg.addRecipeCatalyst((Object)BlockMechMachines.getStack(BlockMechMachines.EnumType.HOPPER), new String[]{"bwm.hopper"});
        reg.addRecipeCatalyst((Object)BlockMechMachines.getStack(BlockMechMachines.EnumType.TURNTABLE), new String[]{"bwm.turntable"});
        reg.addRecipeCatalyst((Object)new ItemStack(BWMBlocks.SAW), new String[]{"bwm.saw"});
        reg.addRecipeCatalyst((Object)new ItemStack(BWMBlocks.STEEL_SAW), new String[]{"bwm.saw.steel"});
        reg.addRecipeCatalyst((Object)new ItemStack(BWMBlocks.STEEL_ANVIL), new String[]{"bwm.steel_anvil"});
        reg.addRecipeClickArea(GuiMill.class, 81, 19, 14, 14, new String[]{"bwm.mill"});
        reg.addRecipeClickArea(GuiSteelAnvil.class, 88, 41, 28, 23, new String[]{"bwm.steel_anvil"});
        reg.addRecipeClickArea(GuiFilteredHopper.class, 81, 19, 14, 14, new String[]{"bwm.hopper"});
        this.registerAnvil(reg);
        IRecipeTransferRegistry recipeTransferRegistry = reg.getRecipeTransferRegistry();
        recipeTransferRegistry.addRecipeTransferHandler(ContainerSteelAnvil.class, "bwm.steel_anvil", 1, 16, 17, 36);
        recipeTransferRegistry.addRecipeTransferHandler((IRecipeTransferInfo)new AnvilCraftingTransfer());
    }

    private void registerAnvil(IModRegistry reg) {
        ArrayList tools = Lists.newArrayList((Object[])new ItemStack[]{new ItemStack(BWMItems.STEEL_AXE), new ItemStack(BWMItems.STEEL_BATTLEAXE), new ItemStack(BWMItems.STEEL_BOOTS), new ItemStack(BWMItems.STEEL_CHEST), new ItemStack(BWMItems.STEEL_HELMET), new ItemStack(BWMItems.STEEL_HOE), new ItemStack(BWMItems.STEEL_MATTOCK), new ItemStack(BWMItems.STEEL_PANTS), new ItemStack(BWMItems.STEEL_PICKAXE), new ItemStack(BWMItems.STEEL_SHOVEL), new ItemStack(BWMItems.STEEL_SWORD)});
        IVanillaRecipeFactory v = reg.getJeiHelpers().getVanillaRecipeFactory();
        for (ItemStack stack : tools) {
            ItemStack dam1 = stack.func_77946_l();
            dam1.func_77964_b(dam1.func_77958_k());
            ItemStack dam2 = stack.func_77946_l();
            dam2.func_77964_b(dam2.func_77958_k() * 3 / 4);
            ItemStack dam3 = stack.func_77946_l();
            dam3.func_77964_b(dam3.func_77958_k() * 2 / 4);
            v.createAnvilRecipe(dam1, Collections.singletonList(ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.INGOT_STEEL)), Collections.singletonList(dam2));
            v.createAnvilRecipe(dam2, Collections.singletonList(ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.INGOT_STEEL)), Collections.singletonList(dam3));
        }
    }

    private void registerHeatBasedRecipes(@Nonnull IModRegistry reg) {
        HashSet cauldron = Sets.newHashSet();
        HashSet crucible = Sets.newHashSet();
        HashSet kiln = Sets.newHashSet();
        for (int heat : BWMHeatRegistry.allHeatLevels()) {
            String cauldronUID = JEI.getHeatUID("bwm.cauldron", heat);
            String crucibleUID = JEI.getHeatUID("bwm.crucible", heat);
            String kilnUID = JEI.getHeatUID("bwm.kiln", heat);
            cauldron.add(cauldronUID);
            crucible.add(crucibleUID);
            kiln.add(kilnUID);
            reg.handleRecipes(CookingPotRecipe.class, recipe -> new BulkRecipeWrapper<CookingPotRecipe>(HELPER, (CookingPotRecipe)recipe, 9), cauldronUID);
            reg.handleRecipes(CookingPotRecipe.class, recipe -> new BulkRecipeWrapper<CookingPotRecipe>(HELPER, (CookingPotRecipe)recipe, 9), crucibleUID);
            reg.handleRecipes(KilnRecipe.class, recipe -> new KilnRecipeWrapper(HELPER, (KilnRecipe)recipe), kilnUID);
            reg.addRecipes(BWRegistry.CAULDRON.getRecipesForHeat(heat), cauldronUID);
            reg.addRecipes(BWRegistry.CRUCIBLE.getRecipesForHeat(heat), crucibleUID);
            reg.addRecipes(BWRegistry.KILN.getRecipesForHeat(heat), kilnUID);
        }
        reg.addRecipeCatalyst((Object)BlockCookingPot.getStack(BlockCookingPot.EnumType.CAULDRON), (String[])cauldron.stream().toArray(String[]::new));
        reg.addRecipeCatalyst((Object)BlockCookingPot.getStack(BlockCookingPot.EnumType.CRUCIBLE), (String[])crucible.stream().toArray(String[]::new));
        reg.addRecipeCatalyst((Object)new ItemStack(Blocks.field_150336_V), (String[])kiln.stream().toArray(String[]::new));
        reg.addRecipeClickArea(GuiCauldron.class, 81, 19, 14, 14, (String[])cauldron.stream().toArray(String[]::new));
        reg.addRecipeClickArea(GuiCrucible.class, 81, 19, 14, 14, (String[])crucible.stream().toArray(String[]::new));
    }

    static {
        ALL_OUTPUTS = Lists.newArrayList();
        ALL_OUTPUTS.add(IOutput.class);
        ALL_OUTPUTS.add(StackOutput.class);
        ALL_OUTPUTS.add(RandomOutput.class);
        ALL_OUTPUTS.add(ChanceOutput.class);
    }
}

