/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.event;

import betterwithmods.common.BWRegistry;
import betterwithmods.common.BWSounds;
import betterwithmods.util.player.PlayerHelper;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.UUID;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

@Mod.EventBusSubscriber(modid="betterwithmods")
public class PenaltyEventHandler {
    private static Object2IntMap<UUID> painTimers = new Object2IntOpenHashMap();

    @SubscribeEvent
    public static void onJump(LivingEvent.LivingJumpEvent event) {
        EntityPlayer player;
        if (event.getEntityLiving() instanceof EntityPlayer && !BWRegistry.PENALTY_HANDLERS.canJump(player = (EntityPlayer)event.getEntityLiving())) {
            event.getEntityLiving().field_70159_w = 0.0;
            event.getEntityLiving().field_70181_x = 0.0;
            event.getEntityLiving().field_70179_y = 0.0;
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            return;
        }
        EntityPlayer player = event.player;
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        if (!PlayerHelper.isSurvival(player)) {
            return;
        }
        if (!BWRegistry.PENALTY_HANDLERS.canSprint(player)) {
            player.func_70031_b(false);
        }
        if (player.func_70090_H() && !BWRegistry.PENALTY_HANDLERS.canSwim(player) && !PlayerHelper.isNearBottom(player)) {
            player.field_70181_x -= 0.04;
        }
    }

    private static boolean inPain(EntityPlayer player) {
        UUID uuid = player.func_110124_au();
        if (uuid == null) {
            return false;
        }
        if ((Integer)painTimers.getOrDefault((Object)uuid, (Object)0) > 60) {
            painTimers.put((Object)uuid, 0);
            return true;
        }
        painTimers.put((Object)uuid, (Integer)painTimers.getOrDefault((Object)uuid, (Object)0) + 1);
        return false;
    }

    @SubscribeEvent
    public static void onPlayerUpdate(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntityLiving() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntityLiving();
            World world = player.field_70170_p;
            if (!PlayerHelper.isSurvival(player) || player.func_184218_aH()) {
                PlayerHelper.removeModifier((EntityLivingBase)player, SharedMonsterAttributes.field_111263_d, PlayerHelper.PENALTY_SPEED_UUID);
                return;
            }
            double speed = BWRegistry.PENALTY_HANDLERS.getSpeedModifier(player);
            if (speed != 0.0) {
                PlayerHelper.changeSpeed((EntityLivingBase)player, "Penalty Speed Modifier", speed, PlayerHelper.PENALTY_SPEED_UUID);
            }
            if (!world.field_72995_K && BWRegistry.PENALTY_HANDLERS.inPain(player) && PlayerHelper.isMoving(player) && PenaltyEventHandler.inPain(player)) {
                world.func_184133_a(null, player.func_180425_c(), BWSounds.OOF, SoundCategory.BLOCKS, 0.75f, 1.0f);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerAttack(LivingAttackEvent event) {
        EntityPlayer player;
        if (event.getSource().func_76346_g() instanceof EntityPlayer && PlayerHelper.isSurvival(player = (EntityPlayer)event.getSource().func_76346_g()) && !BWRegistry.PENALTY_HANDLERS.canAttack(player)) {
            player.func_184185_a(BWSounds.OOF, 0.75f, 1.0f);
            event.setCanceled(true);
            event.setResult(Event.Result.DENY);
        }
    }
}

