/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.registry.crafting;

import com.google.common.collect.Maps;
import com.google.common.collect.Streams;
import java.util.HashMap;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class IngredientTool
extends Ingredient {
    private Predicate<ItemStack> tool;
    private ItemStack example;
    public static HashMap<ItemStack, ItemStack[]> TOOLS = Maps.newHashMap();

    public IngredientTool(Predicate<ItemStack> tool, ItemStack exampleStack) {
        super(new ItemStack[0]);
        this.tool = tool;
        this.example = exampleStack;
        if (TOOLS.keySet().stream().noneMatch(s -> s.func_77969_a(this.example))) {
            TOOLS.put(this.example, IngredientTool.collectAllTools(tool));
        }
    }

    public IngredientTool(String toolClass) {
        this(s -> s.func_77973_b().getHarvestLevel(s, toolClass, null, null) > -1, ItemStack.field_190927_a);
    }

    public ItemStack[] func_193365_a() {
        ItemStack stack = TOOLS.keySet().stream().filter(s -> s.func_77969_a(this.example)).findFirst().orElse(null);
        if (stack != null) {
            return TOOLS.get(stack);
        }
        return new ItemStack[]{this.example};
    }

    public boolean apply(ItemStack stack) {
        return this.tool.test(stack);
    }

    public static ItemStack[] collectAllTools(Predicate<ItemStack> tool) {
        List<ItemStack> list = Streams.stream((Iterable)ForgeRegistries.ITEMS).map(ItemStack::new).filter(tool).collect(Collectors.toList());
        ItemStack[] stacks = new ItemStack[list.size()];
        return list.toArray(stacks);
    }
}

