/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.entity.ai;

import betterwithmods.util.ReflectionLib;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class EntityAIVillagerMate
extends EntityAIBase {
    final World world;
    final double moveSpeed;
    private final EntityVillager villager;
    int spawnBabyDelay;
    private EntityVillager mate;

    public EntityAIVillagerMate(EntityVillager villager, double speedIn) {
        this.villager = villager;
        this.world = villager.func_130014_f_();
        this.moveSpeed = speedIn;
        this.func_75248_a(3);
    }

    public static boolean isWillingToMate(EntityVillager villager) {
        if (villager != null) {
            return (Boolean)ReflectionHelper.getPrivateValue(EntityVillager.class, (Object)villager, (String[])ReflectionLib.ENTITY_VILLAGER_ISWILLINGTOMATE);
        }
        return false;
    }

    public boolean func_75250_a() {
        if (this.villager.func_70874_b() != 0 || this.villager.func_70681_au().nextInt(500) != 0) {
            return false;
        }
        if (!EntityAIVillagerMate.isWillingToMate(this.villager)) {
            return false;
        }
        this.mate = this.getNearbyMate();
        return this.mate != null && this.mate.func_70874_b() == 0;
    }

    public boolean func_75253_b() {
        return this.mate.func_70089_S() && EntityAIVillagerMate.isWillingToMate(this.mate) && this.spawnBabyDelay < 60;
    }

    public void func_75251_c() {
        this.mate = null;
        this.spawnBabyDelay = 0;
    }

    public void func_75246_d() {
        this.villager.func_70671_ap().func_75651_a((Entity)this.mate, 10.0f, (float)this.villager.func_70646_bf());
        this.villager.func_70661_as().func_75497_a((Entity)this.mate, this.moveSpeed);
        ++this.spawnBabyDelay;
        if (this.spawnBabyDelay >= 60 && this.villager.func_70068_e((Entity)this.mate) < 9.0) {
            this.spawnBaby();
        }
    }

    private EntityVillager getNearbyMate() {
        List list = this.world.func_72872_a(this.villager.getClass(), this.villager.func_174813_aQ().func_186662_g(8.0));
        double d0 = Double.MAX_VALUE;
        EntityVillager mate = null;
        for (EntityVillager current : list) {
            if (!this.canMateWith(this.villager, current) || !(this.villager.func_70068_e((Entity)current) < d0)) continue;
            mate = current;
            d0 = this.villager.func_70068_e((Entity)current);
        }
        return mate;
    }

    private void spawnBaby() {
        EntityVillager baby = this.villager.func_90011_a((EntityAgeable)this.mate);
        if (baby != null) {
            this.villager.func_70873_a(6000);
            this.mate.func_70873_a(6000);
            this.villager.func_175549_o(false);
            this.mate.func_175549_o(false);
            baby.func_70873_a(-24000);
            baby.func_70012_b(this.villager.field_70165_t, this.villager.field_70163_u, this.villager.field_70161_v, 0.0f, 0.0f);
            boolean profession = this.world.field_73012_v.nextBoolean();
            baby.setProfession(profession ? this.villager.getProfessionForge() : this.mate.getProfessionForge());
            this.world.func_72838_d((Entity)baby);
            Random random = this.villager.func_70681_au();
            for (int i = 0; i < 7; ++i) {
                double d0 = random.nextGaussian() * 0.02;
                double d1 = random.nextGaussian() * 0.02;
                double d2 = random.nextGaussian() * 0.02;
                double d3 = random.nextDouble() * (double)this.villager.field_70130_N * 2.0 - (double)this.villager.field_70130_N;
                double d4 = 0.5 + random.nextDouble() * (double)this.villager.field_70131_O;
                double d5 = random.nextDouble() * (double)this.villager.field_70130_N * 2.0 - (double)this.villager.field_70130_N;
                this.world.func_175688_a(EnumParticleTypes.HEART, this.villager.field_70165_t + d3, this.villager.field_70163_u + d4, this.villager.field_70161_v + d5, d0, d1, d2, new int[0]);
            }
            if (this.world.func_82736_K().func_82766_b("doMobLoot")) {
                this.world.func_72838_d((Entity)new EntityXPOrb(this.world, this.villager.field_70165_t, this.villager.field_70163_u, this.villager.field_70161_v, random.nextInt(7) + 1));
            }
        }
    }

    public boolean canMateWith(EntityVillager village, EntityVillager mate) {
        return village != mate && EntityAIVillagerMate.isWillingToMate(this.villager) && EntityAIVillagerMate.isWillingToMate(mate);
    }
}

