/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.blocks.tile;

import betterwithmods.common.blocks.tile.SimpleStackHandler;
import betterwithmods.common.blocks.tile.TileBasic;
import betterwithmods.util.InvUtils;
import java.util.function.Predicate;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public abstract class TileBasicInventory
extends TileBasic {
    public Predicate<EnumFacing> hasCapability = facing -> true;
    public SimpleStackHandler inventory = this.createItemStackHandler();

    public abstract int getInventorySize();

    public SimpleStackHandler createItemStackHandler() {
        return new SimpleStackHandler(this.getInventorySize(), this);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && (facing == null || this.hasCapability.test(facing))) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (this.hasCapability(capability, facing) && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.inventory);
        }
        return (T)super.getCapability(capability, facing);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        tag.func_179237_a(this.inventory.serializeNBT());
        return super.func_189515_b(tag);
    }

    public void func_145839_a(NBTTagCompound compound) {
        if (this.inventory == null) {
            this.inventory = this.createItemStackHandler();
        }
        this.inventory.deserializeNBT(compound);
        super.func_145839_a(compound);
    }

    public void func_70296_d() {
        super.func_70296_d();
        this.func_189515_b(new NBTTagCompound());
    }

    @Override
    public void onBreak() {
        IItemHandler inv = (IItemHandler)this.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.UP);
        if (inv != null) {
            InvUtils.ejectInventoryContents(this.field_145850_b, this.field_174879_c, inv);
        }
    }
}

