/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.blocks.mechanical.tile;

import betterwithmods.common.blocks.mechanical.tile.TileAxleMachine;
import betterwithmods.common.damagesource.BWDamageSource;
import betterwithmods.util.DirUtils;
import betterwithmods.util.WorldUtils;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class TileSteelSaw
extends TileAxleMachine {
    public static final AxisAlignedBB X_BOX = new AxisAlignedBB(0.0, -1.0, -1.0, 0.0, 1.0, 1.0);
    public static final AxisAlignedBB Y_BOX = new AxisAlignedBB(-1.0, 0.0, -1.0, 1.0, 0.0, 1.0);
    public static final AxisAlignedBB Z_BOX = new AxisAlignedBB(-1.0, -1.0, 0.0, 1.0, 1.0, 0.0);
    public static final AxisAlignedBB[] BOXES = new AxisAlignedBB[]{X_BOX, Y_BOX, Z_BOX};

    public AxisAlignedBB getRenderBoundingBox() {
        return super.getRenderBoundingBox();
    }

    @Override
    public int getPower() {
        if (!this.isValid()) {
            return 0;
        }
        return super.getPower();
    }

    public boolean isValid() {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        boolean valid = true;
        Set<BlockPos> positions = WorldUtils.getPosAround(this.field_174879_c, (EnumFacing.Axis)state.func_177229_b(DirUtils.AXIS));
        for (BlockPos check : positions) {
            if (check.equals((Object)this.func_174877_v()) || this.saw(this.field_145850_b, check, this.field_145850_b.field_73012_v, true)) continue;
            valid = false;
            break;
        }
        return valid;
    }

    @Override
    public void func_73660_a() {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        Set<BlockPos> positions = WorldUtils.getPosAround(this.field_174879_c, (EnumFacing.Axis)state.func_177229_b(DirUtils.AXIS));
        if (this.getPower() > 0 && this.field_145850_b.func_82737_E() % 10L == 0L) {
            List items;
            EnumFacing.Axis axis = (EnumFacing.Axis)state.func_177229_b(DirUtils.AXIS);
            AxisAlignedBB box = BOXES[axis.ordinal()].func_186670_a(this.field_174879_c);
            List entities = this.field_145850_b.func_72872_a(EntityLivingBase.class, box.func_186662_g(0.25));
            if (!entities.isEmpty()) {
                entities.forEach(this::hitEntity);
                this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187782_ds, SoundCategory.BLOCKS, 1.0f + this.field_145850_b.field_73012_v.nextFloat() * 0.1f, 1.5f + this.field_145850_b.field_73012_v.nextFloat() * 0.1f);
            }
            if (!(items = this.field_145850_b.func_72872_a(EntityItem.class, box.func_186662_g(0.5))).isEmpty()) {
                items.forEach(item -> this.moveItems(axis, (EntityItem)item));
                this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187782_ds, SoundCategory.BLOCKS, 1.0f + this.field_145850_b.field_73012_v.nextFloat() * 0.1f, 1.5f + this.field_145850_b.field_73012_v.nextFloat() * 0.1f);
            }
            for (BlockPos pos : positions) {
                if (pos.equals((Object)this.func_174877_v())) continue;
                this.saw(this.field_145850_b, pos, this.field_145850_b.field_73012_v, false);
            }
        }
    }

    private void moveItems(EnumFacing.Axis axis, EntityItem item) {
        BlockPos itemPos = item.func_180425_c();
        int x = this.func_174877_v().func_177958_n() - itemPos.func_177958_n();
        int y = this.func_174877_v().func_177956_o() - itemPos.func_177956_o();
        int z = this.func_174877_v().func_177952_p() - itemPos.func_177952_p();
        switch (axis) {
            default: {
                break;
            }
            case X: {
                if (z != 0) break;
                item.func_70016_h(0.0, 0.0, (double)y / 2.0);
                break;
            }
            case Z: {
                if (x != 0) break;
                item.func_70016_h((double)y / 2.0, 0.0, 0.0);
            }
        }
    }

    private void hitEntity(EntityLivingBase entity) {
        entity.field_70718_bc = 60;
        if (this.field_145850_b instanceof WorldServer && BWDamageSource.getSawDamage() != null) {
            entity.func_70097_a((DamageSource)BWDamageSource.getSteelSawDamage(), 10.0f);
        }
    }

    @Override
    public byte getMaximumSignal() {
        return 5;
    }

    private boolean saw(World world, BlockPos pos, Random rand, boolean simulate) {
        return false;
    }

    @Override
    public World getBlockWorld() {
        return super.getBlockWorld();
    }

    @Override
    public BlockPos getBlockPos() {
        return super.getBlockPos();
    }
}

