/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.advancements;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.advancements.ICriterionTrigger;
import net.minecraft.advancements.PlayerAdvancements;
import net.minecraft.advancements.critereon.AbstractCriterionInstance;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class InfernalEnchantedTrigger
implements ICriterionTrigger<Instance> {
    private static final ResourceLocation ID = new ResourceLocation("betterwithmods", "infernal_enchant");
    private final Map<PlayerAdvancements, Listeners> listeners = Maps.newHashMap();

    @Nonnull
    public ResourceLocation func_192163_a() {
        return ID;
    }

    public void func_192165_a(@Nonnull PlayerAdvancements playerAdvancementsIn, @Nonnull ICriterionTrigger.Listener<Instance> listener) {
        Listeners enchanteditemtrigger$listeners = this.listeners.get(playerAdvancementsIn);
        if (enchanteditemtrigger$listeners == null) {
            enchanteditemtrigger$listeners = new Listeners(playerAdvancementsIn);
            this.listeners.put(playerAdvancementsIn, enchanteditemtrigger$listeners);
        }
        enchanteditemtrigger$listeners.add(listener);
    }

    public void func_192164_b(@Nonnull PlayerAdvancements playerAdvancementsIn, @Nonnull ICriterionTrigger.Listener<Instance> listener) {
        Listeners enchanteditemtrigger$listeners = this.listeners.get(playerAdvancementsIn);
        if (enchanteditemtrigger$listeners != null) {
            enchanteditemtrigger$listeners.remove(listener);
            if (enchanteditemtrigger$listeners.isEmpty()) {
                this.listeners.remove(playerAdvancementsIn);
            }
        }
    }

    public void func_192167_a(@Nonnull PlayerAdvancements playerAdvancementsIn) {
        this.listeners.remove(playerAdvancementsIn);
    }

    @Nonnull
    public Instance deserializeInstance(@Nonnull JsonObject json, @Nonnull JsonDeserializationContext context) {
        ItemPredicate itempredicate = ItemPredicate.func_192492_a((JsonElement)json.get("item"));
        MinMaxBounds minmaxbounds = MinMaxBounds.func_192515_a((JsonElement)json.get("levels"));
        return new Instance(itempredicate, minmaxbounds);
    }

    public void trigger(EntityPlayerMP player, ItemStack item, int levelsSpent) {
        Listeners enchanteditemtrigger$listeners = this.listeners.get(player.func_192039_O());
        if (enchanteditemtrigger$listeners != null) {
            enchanteditemtrigger$listeners.trigger(item, levelsSpent);
        }
    }

    static class Listeners {
        private final PlayerAdvancements playerAdvancements;
        private final Set<ICriterionTrigger.Listener<Instance>> listeners = Sets.newHashSet();

        public Listeners(PlayerAdvancements playerAdvancementsIn) {
            this.playerAdvancements = playerAdvancementsIn;
        }

        public boolean isEmpty() {
            return this.listeners.isEmpty();
        }

        public void add(ICriterionTrigger.Listener<Instance> listener) {
            this.listeners.add(listener);
        }

        public void remove(ICriterionTrigger.Listener<Instance> listener) {
            this.listeners.remove(listener);
        }

        public void trigger(ItemStack item, int levelsIn) {
            List list = null;
            for (ICriterionTrigger.Listener<Instance> listener : this.listeners) {
                if (!((Instance)listener.func_192158_a()).test(item, levelsIn)) continue;
                if (list == null) {
                    list = Lists.newArrayList();
                }
                list.add(listener);
            }
            if (list != null) {
                for (ICriterionTrigger.Listener listener1 : list) {
                    listener1.func_192159_a(this.playerAdvancements);
                }
            }
        }
    }

    public static class Instance
    extends AbstractCriterionInstance {
        private final ItemPredicate item;
        private final MinMaxBounds levels;

        public Instance(ItemPredicate item, MinMaxBounds levels) {
            super(ID);
            this.item = item;
            this.levels = levels;
        }

        public boolean test(ItemStack item, int levelsIn) {
            if (!this.item.func_192493_a(item)) {
                return false;
            }
            return this.levels.func_192514_a((float)levelsIn);
        }
    }
}

