/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.world.generators;

import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.IWorldGenerator;
import nmd.primal.core.api.PrimalAPI;
import nmd.primal.core.common.PrimalCore;
import nmd.primal.core.common.blocks.ores.Magnetite;
import nmd.primal.core.common.blocks.ores.Zinc;
import nmd.primal.core.common.helper.WorldHelper;
import nmd.primal.core.common.init.ModConfig;
import nmd.primal.core.common.world.PendingBlocks;
import nmd.primal.core.common.world.feature.GenOreSafe;
import nmd.primal.core.common.world.feature.GenOreSafeSub;

public class OverWorldStone
implements IWorldGenerator {
    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        if (world.field_73011_w.func_186058_p() == DimensionType.OVERWORLD && ModConfig.Worldgen.ENABLE_GENERATION_OVERWORLD || world.field_73011_w.func_76569_d() && ModConfig.Worldgen.ENABLE_MOD_DIMENSIONS) {
            int k;
            BlockPos ore_pos;
            int k2;
            int x = WorldHelper.getChunkPos(chunkX);
            int z = WorldHelper.getChunkPos(chunkZ);
            Biome biome = world.func_180494_b(new BlockPos(x, 0, z));
            PendingBlocks.getForWorld(world, "primal.world.stone").processPending(new ChunkPos(chunkX, chunkZ), world, WorldHelper.PREDICATE_STONE);
            if (ModConfig.Worldgen.ENABLE_CARBONATE_STONE) {
                int zinc_chance;
                int n = zinc_chance = ModConfig.Worldgen.ENABLE_ZINC ? 60 : 0;
                if (PrimalAPI.randomCheck(10) && WorldHelper.biomeHasType(biome, BiomeDictionary.Type.HILLS, BiomeDictionary.Type.SAVANNA, BiomeDictionary.Type.MESA, BiomeDictionary.Type.SANDY, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.WASTELAND)) {
                    for (k2 = 0; k2 < 24; ++k2) {
                        ore_pos = new BlockPos(x + PrimalCore.RANDOM.nextInt(8), PrimalCore.RANDOM.nextInt(55, 220), z + PrimalCore.RANDOM.nextInt(8));
                        if (!new GenOreSafeSub(PrimalAPI.Blocks.CARBONATE_STONE.func_176223_P(), PrimalAPI.Blocks.ORE_ZINC.func_176223_P().func_177226_a(Zinc.TYPE, (Comparable)((Object)Zinc.Type.CARBONATE)), PrimalCore.RANDOM.nextInt(36, 96), zinc_chance, WorldHelper.PREDICATE_STONE, "primal.world.stone").func_180709_b(world, PrimalCore.RANDOM, ore_pos)) continue;
                        PrimalAPI.logger(16, "world gen limestone", "@" + ore_pos);
                    }
                }
            }
            if (ModConfig.Worldgen.ENABLE_FERRO_STONE) {
                int magnetite_chance;
                int n = magnetite_chance = ModConfig.Worldgen.ENABLE_MAGNETITE ? 90 : 0;
                if (PrimalAPI.randomCheck(10) && WorldHelper.biomeHasType(biome, BiomeDictionary.Type.JUNGLE, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.SWAMP, BiomeDictionary.Type.SPOOKY, BiomeDictionary.Type.DEAD, BiomeDictionary.Type.HOT, BiomeDictionary.Type.MUSHROOM)) {
                    for (k2 = 0; k2 < 24; ++k2) {
                        ore_pos = new BlockPos(x + PrimalCore.RANDOM.nextInt(8), PrimalCore.RANDOM.nextInt(24, 60), z + PrimalCore.RANDOM.nextInt(8));
                        if (!new GenOreSafeSub(PrimalAPI.Blocks.FERRO_STONE.func_176223_P(), PrimalAPI.Blocks.ORE_MAGNETITE.func_176223_P().func_177226_a(Magnetite.TYPE, (Comparable)((Object)Magnetite.Type.FERRO)), PrimalCore.RANDOM.nextInt(8, 56), magnetite_chance, WorldHelper.PREDICATE_STONE, "primal.world.stone").func_180709_b(world, PrimalCore.RANDOM, ore_pos)) continue;
                        PrimalAPI.logger(16, "world gen ferro", "@" + ore_pos);
                    }
                }
                if (PrimalAPI.randomCheck(36) && WorldHelper.biomeHasType(biome, BiomeDictionary.Type.OCEAN, BiomeDictionary.Type.RIVER, BiomeDictionary.Type.WET)) {
                    for (k2 = 0; k2 < 24; ++k2) {
                        ore_pos = new BlockPos(x + PrimalCore.RANDOM.nextInt(8), PrimalCore.RANDOM.nextInt(8, 40), z + PrimalCore.RANDOM.nextInt(8));
                        if (!new GenOreSafeSub(PrimalAPI.Blocks.FERRO_STONE.func_176223_P(), PrimalAPI.Blocks.ORE_MAGNETITE.func_176223_P().func_177226_a(Magnetite.TYPE, (Comparable)((Object)Magnetite.Type.FERRO)), PrimalCore.RANDOM.nextInt(16, 86), magnetite_chance, WorldHelper.PREDICATE_STONE, "primal.world.stone").func_180709_b(world, PrimalCore.RANDOM, ore_pos)) continue;
                        PrimalAPI.logger(16, "world gen ferro", "@" + ore_pos);
                    }
                }
            }
            if (ModConfig.Worldgen.ENABLE_BLUE_STONE && PrimalAPI.randomCheck(24) && WorldHelper.biomeHasType(biome, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.COLD, BiomeDictionary.Type.SPOOKY, BiomeDictionary.Type.SPOOKY, BiomeDictionary.Type.MAGICAL, BiomeDictionary.Type.RARE)) {
                for (k = 0; k < 16; ++k) {
                    BlockPos ore_pos2 = new BlockPos(x + PrimalCore.RANDOM.nextInt(8), PrimalCore.RANDOM.nextInt(55, 85), z + PrimalCore.RANDOM.nextInt(8));
                    if (!new GenOreSafe(PrimalAPI.Blocks.BLUE_STONE.func_176223_P(), PrimalCore.RANDOM.nextInt(24, 76), WorldHelper.PREDICATE_STONE, "primal.world.stone").func_180709_b(world, PrimalCore.RANDOM, ore_pos2)) continue;
                    PrimalAPI.logger(16, "world gen bluestone", "@" + ore_pos2);
                }
            }
            if (ModConfig.Worldgen.ENABLE_SARSEN_STONE && PrimalAPI.randomCheck(60) && WorldHelper.biomeHasType(biome, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.HILLS, BiomeDictionary.Type.MAGICAL, BiomeDictionary.Type.SPOOKY, BiomeDictionary.Type.DEAD, BiomeDictionary.Type.RARE, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.COLD)) {
                for (k = 0; k < 24; ++k) {
                    BlockPos ore_pos3 = new BlockPos(x + PrimalCore.RANDOM.nextInt(8), PrimalCore.RANDOM.nextInt(32, 196), z + PrimalCore.RANDOM.nextInt(8));
                    if (!new GenOreSafe(PrimalAPI.Blocks.SARSEN_STONE.func_176223_P(), PrimalCore.RANDOM.nextInt(32, 96), WorldHelper.PREDICATE_STONE, "primal.world.stone").func_180709_b(world, PrimalCore.RANDOM, ore_pos3)) continue;
                    PrimalAPI.logger(16, "world gen sarsen", "@" + ore_pos3);
                }
            }
            if (ModConfig.Worldgen.ENABLE_ORTHO_STONE && PrimalAPI.randomCheck(10) && WorldHelper.biomeHasType(biome, BiomeDictionary.Type.SAVANNA, BiomeDictionary.Type.MESA, BiomeDictionary.Type.SANDY, BiomeDictionary.Type.JUNGLE)) {
                for (k = 0; k < 16; ++k) {
                    BlockPos ore_pos4 = new BlockPos(x + PrimalCore.RANDOM.nextInt(8), PrimalCore.RANDOM.nextInt(48, 96), z + PrimalCore.RANDOM.nextInt(8));
                    if (!new GenOreSafe(PrimalAPI.Blocks.ORTHO_STONE.func_176223_P(), PrimalCore.RANDOM.nextInt(24, 55), WorldHelper.PREDICATE_STONE, "primal.world.stone").func_180709_b(world, PrimalCore.RANDOM, ore_pos4)) continue;
                    PrimalAPI.logger(16, "world gen ortho stone", "@" + ore_pos4);
                }
            }
            if (ModConfig.Worldgen.ENABLE_PURPURITE_STONE && PrimalAPI.randomCheck(90) && WorldHelper.biomeHasType(biome, BiomeDictionary.Type.WASTELAND, BiomeDictionary.Type.MUSHROOM, BiomeDictionary.Type.SPOOKY, BiomeDictionary.Type.DEAD)) {
                for (k = 0; k < 16; ++k) {
                    BlockPos ore_pos5 = new BlockPos(x + PrimalCore.RANDOM.nextInt(8), PrimalCore.RANDOM.nextInt(10, 55), z + PrimalCore.RANDOM.nextInt(8));
                    if (!new GenOreSafe(PrimalAPI.Blocks.PURPURITE_STONE.func_176223_P(), PrimalCore.RANDOM.nextInt(16, 42), WorldHelper.PREDICATE_STONE, "primal.world.stone").func_180709_b(world, PrimalCore.RANDOM, ore_pos5)) continue;
                    PrimalAPI.logger(16, "world gen purpurite", "@" + ore_pos5);
                }
            }
            if (ModConfig.Worldgen.ENABLE_GREEN_SCHIST && PrimalAPI.randomCheck(10) && WorldHelper.biomeHasType(biome, BiomeDictionary.Type.JUNGLE, BiomeDictionary.Type.LUSH)) {
                for (k = 0; k < 16; ++k) {
                    BlockPos ore_pos6 = new BlockPos(x + PrimalCore.RANDOM.nextInt(8), PrimalCore.RANDOM.nextInt(40, 200), z + PrimalCore.RANDOM.nextInt(8));
                    if (!new GenOreSafe(PrimalAPI.Blocks.SCHIST_GREEN_STONE.func_176223_P(), PrimalCore.RANDOM.nextInt(36, 82), WorldHelper.PREDICATE_STONE, "primal.world.stone").func_180709_b(world, PrimalCore.RANDOM, ore_pos6)) continue;
                    PrimalAPI.logger(16, "world gen green schist", "@" + ore_pos6);
                }
            }
        }
    }
}

