/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.world.generators;

import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.IWorldGenerator;
import nmd.primal.core.api.PrimalAPI;
import nmd.primal.core.common.PrimalCore;
import nmd.primal.core.common.blocks.plants.AbstractPlantGrowing;
import nmd.primal.core.common.helper.WorldHelper;
import nmd.primal.core.common.init.ModConfig;
import nmd.primal.core.common.world.feature.plants.GenGrowingPlant;
import nmd.primal.core.common.world.feature.plants.GenPlantNearMaterial;
import nmd.primal.core.common.world.feature.plants.GenTallPlants;
import nmd.primal.core.common.world.feature.plants.GenTreeIronwood;
import nmd.primal.core.common.world.feature.plants.GenTreeYew;

public class OverWorldPlants
implements IWorldGenerator {
    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        if (world.field_73011_w.func_186058_p() == DimensionType.OVERWORLD && ModConfig.Worldgen.ENABLE_GENERATION_OVERWORLD || world.field_73011_w.func_76569_d() && ModConfig.Worldgen.ENABLE_MOD_DIMENSIONS) {
            int t;
            int i;
            int x = WorldHelper.getChunkPos(chunkX);
            int z = WorldHelper.getChunkPos(chunkZ);
            Biome biome = world.func_180494_b(new BlockPos(x, 0, z));
            if (ModConfig.Worldgen.ENABLE_RUSHES) {
                if (PrimalAPI.randomCheck(12) && WorldHelper.biomeHasType(biome, BiomeDictionary.Type.RIVER, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.SWAMP, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.SPOOKY)) {
                    for (i = 0; i < 16; ++i) {
                        new GenGrowingPlant((AbstractPlantGrowing)PrimalAPI.Blocks.RUSHES, PrimalCore.RANDOM.nextInt(120, 260)).func_180709_b(world, PrimalCore.RANDOM, WorldHelper.getWorldGenPos(x, z, PrimalCore.RANDOM.nextInt(63, 90)));
                    }
                }
                if (PrimalAPI.randomCheck(6) && WorldHelper.biomeHasType(biome, BiomeDictionary.Type.RIVER, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.SWAMP, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.SPOOKY)) {
                    for (i = 0; i < 36; ++i) {
                        new GenPlantNearMaterial((AbstractPlantGrowing)PrimalAPI.Blocks.RUSHES, Material.field_151586_h, 4, PrimalCore.RANDOM.nextInt(120, 260)).func_180709_b(world, PrimalCore.RANDOM, WorldHelper.getWorldGenPos(x, z, PrimalCore.RANDOM.nextInt(63, 90)));
                    }
                }
            }
            if (ModConfig.Worldgen.ENABLE_WILD_CORN && PrimalAPI.randomCheck(20) && WorldHelper.biomeHasType(biome, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.MESA, BiomeDictionary.Type.SAVANNA, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.JUNGLE, BiomeDictionary.Type.LUSH)) {
                for (i = 0; i < 24; ++i) {
                    new GenTallPlants((AbstractPlantGrowing)PrimalAPI.Blocks.CORN_STALK, PrimalCore.RANDOM.nextInt(24)).func_180709_b(world, PrimalCore.RANDOM, WorldHelper.getWorldGenPos(x, z, PrimalCore.RANDOM.nextInt(63, 90)));
                }
            }
            if (ModConfig.Worldgen.ENABLE_ACONITE && PrimalAPI.randomCheck(90) && WorldHelper.biomeHasType(biome, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.HILLS, BiomeDictionary.Type.JUNGLE, BiomeDictionary.Type.RIVER, BiomeDictionary.Type.MAGICAL, BiomeDictionary.Type.SPOOKY, BiomeDictionary.Type.LUSH)) {
                for (i = 0; i < 24; ++i) {
                    new GenGrowingPlant(PrimalAPI.Blocks.ACONITE, 24).func_180709_b(world, PrimalCore.RANDOM, WorldHelper.getWorldGenPos(x, z, PrimalCore.RANDOM.nextInt(63, 90)));
                }
            }
            if (ModConfig.Worldgen.ENABLE_IRONWOOD_TREES && PrimalAPI.randomCheck(60) && (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.FOREST) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.HILLS) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.MOUNTAIN) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.MAGICAL) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SPOOKY) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.PLAINS))) {
                for (t = 0; t < 6; ++t) {
                    new GenTreeIronwood(false).func_180709_b(world, PrimalCore.RANDOM, WorldHelper.getWorldGenPos(x, z, PrimalCore.RANDOM.nextInt(35, 120)));
                }
            }
            if (ModConfig.Worldgen.ENABLE_YEW_TREES && PrimalAPI.randomCheck(10) && (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.FOREST) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.HILLS) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.CONIFEROUS))) {
                for (t = 0; t < 16; ++t) {
                    new GenTreeYew(false).func_180709_b(world, PrimalCore.RANDOM, WorldHelper.getWorldGenPos(x, z, PrimalCore.RANDOM.nextInt(35, 90)));
                }
            }
        }
    }
}

