/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.world.feature.plants;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraftforge.common.IPlantable;
import nmd.primal.core.api.PrimalAPI;
import nmd.primal.core.api.interfaces.types.ITypeLogs;
import nmd.primal.core.common.PrimalCore;
import nmd.primal.core.common.helper.WorldHelper;

public class GenTreeYew
extends WorldGenAbstractTree {
    private final boolean doBlockNotify;
    private boolean big = PrimalCore.RANDOM.nextBoolean();
    private World world;
    private BlockPos basePos = BlockPos.field_177992_a;
    int heightLimit;
    int height;
    double heightAttenuation = 0.45;
    double branchSlope = this.big ? 0.0 : 0.05;
    double scaleWidth = this.big ? 2.0 : 0.8;
    double leafDensity = this.big ? 2.5 : 1.0;
    int trunkSize = this.big ? 2 : 1;
    int heightLimitLimit = 8;
    int leafDistanceLimit = 3;
    List<FoliageCoordinates> foliageCoords;

    public GenTreeYew(boolean notify) {
        super(notify);
        this.doBlockNotify = notify;
    }

    protected boolean func_150523_a(Block blockType) {
        return super.func_150523_a(blockType) || blockType == PrimalAPI.Blocks.LOGS;
    }

    void generateLeafNodeList() {
        int k;
        int i;
        this.height = (int)((double)this.heightLimit * this.heightAttenuation);
        if (this.height >= this.heightLimit) {
            this.height = this.heightLimit - 1;
        }
        if ((i = (int)(1.382 + Math.pow(this.leafDensity * (double)this.heightLimit / 13.0, 2.0))) < 1) {
            i = 1;
        }
        int j = this.basePos.func_177956_o() + this.height;
        this.foliageCoords = Lists.newArrayList();
        this.foliageCoords.add(new FoliageCoordinates(this.basePos.func_177981_b(k), j));
        for (k = this.heightLimit - this.leafDistanceLimit; k >= 0; --k) {
            float f = this.layerSize(k);
            if (!(f >= 0.0f)) continue;
            for (int l = 0; l < i; ++l) {
                BlockPos blockpos1;
                double d3;
                double d1;
                double d0 = this.scaleWidth * (double)f * ((double)PrimalCore.RANDOM.nextFloat() + 0.328);
                double d2 = d0 * Math.sin(d1 = (double)(PrimalCore.RANDOM.nextFloat() * 2.0f) * Math.PI) + 0.5;
                BlockPos blockpos = this.basePos.func_177963_a(d2, (double)(k - 1), d3 = d0 * Math.cos(d1) + 0.5);
                if (this.checkBlockLine(blockpos, blockpos1 = blockpos.func_177981_b(this.leafDistanceLimit)) != -1) continue;
                int i1 = this.basePos.func_177958_n() - blockpos.func_177958_n();
                int j1 = this.basePos.func_177952_p() - blockpos.func_177952_p();
                double d4 = (double)blockpos.func_177956_o() - Math.sqrt(i1 * i1 + j1 * j1) * this.branchSlope;
                int k1 = d4 > (double)j ? j : (int)d4;
                BlockPos blockpos2 = new BlockPos(this.basePos.func_177958_n(), k1, this.basePos.func_177952_p());
                if (this.checkBlockLine(blockpos2, blockpos) != -1) continue;
                this.foliageCoords.add(new FoliageCoordinates(blockpos, blockpos2.func_177956_o()));
            }
        }
    }

    void crossSection(BlockPos pos, float p_181631_2_, IBlockState sectionState) {
        int i = (int)((double)p_181631_2_ + 0.618);
        for (int j = -i; j <= i; ++j) {
            for (int k = -i; k <= i; ++k) {
                IBlockState state;
                BlockPos blockpos;
                if (!(Math.pow((double)Math.abs(j) + 0.5, 2.0) + Math.pow((double)Math.abs(k) + 0.5, 2.0) <= (double)(p_181631_2_ * p_181631_2_)) || !WorldHelper.isValidPos(this.world, blockpos = pos.func_177982_a(j, 0, k), new ChunkPos(pos)) || !(state = this.world.func_180495_p(blockpos)).func_177230_c().isAir(state, (IBlockAccess)this.world, blockpos) && !state.func_177230_c().isLeaves(state, (IBlockAccess)this.world, blockpos)) continue;
                WorldHelper.setBlockAndNotifyAdequately(this.world, blockpos, sectionState, this.doBlockNotify);
            }
        }
    }

    float layerSize(int y) {
        if ((float)y < (float)this.heightLimit * 0.3f) {
            return -1.0f;
        }
        float f = (float)this.heightLimit / 2.0f;
        float f1 = f - (float)y;
        float f2 = MathHelper.func_76129_c((float)(f * f - f1 * f1));
        if (f1 == 0.0f) {
            f2 = f;
        } else if (Math.abs(f1) >= f) {
            return 0.0f;
        }
        return f2 * 0.5f;
    }

    float leafSize(int y) {
        return y >= 0 && y < this.leafDistanceLimit ? (y != 0 && y != this.leafDistanceLimit - 1 ? 3.0f : 2.0f) : -1.0f;
    }

    void generateLeafNode(BlockPos pos) {
        for (int i = 0; i < this.leafDistanceLimit; ++i) {
            this.crossSection(pos.func_177981_b(i), this.leafSize(i), PrimalAPI.Blocks.LEAVES.func_176223_P().func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false)).func_177226_a(ITypeLogs.TYPE, (Comparable)((Object)ITypeLogs.EnumType.YEW)));
        }
    }

    void limb(BlockPos pos1, BlockPos pos2, IBlockState state) {
        BlockPos blockpos = pos2.func_177982_a(-pos1.func_177958_n(), -pos1.func_177956_o(), -pos1.func_177952_p());
        int i = this.getGreatestDistance(blockpos);
        float f = (float)blockpos.func_177958_n() / (float)i;
        float f1 = (float)blockpos.func_177956_o() / (float)i;
        float f2 = (float)blockpos.func_177952_p() / (float)i;
        for (int j = 0; j <= i; ++j) {
            BlockPos blockpos1 = pos1.func_177963_a((double)(0.5f + (float)j * f), (double)(0.5f + (float)j * f1), (double)(0.5f + (float)j * f2));
            BlockLog.EnumAxis blocklog$enumaxis = this.getLogAxis(pos1, blockpos1);
            if (!WorldHelper.isInChunk(new ChunkPos(pos1), blockpos1) && !WorldHelper.isInChunk(new ChunkPos(pos2), blockpos1) && !this.world.func_190526_b(blockpos1.func_177958_n() >> 4, blockpos1.func_177952_p() >> 4)) continue;
            WorldHelper.setBlockAndNotifyAdequately(this.world, blockpos1, state.func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)blocklog$enumaxis), this.doBlockNotify);
        }
    }

    private int getGreatestDistance(BlockPos posIn) {
        int i = MathHelper.func_76130_a((int)posIn.func_177958_n());
        int j = MathHelper.func_76130_a((int)posIn.func_177956_o());
        int k = MathHelper.func_76130_a((int)posIn.func_177952_p());
        return k > i && k > j ? k : (j > i ? j : i);
    }

    private BlockLog.EnumAxis getLogAxis(BlockPos p_175938_1_, BlockPos p_175938_2_) {
        int j;
        BlockLog.EnumAxis blocklog$enumaxis = BlockLog.EnumAxis.Y;
        int i = Math.abs(p_175938_2_.func_177958_n() - p_175938_1_.func_177958_n());
        int k = Math.max(i, j = Math.abs(p_175938_2_.func_177952_p() - p_175938_1_.func_177952_p()));
        if (k > 0) {
            if (i == k) {
                blocklog$enumaxis = BlockLog.EnumAxis.X;
            } else if (j == k) {
                blocklog$enumaxis = BlockLog.EnumAxis.Z;
            }
        }
        return blocklog$enumaxis;
    }

    void generateLeaves() {
        for (FoliageCoordinates worldgenbigtree$foliagecoordinates : this.foliageCoords) {
            this.generateLeafNode(worldgenbigtree$foliagecoordinates);
        }
    }

    boolean leafNodeNeedsBase(int p_76493_1_) {
        return (double)p_76493_1_ >= (double)this.heightLimit * 0.2;
    }

    void generateTrunk() {
        BlockPos blockpos = this.basePos;
        BlockPos blockpos1 = this.basePos.func_177981_b(this.height);
        IBlockState state = PrimalAPI.Blocks.LOGS.func_176223_P().func_177226_a(ITypeLogs.TYPE, (Comparable)((Object)ITypeLogs.EnumType.YEW));
        this.limb(blockpos, blockpos1, state);
        if (this.trunkSize == 2) {
            this.limb(blockpos.func_177974_f(), blockpos1.func_177974_f(), state);
            this.limb(blockpos.func_177974_f().func_177968_d(), blockpos1.func_177974_f().func_177968_d(), state);
            this.limb(blockpos.func_177968_d(), blockpos1.func_177968_d(), state);
        }
    }

    void generateLeafNodeBases() {
        for (FoliageCoordinates worldgenbigtree$foliagecoordinates : this.foliageCoords) {
            int i = worldgenbigtree$foliagecoordinates.getBranchBase();
            BlockPos blockpos = new BlockPos(this.basePos.func_177958_n(), i, this.basePos.func_177952_p());
            if (blockpos.equals((Object)worldgenbigtree$foliagecoordinates) || !this.leafNodeNeedsBase(i - this.basePos.func_177956_o())) continue;
            this.limb(blockpos, worldgenbigtree$foliagecoordinates, PrimalAPI.Blocks.LOGS.func_176223_P().func_177226_a(ITypeLogs.TYPE, (Comparable)((Object)ITypeLogs.EnumType.YEW)));
        }
    }

    int checkBlockLine(BlockPos posOne, BlockPos posTwo) {
        BlockPos blockpos = posTwo.func_177982_a(-posOne.func_177958_n(), -posOne.func_177956_o(), -posOne.func_177952_p());
        int i = this.getGreatestDistance(blockpos);
        float f = (float)blockpos.func_177958_n() / (float)i;
        float f1 = (float)blockpos.func_177956_o() / (float)i;
        float f2 = (float)blockpos.func_177952_p() / (float)i;
        if (i == 0) {
            return -1;
        }
        for (int j = 0; j <= i; ++j) {
            BlockPos blockpos1 = posOne.func_177963_a((double)(0.5f + (float)j * f), (double)(0.5f + (float)j * f1), (double)(0.5f + (float)j * f2));
            if (this.isReplaceable(this.world, blockpos1)) continue;
            return j;
        }
        return -1;
    }

    public void func_175904_e() {
        this.leafDistanceLimit = 5;
    }

    public boolean func_180709_b(World world, Random rand, BlockPos pos) {
        this.world = world;
        this.basePos = pos;
        if (!world.func_190526_b(this.basePos.func_177958_n() >> 4, this.basePos.func_177952_p() >> 4)) {
            return false;
        }
        if (this.heightLimit == 0) {
            this.heightLimit = 5 + PrimalCore.RANDOM.nextInt(this.heightLimitLimit);
        }
        if (!this.validTreeLocation()) {
            this.world = null;
            return false;
        }
        this.generateLeafNodeList();
        this.generateLeaves();
        this.generateTrunk();
        this.generateLeafNodeBases();
        this.world = null;
        return true;
    }

    private boolean validTreeLocation() {
        BlockPos down = this.basePos.func_177977_b();
        IBlockState state = this.world.func_180495_p(down);
        boolean isSoil = state.func_177230_c().canSustainPlant(state, (IBlockAccess)this.world, down, EnumFacing.UP, (IPlantable)((BlockSapling)Blocks.field_150345_g));
        if (!isSoil) {
            return false;
        }
        int i = this.checkBlockLine(this.basePos, this.basePos.func_177981_b(this.heightLimit - 1));
        if (i == -1) {
            return true;
        }
        if (i < 6) {
            return false;
        }
        this.heightLimit = i;
        return true;
    }

    static class FoliageCoordinates
    extends BlockPos {
        private final int branchBase;

        public FoliageCoordinates(BlockPos pos, int p_i45635_2_) {
            super(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            this.branchBase = p_i45635_2_;
        }

        public int getBranchBase() {
            return this.branchBase;
        }
    }
}

