/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.world;

import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.WorldProviderHell;
import net.minecraft.world.biome.BiomeProviderSingle;
import net.minecraft.world.border.WorldBorder;
import net.minecraft.world.gen.ChunkGeneratorHell;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import nmd.primal.core.common.helper.WorldHelper;
import nmd.primal.core.common.helper.checks.BlockMultiplexer;
import nmd.primal.core.common.init.ModCompat;
import nmd.primal.core.common.init.ModConfig;

public class ProviderHell
extends WorldProviderHell {
    private final double DAY_LENGTH = ModConfig.Worldgen.SURFACE_DAY_LENGTH;
    private final boolean CAN_SPAWN = ModConfig.Worldgen.NETHER_ALLOW_RESPAWN;

    public void func_76572_b() {
        this.field_76578_c = new BiomeProviderSingle(Biomes.field_76778_j);
        this.field_76575_d = true;
        this.field_76576_e = true;
    }

    public IChunkGenerator func_186060_c() {
        return new ChunkGeneratorHell(this.field_76579_a, this.field_76579_a.func_72912_H().func_76089_r(), this.field_76579_a.func_72905_C());
    }

    public WorldBorder func_177501_r() {
        return new WorldBorder(){

            public double func_177731_f() {
                return super.func_177731_f() / 8.0;
            }

            public double func_177721_g() {
                return super.func_177721_g() / 8.0;
            }
        };
    }

    public float func_76563_a(long worldTime, float partialTicks) {
        return 0.5f;
    }

    public int func_76559_b(long worldTime) {
        return ModConfig.Worldgen.SURFACE_PROVIDER_OVERRIDE ? (int)(worldTime / (long)this.DAY_LENGTH % 8L + 8L) % 8 : super.func_76559_b(worldTime);
    }

    public boolean func_76567_e() {
        return this.CAN_SPAWN;
    }

    public boolean func_76566_a(int x, int z) {
        BlockPos blockpos = new BlockPos(x, 0, z);
        return this.field_76579_a.func_180494_b(blockpos).func_185352_i() || BlockMultiplexer.forBlock(Blocks.field_150424_aL, Blocks.field_150425_aM, ModCompat.NEX_NETHERRACK).apply(WorldHelper.getGroundAboveSeaLevel(this.field_76579_a, blockpos, 31));
    }

    public static IBlockState getGroundBelowRoof(World world, BlockPos pos, int rooflevel) {
        BlockPos blockpos = new BlockPos(pos.func_177958_n(), rooflevel, pos.func_177952_p());
        while (!world.func_175623_d(blockpos.func_177984_a())) {
            blockpos = blockpos.func_177984_a();
        }
        return world.func_180495_p(blockpos);
    }

    public int getRespawnDimension(EntityPlayerMP player) {
        return this.CAN_SPAWN ? player.getSpawnDimension() : DimensionType.OVERWORLD.func_186068_a();
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_76568_b(int x, int z) {
        return !ModConfig.Worldgen.NETHER_FOG_DISABLE;
    }

    @SideOnly(value=Side.CLIENT)
    public Vec3d func_76562_b(float p_76562_1_, float p_76562_2_) {
        return new Vec3d(ModConfig.Worldgen.NETHER_FOG_COLOR[0], ModConfig.Worldgen.NETHER_FOG_COLOR[1], ModConfig.Worldgen.NETHER_FOG_COLOR[2]);
    }
}

