/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.tiles.machines;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import nmd.primal.core.api.PrimalAPI;
import nmd.primal.core.api.events.HibachiEvent;
import nmd.primal.core.api.interfaces.crafting.ICacheRecipe;
import nmd.primal.core.api.interfaces.storage.IItemCrafting;
import nmd.primal.core.api.interfaces.storage.IItemFuel;
import nmd.primal.core.common.init.ModConfig;
import nmd.primal.core.common.recipes.tile.HibachiRecipe;
import nmd.primal.core.common.tiles.AbstractTileType;

public class TileHibachi
extends AbstractTileType
implements IItemFuel,
IItemCrafting,
ICacheRecipe<HibachiRecipe> {
    private ItemStackHandler craftingHandler = new ItemStackHandler(4){

        protected void onContentsChanged(int slot) {
            TileHibachi.this.updateBlock();
        }

        public int getSlotLimit(int slot) {
            return 1;
        }

        protected int getStackLimit(int slot, @Nonnull ItemStack stack) {
            return Math.min(this.getSlotLimit(slot), stack.func_77976_d());
        }

        public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
            HibachiRecipe recipe = TileHibachi.this.matchRecipe(stack);
            if (recipe != null) {
                TileHibachi.this.setRecipeTime(recipe, slot);
            }
            super.setStackInSlot(slot, stack);
        }

        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            boolean reachedLimit;
            if (stack.func_190926_b()) {
                return ItemStack.field_190927_a;
            }
            HibachiRecipe recipe = TileHibachi.this.matchRecipe(stack);
            if (recipe == null) {
                return stack;
            }
            this.validateSlotIndex(slot);
            ItemStack existing = (ItemStack)this.stacks.get(slot);
            int limit = this.getStackLimit(slot, stack);
            if (!existing.func_190926_b()) {
                if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)existing)) {
                    return stack;
                }
                limit -= existing.func_190916_E();
            }
            if (limit <= 0) {
                return stack;
            }
            boolean bl = reachedLimit = stack.func_190916_E() > limit;
            if (!simulate) {
                if (existing.func_190926_b()) {
                    this.stacks.set(slot, (Object)(reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)limit) : stack));
                } else {
                    existing.func_190917_f(reachedLimit ? limit : stack.func_190916_E());
                }
                TileHibachi.this.setRecipeTime(recipe, slot);
                this.onContentsChanged(slot);
            }
            return reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(stack.func_190916_E() - limit)) : ItemStack.field_190927_a;
        }
    };
    private ItemStackHandler fuelHandler = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            TileHibachi.this.updateBlock();
        }

        public int getSlotLimit(int slot) {
            return 64;
        }

        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            boolean reachedLimit;
            if (stack.func_190926_b()) {
                return ItemStack.field_190927_a;
            }
            int burn_time = TileEntityFurnace.func_145952_a((ItemStack)stack);
            if (burn_time <= 0) {
                return stack;
            }
            this.validateSlotIndex(slot);
            ItemStack existing = (ItemStack)this.stacks.get(slot);
            int limit = this.getStackLimit(slot, stack);
            if (!existing.func_190926_b()) {
                if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)existing)) {
                    return stack;
                }
                limit -= existing.func_190916_E();
            }
            if (limit <= 0) {
                return stack;
            }
            boolean bl = reachedLimit = stack.func_190916_E() > limit;
            if (!simulate) {
                if (existing.func_190926_b()) {
                    this.stacks.set(slot, (Object)(reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)limit) : stack));
                } else {
                    existing.func_190917_f(reachedLimit ? limit : stack.func_190916_E());
                }
                this.onContentsChanged(slot);
            }
            return reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(stack.func_190916_E() - limit)) : ItemStack.field_190927_a;
        }
    };
    private int fueltime;
    private int[] counters = new int[4];
    private List<HibachiRecipe> recipe_cache = new ArrayList<HibachiRecipe>();

    @Override
    public ItemStackHandler getFuelHandler() {
        return this.fuelHandler;
    }

    @Override
    public boolean isValidFuel(ItemStack stack) {
        return TileEntityFurnace.func_145952_a((ItemStack)stack) > 0;
    }

    public int getFuelBurnTime() {
        return TileEntityFurnace.func_145952_a((ItemStack)this.getFuelHandler().getStackInSlot(0));
    }

    public int getFuelTime() {
        return this.fueltime;
    }

    public void setFuelTime(int time) {
        this.fueltime = time >= 0 ? time : 0;
    }

    public void reduceFuelTime() {
        if (this.fueltime > 0) {
            int burn_amount = (int)Math.floor((float)this.fueltime * 0.15f);
            PrimalAPI.logger(22, "hibachi", "burning fuel: " + burn_amount);
            this.fueltime -= burn_amount > 0 ? burn_amount : 1;
        }
    }

    public void resetFuelTime() {
        this.setFuelTime(0);
    }

    @Override
    public ItemStackHandler getCraftingHandler() {
        return this.craftingHandler;
    }

    public int[] getSlotCounters() {
        return this.counters;
    }

    public int getSlotCount(int slot) {
        return this.counters.length > 0 ? this.counters[slot] : 0;
    }

    public void setSlotCounter(int slot, int count) {
        if (this.counters.length > 0) {
            this.counters[slot] = count;
        }
    }

    public void reduceSlotCounter(int slot) {
        if (this.counters.length > 0 && this.counters[slot] > 0) {
            int n = slot;
            this.counters[n] = this.counters[n] - 1;
        }
    }

    public void resetSlotCount(int slot) {
        this.setSlotCounter(slot, 0);
    }

    public void setRecipeTime(HibachiRecipe recipe, int slot) {
        int recipe_time = recipe.getCookTime();
        int modified_time = (int)Math.floor((double)recipe_time * ModConfig.Machines.HIBACHI_COOK_TIME_MODIFIER);
        int entropy = modified_time > 3 ? this.RANDOM.nextInt((int)Math.floor((float)modified_time * 0.35f)) : 0;
        this.setSlotCounter(slot, (modified_time > 0 ? modified_time : recipe_time) + entropy);
    }

    @Override
    public List<HibachiRecipe> getRecipeCache() {
        return this.recipe_cache;
    }

    public HibachiRecipe matchRecipe(ItemStack stack) {
        if (!stack.func_190926_b()) {
            for (HibachiRecipe recipe : this.getRecipeCache()) {
                if (!recipe.matches(stack)) continue;
                PrimalAPI.logger(22, "hibachi", "recipe match found from cache: " + recipe.getRegistryName());
                return recipe;
            }
            for (HibachiRecipe recipe : HibachiRecipe.RECIPES) {
                if (!recipe.matches(stack)) continue;
                PrimalAPI.logger(22, "hibachi", "recipe match found from registry: " + recipe.getRegistryName());
                this.addRecipeCache(recipe);
                return recipe;
            }
            if (ModConfig.Machines.HIBACHI_PICKUP_FURNACE_RECIPES) {
                for (HibachiRecipe recipe : HibachiRecipe.FURNACE_RECIPES) {
                    if (!recipe.matches(stack)) continue;
                    PrimalAPI.logger(22, "hibachi", "recipe match found from furnace: " + stack.func_77977_a());
                    this.addRecipeCache(recipe);
                    return recipe;
                }
            }
        }
        return null;
    }

    @Override
    @Deprecated
    public HibachiRecipe matchRecipe() {
        return null;
    }

    public void consumeFuel() {
        if (this.getFuelTime() > 0) {
            this.reduceFuelTime();
        } else {
            ItemStack spent_fuel = this.getFuelHandler().extractItem(0, 1, false);
            PrimalAPI.logger(22, "hibachi", "consume fuel: " + spent_fuel.func_77977_a());
            if (!spent_fuel.func_190926_b() && this.hasFuelItems()) {
                int burn_time = this.getFuelBurnTime();
                int modified_time = (int)Math.floor((double)burn_time * ModConfig.Machines.HIBACHI_FUEL_TIME_MODIFIER);
                this.setFuelTime(modified_time > 0 ? modified_time : burn_time);
            }
        }
    }

    public void cookItems(World world, BlockPos pos) {
        PrimalAPI.logger(22, "hibachi", "begin cooking");
        ItemStackHandler stackHandler = this.getCraftingHandler();
        for (int i = 0; i < stackHandler.getSlots(); ++i) {
            ItemStack stack = stackHandler.getStackInSlot(i);
            HibachiRecipe recipe = this.matchRecipe(stack);
            if (recipe == null || recipe.isDisabled()) continue;
            HibachiEvent event = new HibachiEvent(recipe, world, pos);
            if (MinecraftForge.EVENT_BUS.post((Event)event)) break;
            PrimalAPI.logger(22, "hibachi", "recipe matched and event passed: " + recipe.getRegistryName());
            if (this.getSlotCount(i) > 0) {
                this.reduceSlotCounter(i);
                continue;
            }
            if (recipe.getOutput().func_190926_b()) continue;
            PrimalAPI.logger(22, "hibachi", "cooked item: " + recipe.getOutput() + "@ slot " + i);
            this.resetSlotCount(i);
            this.getCraftingHandler().setStackInSlot(i, recipe.getOutput());
            world.func_184133_a(null, pos, SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 1.0f, this.RANDOM.nextFloat() * 0.4f + 0.8f);
        }
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && this.getCraftingHandler() != null && this.getFuelHandler() != null) {
            return (T)(facing == this.getFrontFace().func_176734_d() ? this.getFuelHandler() : this.getCraftingHandler());
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    public NBTTagCompound readNBT(NBTTagCompound nbt) {
        nbt = this.readCraftingHandler(nbt);
        nbt = this.readFuelHandler(nbt);
        this.fueltime = nbt.func_74762_e("fueltime");
        this.counters = nbt.func_74759_k("counters");
        return nbt;
    }

    @Override
    public NBTTagCompound writeNBT(NBTTagCompound nbt) {
        nbt = this.writeCraftingHandler(nbt);
        nbt = this.writeFuelHandler(nbt);
        nbt.func_74768_a("fueltime", this.getFuelTime());
        nbt.func_74783_a("counters", this.getSlotCounters());
        return nbt;
    }
}

