/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.tiles.machines;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import nmd.primal.core.api.PrimalAPI;
import nmd.primal.core.api.events.DryingEvent;
import nmd.primal.core.api.interfaces.crafting.ICacheRecipe;
import nmd.primal.core.api.interfaces.storage.IItemCrafting;
import nmd.primal.core.common.helper.CommonUtils;
import nmd.primal.core.common.helper.FireHelper;
import nmd.primal.core.common.helper.NBTHelper;
import nmd.primal.core.common.init.ModConfig;
import nmd.primal.core.common.items.foods.SaltedFood;
import nmd.primal.core.common.recipes.tile.DryingRecipe;
import nmd.primal.core.common.tiles.AbstractTileType;

public class TileDryingRack
extends AbstractTileType
implements IItemCrafting,
ICacheRecipe<DryingRecipe> {
    private ItemStackHandler craftingHandler = new ItemStackHandler(4){

        protected void onContentsChanged(int slot) {
            TileDryingRack.this.updateBlock();
            PrimalAPI.scheduleBlock(TileDryingRack.this.field_145850_b, TileDryingRack.this.field_174879_c, TileDryingRack.this.field_145850_b.func_180495_p(TileDryingRack.this.field_174879_c));
        }

        public int getSlotLimit(int slot) {
            return 1;
        }

        protected int getStackLimit(int slot, @Nonnull ItemStack stack) {
            return Math.min(this.getSlotLimit(slot), stack.func_77976_d());
        }

        public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
            DryingRecipe recipe = TileDryingRack.this.matchRecipe(stack);
            if (recipe != null) {
                TileDryingRack.this.setRecipeTime(recipe, slot);
            }
            super.setStackInSlot(slot, stack);
        }

        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            boolean reachedLimit;
            if (stack.func_190926_b()) {
                return ItemStack.field_190927_a;
            }
            DryingRecipe recipe = TileDryingRack.this.matchRecipe(stack);
            if (recipe == null) {
                return stack;
            }
            this.validateSlotIndex(slot);
            ItemStack existing = (ItemStack)this.stacks.get(slot);
            int limit = this.getStackLimit(slot, stack);
            if (!existing.func_190926_b()) {
                if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)existing)) {
                    return stack;
                }
                limit -= existing.func_190916_E();
            }
            if (limit <= 0) {
                return stack;
            }
            boolean bl = reachedLimit = stack.func_190916_E() > limit;
            if (!simulate) {
                if (existing.func_190926_b()) {
                    this.stacks.set(slot, (Object)(reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)limit) : stack));
                } else {
                    existing.func_190917_f(reachedLimit ? limit : stack.func_190916_E());
                }
                int recipe_time = recipe.getDryTime();
                int modified_time = (int)Math.floor((double)recipe_time * ModConfig.Machines.DRYING_RACK_DRY_TIME_MODIFIER);
                int entropy = modified_time > 3 ? TileDryingRack.this.RANDOM.nextInt((int)Math.floor((float)modified_time * 0.35f)) : 0;
                TileDryingRack.this.setSlotCounter(slot, (modified_time > 0 ? modified_time : recipe_time) + entropy);
                this.onContentsChanged(slot);
            }
            return reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(stack.func_190916_E() - limit)) : ItemStack.field_190927_a;
        }
    };
    private int[] counters = new int[4];
    private List<DryingRecipe> recipe_cache = new ArrayList<DryingRecipe>();

    @Override
    public ItemStackHandler getCraftingHandler() {
        return this.craftingHandler;
    }

    @Override
    public List<DryingRecipe> getRecipeCache() {
        return this.recipe_cache;
    }

    public DryingRecipe matchRecipe(ItemStack stack) {
        if (!stack.func_190926_b()) {
            for (DryingRecipe recipe : this.getRecipeCache()) {
                if (!recipe.matches(stack)) continue;
                PrimalAPI.logger(21, "drying rack", "recipe match found from cache: " + recipe.getRegistryName());
                return recipe;
            }
            for (DryingRecipe recipe : DryingRecipe.RECIPES) {
                if (!recipe.matches(stack)) continue;
                PrimalAPI.logger(21, "drying rack", "recipe match found from registry: " + recipe.getRegistryName());
                this.addRecipeCache(recipe);
                return recipe;
            }
        }
        return null;
    }

    @Override
    public DryingRecipe matchRecipe() {
        for (DryingRecipe recipe : this.getRecipeCache()) {
            if (!recipe.matches(this)) continue;
            return recipe;
        }
        for (DryingRecipe recipe : DryingRecipe.RECIPES) {
            if (!recipe.matches(this)) continue;
            this.addRecipeCache(recipe);
            return recipe;
        }
        return null;
    }

    public void dryItems(World world, BlockPos pos) {
        if (this.counters.length > 0) {
            boolean heat = FireHelper.hasNearByHeat(world, pos, 4, 3, true);
            boolean water = CommonUtils.hasNearByMaterial((IBlockAccess)world, pos, 2, 2, Material.field_151586_h);
            boolean light = (double)world.func_175724_o(pos) > 0.9;
            boolean rain = world.func_175727_C(pos.func_177984_a());
            PrimalAPI.logger(21, "drying rack", "light check: " + world.func_175642_b(EnumSkyBlock.SKY, pos) + " : " + world.func_175724_o(pos));
            PrimalAPI.logger(21, "drying rack", "heat check: " + heat);
            PrimalAPI.logger(21, "drying rack", "rain check: " + rain);
            PrimalAPI.logger(21, "drying rack", "water check: " + water);
            ItemStackHandler stackHandler = this.getCraftingHandler();
            for (int i = 0; i < stackHandler.getSlots(); ++i) {
                ItemStack stack = stackHandler.getStackInSlot(i);
                DryingRecipe recipe = this.matchRecipe(stack);
                if (recipe == null || recipe.isDisabled()) continue;
                DryingEvent event = new DryingEvent(recipe, world, pos);
                if (MinecraftForge.EVENT_BUS.post((Event)event)) break;
                int rot_chance = ModConfig.Machines.DRYING_RACK_ROT_MODIFIER + recipe.getRotChance();
                boolean is_salted = stack.func_77973_b() instanceof SaltedFood;
                if (heat || light) {
                    this.decrementSlotCounter(i);
                }
                if (rot_chance > 0) {
                    if (rain && !is_salted) {
                        rot_chance -= 25;
                    }
                    if (water && !is_salted) {
                        rot_chance -= 25;
                    }
                    if (!heat && !light) {
                        rot_chance -= 50;
                    }
                }
                PrimalAPI.logger(21, "drying rack", "recipe, slot:" + i + ", @" + pos + ", dry: " + recipe.getDryTime() + ", rot: " + recipe.getRotChance() + ", input: " + recipe.getInput() + ", output_items: " + recipe.getOutputSuccess() + ":" + recipe.getOutputFailed());
                if (this.getSlotCount(i) > 0) {
                    if (rain) {
                        PrimalAPI.logger(21, "drying rack", "rain is increasing slot time: " + i + ":" + (this.getSlotCount(i) + 1));
                        this.increaseSlotCounter(i);
                    } else {
                        PrimalAPI.logger(21, "drying rack", "slot is drying: " + i + ":" + (this.getSlotCount(i) - 1));
                        this.decrementSlotCounter(i);
                    }
                    if (recipe.getOutputFailed().func_190926_b() || rot_chance <= 0 || !PrimalAPI.randomCheck(rot_chance)) continue;
                    PrimalAPI.logger(21, "drying rack", "rot item: " + recipe.getInput() + ", " + recipe.getOutputFailed() + ":" + recipe.getOutputSuccess().func_190916_E() + "@ slot " + i);
                    this.resetSlotCount(i);
                    stackHandler.setStackInSlot(i, recipe.getOutputFailed());
                    continue;
                }
                if (recipe.getOutputSuccess().func_190926_b()) continue;
                PrimalAPI.logger(21, "drying rack", "dry item: " + recipe.getInput() + ", " + recipe.getOutputSuccess() + ":" + recipe.getOutputSuccess().func_190916_E() + "@ slot " + i);
                this.resetSlotCount(i);
                stackHandler.setStackInSlot(i, recipe.getOutputSuccess());
            }
        }
    }

    public int[] getSlotCounters() {
        return this.counters;
    }

    public int getSlotCount(int slot) {
        return this.counters.length > 0 ? this.counters[slot] : 0;
    }

    public void setSlotCounter(int slot, int count) {
        if (this.counters.length > 0) {
            this.counters[slot] = count;
        }
    }

    public void resetSlotCount(int slot) {
        this.setSlotCounter(slot, 0);
    }

    public void decrementSlotCounter(int slot) {
        if (this.counters.length > 0 && this.counters[slot] > 0) {
            int n = slot;
            this.counters[n] = this.counters[n] - 1;
        }
    }

    public void increaseSlotCounter(int slot) {
        if (this.counters != null && this.counters[slot] < 100) {
            int n = slot;
            this.counters[n] = this.counters[n] + 1;
        }
    }

    public void setRecipeTime(DryingRecipe recipe, int slot) {
        int recipe_time = recipe.getDryTime();
        int modified_time = (int)Math.floor((double)recipe_time * ModConfig.Machines.DRYING_RACK_DRY_TIME_MODIFIER);
        int entropy = modified_time > 3 ? this.RANDOM.nextInt((int)Math.floor((float)modified_time * 0.35f)) : 0;
        this.setSlotCounter(slot, (modified_time > 0 ? modified_time : recipe_time) + entropy);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && this.getCraftingHandler() != null) {
            return (T)this.getCraftingHandler();
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    public NBTTagCompound readNBT(NBTTagCompound nbt) {
        if (nbt.func_150297_b("crafting", 10)) {
            this.getCraftingHandler().deserializeNBT(nbt.func_74775_l("crafting"));
        } else {
            this.craftingHandler = new ItemStackHandler(this.getCraftingHandler().getSlots());
            NBTHelper.readNBTItems(nbt, this.getCraftingHandler(), "crafting");
        }
        this.counters = nbt.func_74759_k("counters");
        return nbt;
    }

    @Override
    public NBTTagCompound writeNBT(NBTTagCompound nbt) {
        nbt = this.writeCraftingHandler(nbt);
        nbt.func_74783_a("counters", this.getSlotCounters());
        return nbt;
    }
}

