/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.recipes.irecipe;

import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import nmd.primal.core.api.PrimalAPI;
import nmd.primal.core.api.interfaces.crafting.IToolHandler;
import nmd.primal.core.common.helper.CommonUtils;
import nmd.primal.core.common.helper.RecipeHelper;
import nmd.primal.core.common.helper.RegistryHelper;
import nmd.primal.core.common.recipes.irecipe.RecipeHandler;

@Deprecated
public class ToolCraftingRecipe {
    private static ArrayList<ToolRecipe> toolRecipes = new ArrayList();
    private static ArrayList<ToolName> toolNames = new ArrayList();

    public static void addName(EnumToolType tool_type, String ... tool_names) {
        for (String tool_name : tool_names) {
            toolNames.add(new ToolName(tool_type, tool_name));
        }
    }

    public static void registerNames() {
        for (Item item : ForgeRegistries.ITEMS.getValues()) {
            if (item instanceof IToolHandler) {
                PrimalAPI.logger(30, "toolHandler names", "item: " + item + ", REGISTRY_NAME: " + ToolCraftingRecipe.getToolNameString(((IToolHandler)item).getToolType()));
                RegistryHelper.registerDictionaryNames(new ItemStack(item, 1, Short.MAX_VALUE), ToolCraftingRecipe.getToolNameArray(((IToolHandler)item).getToolType()));
                continue;
            }
            PrimalAPI.logger(30, "toolHandler not valid", "item: " + item);
        }
    }

    public static EnumToolType getToolType(String tool_name) {
        for (ToolName tool : toolNames) {
            if (tool.tool_name != tool_name) continue;
            return tool.tool_type;
        }
        return EnumToolType.NONE;
    }

    public static String getToolNameString(EnumToolType tool_type) {
        StringBuilder names = new StringBuilder();
        for (ToolName tool : toolNames) {
            if (tool.tool_type != tool_type) continue;
            names.append(names.length() > 0 ? ", " + tool.tool_name : tool.tool_name);
        }
        return names.toString();
    }

    public static String[] getToolNameArray(EnumToolType tool_type) {
        return CommonUtils.splitString(ToolCraftingRecipe.getToolNameString(tool_type));
    }

    public static void addRecipe(EnumToolType tool_type, ItemStack output, Object[] input) {
        if (!output.func_190926_b()) {
            toolRecipes.add(new ToolRecipe(tool_type, output, input));
        }
    }

    public static void addRecipe(EnumToolType tool_type, ItemStack output, String input) {
        if (!output.func_190926_b()) {
            toolRecipes.add(new ToolRecipe(tool_type, output, input));
        }
    }

    public static void addRecipe(EnumToolType tool_type, ItemStack output, ItemStack input) {
        if (!output.func_190926_b()) {
            toolRecipes.add(new ToolRecipe(tool_type, output, input));
        }
    }

    public static void addRecipe(EnumToolType tool_type, ItemStack output, Item input) {
        if (!output.func_190926_b()) {
            toolRecipes.add(new ToolRecipe(tool_type, output, input));
        }
    }

    public static void addRecipe(EnumToolType tool_type, ItemStack output, Block input) {
        if (!output.func_190926_b()) {
            toolRecipes.add(new ToolRecipe(tool_type, output, input));
        }
    }

    public static void registerRecipes(EnumToolType tool_type) {
        for (ToolRecipe recipe : toolRecipes) {
            if (recipe.tool_type != tool_type) continue;
            for (ToolName tool : toolNames) {
                if (tool.tool_type != tool_type) continue;
                RecipeHandler.addShapedOreRecipe(recipe.output, true, recipe.input);
                toolRecipes.remove(recipe);
                toolNames.remove(tool);
            }
        }
    }

    public static void registerRecipes() {
        for (EnumToolType type : EnumToolType.values()) {
            for (ToolRecipe recipe : toolRecipes) {
                if (recipe.tool_type != type || recipe.output.func_190926_b()) continue;
                for (ToolName tool : toolNames) {
                    if (tool.tool_type != type) continue;
                    if (RecipeHelper.validateRecipeObject(recipe.input) && RecipeHelper.validateStackObject(recipe.input)) {
                        RecipeHandler.addShapedOreRecipe(recipe.output, true, new Object[]{"T", "A", Character.valueOf('T'), tool.tool_name, Character.valueOf('A'), recipe.input});
                        continue;
                    }
                    if (recipe.input instanceof Object[]) {
                        String[] strings;
                        Object[] input_array = (Object[])recipe.input;
                        for (String string : strings = CommonUtils.splitString(ToolCraftingRecipe.getToolNameString(type))) {
                            for (int i = 0; i < ((Object[])recipe.input).length; ++i) {
                                if (input_array[i] != "@") continue;
                                input_array[i] = string;
                            }
                            RecipeHandler.addShapedOreRecipe(recipe.output, true, recipe.input);
                        }
                        continue;
                    }
                    throw new RuntimeException("Invalid AbstractToolRecipe: " + recipe.input);
                }
            }
        }
        ToolCraftingRecipe.clear();
    }

    public static void clear() {
        toolRecipes.clear();
        toolNames.clear();
    }

    public static enum EnumToolType implements IStringSerializable
    {
        WORK_BLADE("work_blade", PrimalAPI.Sounds.SOUND_TOOL_BLADE_SCRAPE),
        HANDSAW_FLINT("handsaw_flint", PrimalAPI.Sounds.SOUND_TOOL_SAW_WOOD),
        HANDSAW_METAL("handsaw_metal", PrimalAPI.Sounds.SOUND_TOOL_SAW_WOOD),
        HANDSAW_GEM("handsaw_gem", PrimalAPI.Sounds.SOUND_TOOL_SAW_WOOD),
        MALLET_STONE("mallet_stone", SoundEvents.field_187698_i),
        MALLET_METAL("mallet_metal", SoundEvents.field_187698_i),
        FORGE_HAMMER("forge_hammer", SoundEvents.field_187698_i),
        STONE_BASIN("stone_basin", SoundEvents.field_187902_gb),
        FIRE_BOW("fire_bow", SoundEvents.field_187746_da),
        HATCHET("hatchet", PrimalAPI.Sounds.SOUND_TOOL_AXE_WOOD),
        CLIPPERS("clippers", SoundEvents.field_187763_eJ),
        SHEARS("shears", SoundEvents.field_187763_eJ),
        NONE("none", null);

        private static final EnumToolType[] META_LOOKUP;
        private final String name;
        private final SoundEvent toolSound;

        private EnumToolType(String name, SoundEvent toolSound) {
            this.name = name;
            this.toolSound = toolSound;
        }

        public String toString() {
            return this.name;
        }

        public String func_176610_l() {
            return this.name;
        }

        public SoundEvent getToolSound() {
            return this.toolSound;
        }

        public static ArrayList<EnumToolType> getHandSaws() {
            ArrayList<EnumToolType> list = new ArrayList<EnumToolType>();
            for (EnumToolType blocks$enumtype : EnumToolType.values()) {
                if (!blocks$enumtype.func_176610_l().contains("handsaw")) continue;
                list.add(blocks$enumtype);
            }
            return list;
        }

        public static int getOutputModifier(EnumToolType type) {
            switch (type) {
                case HANDSAW_METAL: {
                    return 1;
                }
                case HANDSAW_GEM: {
                    return 2;
                }
            }
            return 0;
        }

        public static int getBasePlankOutput(EnumToolType type) {
            switch (type) {
                case HANDSAW_METAL: 
                case HANDSAW_GEM: 
                case HANDSAW_FLINT: {
                    return 4;
                }
            }
            return 2;
        }

        static {
            META_LOOKUP = new EnumToolType[EnumToolType.values().length];
            EnumToolType[] enumToolTypeArray = EnumToolType.values();
            int n = enumToolTypeArray.length;
            for (int i = 0; i < n; ++i) {
                EnumToolType blocks$enumtype;
                EnumToolType.META_LOOKUP[blocks$enumtype.ordinal()] = blocks$enumtype = enumToolTypeArray[i];
            }
        }
    }

    private static class ToolName {
        private EnumToolType tool_type;
        private String tool_name;

        private ToolName(EnumToolType tool_type, String tool_name) {
            this.tool_type = tool_type;
            this.tool_name = tool_name;
        }
    }

    private static class ToolRecipe {
        private EnumToolType tool_type;
        private ItemStack output;
        private Object input;

        private ToolRecipe(EnumToolType tool_type, ItemStack output, Object input) {
            this.tool_type = tool_type;
            this.output = output;
            this.input = input;
            if (tool_type == null) {
                throw new IllegalArgumentException("[ToolCraftingRecipe] Invalid ToolType, recipe must specify which inworld group the recipe is intended for");
            }
            if (output.func_190926_b()) {
                throw new IllegalArgumentException("[ToolCraftingRecipe] Invalid output_items, output_items ItemStack cannot be empty");
            }
            if (input == null) {
                throw new IllegalArgumentException("[ToolCraftingRecipe] Invalid Input, something is wrong with your input object");
            }
        }
    }
}

