/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.items.tools;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockLog;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import nmd.primal.core.api.PrimalAPI;
import nmd.primal.core.api.events.BladeEvent;
import nmd.primal.core.api.interfaces.IFace;
import nmd.primal.core.common.PrimalCore;
import nmd.primal.core.common.helper.RecipeHelper;
import nmd.primal.core.common.helper.checks.MaterialMultiplexer;
import nmd.primal.core.common.items.tools.PrimalSword;
import nmd.primal.core.common.recipes.inworld.BladeRecipe;
import nmd.primal.core.common.recipes.irecipe.ToolCraftingRecipe;

public class WorkBlade
extends PrimalSword {
    public WorkBlade(Item.ToolMaterial material, float damage, float speed) {
        super(material, damage, speed);
        this.func_77656_e(material.func_77997_a() * 2);
        this.setHarvestLevel("workblade", material.func_77996_d());
    }

    public WorkBlade(Item.ToolMaterial material, float speed) {
        super(material, material.func_78000_c() - 1.0f, speed);
    }

    public WorkBlade(Item.ToolMaterial material) {
        this(material, -2.5f);
    }

    @Override
    public ToolCraftingRecipe.EnumToolType getToolType() {
        return ToolCraftingRecipe.EnumToolType.WORK_BLADE;
    }

    @Override
    public void func_77624_a(ItemStack stack, @Nullable World player, List<String> tooltip, ITooltipFlag advanced) {
        tooltip.add(TextFormatting.GREEN + I18n.func_74838_a((String)"tooltip.info.primal.abstract_grid_crafting_tool"));
        tooltip.add(TextFormatting.GREEN + I18n.func_74838_a((String)"tooltip.info.primal.abstract_world_crafting_tool"));
        tooltip.add(TextFormatting.BLUE + I18n.func_74838_a((String)"tooltip.info.primal.abstract_plant_harvest"));
        super.func_77624_a(stack, player, tooltip, advanced);
    }

    public boolean hasContainerItem(ItemStack stack) {
        return stack.func_77952_i() < this.getMaxDamage(stack);
    }

    public ItemStack getContainerItem(ItemStack stack) {
        ItemStack container = stack.func_77946_l();
        container.func_96631_a(1, (Random)PrimalCore.RANDOM, null);
        return container;
    }

    @Override
    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        stack.func_77972_a(1, attacker);
        return true;
    }

    @Override
    public boolean func_179218_a(ItemStack stack, World world, IBlockState state, BlockPos pos, EntityLivingBase entity) {
        if ((double)state.func_185887_b(world, pos) != 0.0) {
            stack.func_77972_a(1, entity);
        }
        return true;
    }

    @Override
    public float func_150893_a(ItemStack stack, IBlockState state) {
        if (MaterialMultiplexer.forMaterial(Material.field_151569_G, Material.field_151585_k, Material.field_151582_l, Material.field_151584_j, Material.field_151580_n, Material.field_151593_r, Material.field_151594_q, Material.field_151589_v).apply(state)) {
            return 15.0f;
        }
        return super.func_150893_a(stack, state);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        if (!player.func_70093_af() || player.field_82175_bq) {
            return EnumActionResult.PASS;
        }
        IBlockState state = world.func_180495_p(pos);
        for (BladeRecipe recipe : BladeRecipe.RECIPES) {
            int modifier;
            if (!recipe.match(state)) continue;
            world.func_184148_a(player, player.field_70165_t, player.field_70163_u, player.field_70161_v, recipe.getSound(), SoundCategory.PLAYERS, 1.0f, 1.0f);
            int level = this.material.func_77996_d();
            int n = level > 3 ? 1 : (modifier = level > 1 ? 4 - level : 4);
            if (PrimalAPI.randomCheck(modifier)) {
                BladeEvent pre = new BladeEvent(recipe, player, pos);
                if (MinecraftForge.EVENT_BUS.post((Event)pre)) {
                    return EnumActionResult.SUCCESS;
                }
                ItemStack output = ItemStack.field_190927_a;
                if (!recipe.getOutputStack().func_190926_b() && recipe.getOutputAmount() > 0) {
                    output = recipe.getOutputStack();
                    output.func_190920_e(recipe.getOutputAmount());
                }
                switch (recipe.getFacing()) {
                    case FACING: {
                        RecipeHelper.craftBlockAction(world, pos, player, stack, recipe.getOutputState().func_177226_a((IProperty)IFace.FACING, (Comparable)player.func_174811_aO()), output);
                        break;
                    }
                    case LOG: {
                        RecipeHelper.craftBlockAction(world, pos, player, stack, recipe.getOutputState().func_177226_a((IProperty)BlockLog.field_176299_a, state.func_177229_b((IProperty)BlockLog.field_176299_a)), output);
                        break;
                    }
                    default: {
                        RecipeHelper.craftBlockAction(world, pos, player, stack, recipe.getOutputState(), output);
                    }
                }
                MinecraftForge.EVENT_BUS.post((Event)new BladeEvent.Post(recipe, player, pos));
            }
            return EnumActionResult.SUCCESS;
        }
        return super.func_180614_a(player, world, pos, hand, facing, hitX, hitY, hitZ);
    }
}

