/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.items.block;

import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import nmd.primal.core.api.PrimalAPI;
import nmd.primal.core.api.interfaces.types.ITypeBarrels;
import nmd.primal.core.api.interfaces.types.ITypeWood;
import nmd.primal.core.common.PrimalCore;
import nmd.primal.core.common.items.block.AbstractItemBlock;
import nmd.primal.core.common.tiles.machines.TileBarrel;

public class ItemBarrel
extends AbstractItemBlock
implements ITypeBarrels {
    public ItemBarrel(Block block) {
        super(block, true);
        this.func_77625_d(1);
        this.func_185043_a(new ResourceLocation("covered"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entity) {
                NBTTagCompound nbt = stack.func_179543_a("BlockEntityTag");
                return nbt != null && nbt.func_74767_n("covered") ? 1.0f : 0.0f;
            }
        });
    }

    @Override
    public boolean isFireProof(ItemStack stack) {
        return ITypeWood.EnumType.byMetadata(stack.func_77960_j()).getFlammability() == 0;
    }

    @Override
    public String func_77667_c(ItemStack stack) {
        return super.func_77658_a() + "_" + ITypeWood.EnumType.byMetadata(stack.func_77952_i()).func_176610_l();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            this.getTypes((Item)this, tab, items);
        }
    }

    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, IBlockState newState) {
        if (!world.func_180501_a(pos, newState, 11)) {
            return false;
        }
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() == this.field_150939_a) {
            ItemBarrel.setTileEntityNBT(world, player, pos, stack);
            this.field_150939_a.func_180633_a(world, pos, state, (EntityLivingBase)player, stack);
            if (player instanceof EntityPlayerMP) {
                CriteriaTriggers.field_193137_x.func_193173_a((EntityPlayerMP)player, pos, stack);
            }
        }
        return true;
    }

    public static boolean setTileEntityNBT(World world, @Nullable EntityPlayer player, BlockPos pos, ItemStack stack) {
        TileEntity tile;
        MinecraftServer minecraftserver = world.func_73046_m();
        if (minecraftserver == null) {
            return false;
        }
        NBTTagCompound nbt = stack.func_179543_a("BlockEntityTag");
        if (nbt != null && (tile = world.func_175625_s(pos)) != null && !tile.func_145837_r()) {
            FluidStack fluidStack;
            TileBarrel barrel;
            IFluidHandler fluidHandler;
            if (!(world.field_72995_K || !tile.func_183000_F() || player != null && player.func_189808_dh())) {
                return false;
            }
            NBTTagCompound nbttagcompound1 = tile.func_189515_b(new NBTTagCompound());
            NBTTagCompound nbttagcompound2 = nbttagcompound1.func_74737_b();
            nbttagcompound1.func_179237_a(nbt);
            nbttagcompound1.func_74768_a("x", pos.func_177958_n());
            nbttagcompound1.func_74768_a("y", pos.func_177956_o());
            nbttagcompound1.func_74768_a("z", pos.func_177952_p());
            if (!nbttagcompound1.equals((Object)nbttagcompound2)) {
                tile.func_145839_a(nbttagcompound1);
                tile.func_70296_d();
            }
            if (tile instanceof TileBarrel && (fluidHandler = (IFluidHandler)(barrel = (TileBarrel)tile).getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null)) != null && (fluidStack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbt)) != null) {
                PrimalAPI.logger(25, "barrel", "placing fluid: " + fluidStack.getFluid().getName() + ", " + fluidStack.amount);
                if (fluidHandler.fill(fluidStack, false) == fluidStack.amount) {
                    fluidHandler.fill(fluidStack, true);
                    barrel.updateBlock();
                    world.func_184133_a(null, pos, SoundEvents.field_187624_K, SoundCategory.BLOCKS, 0.5f, PrimalCore.RANDOM.nextFloat() * 0.4f + 0.8f);
                }
            }
            return true;
        }
        return false;
    }
}

