/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.init;

import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import nmd.primal.core.api.PrimalAPI;
import nmd.primal.core.common.PrimalCore;
import nmd.primal.core.common.helper.FoodValue;

@Config(modid="primal", name="primal/primal", category="")
@Config.LangKey(value="primal.config.title")
public final class ModConfig {
    public static Compatibility compatibility;
    public static Features features;
    public static Flammability flammability;
    public static Lighting lighting;
    public static Plants plants;
    public static Foods foods;
    public static Fluids fluids;
    public static Machines machines;
    public static Monsters monsters;
    public static Survival survival;
    public static Worldgen worldgen;
    public static Development development;

    static {
        PrimalAPI.logger(1, "Loading Config File: primal/primal.cfg");
    }

    @Mod.EventBusSubscriber
    private static class EventHandler {
        private EventHandler() {
        }

        @SubscribeEvent
        public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (event.getModID().equals("primal")) {
                ConfigManager.sync((String)"primal", (Config.Type)Config.Type.INSTANCE);
            }
        }
    }

    public static class BlockFall {
        public String block_name;
        public float damage_modifier;
        public float break_modifier;
        public boolean drop_block;

        BlockFall(String block_name, float damage_modifier, float break_modifier, boolean drop_block) {
            this.block_name = block_name;
            this.damage_modifier = damage_modifier;
            this.break_modifier = break_modifier;
            this.drop_block = drop_block;
        }
    }

    public static class CharcoalPit {
        public int min;
        public int max;

        CharcoalPit(int min, int max) {
            this.min = Math.max(1, min);
            this.max = Math.max(1, max);
        }

        public int getOutput() {
            return this.max > this.min ? PrimalCore.RANDOM.nextInt(this.min, this.max) : this.min;
        }
    }

    public static class Foods {
        @Config.RequiresMcRestart
        @Config.Comment(value={"Primal Foods can be consumed even when full, but at the peril of potential side effects."})
        public static boolean FOOD_PLAYER_CAN_OVER_EAT = false;
        @Config.RequiresMcRestart
        @Config.Comment(value={"Hunger Amount and Saturation modifier applied to salted food items"})
        public static FoodValue FOOD_VALUE_MODIFIER_SALTED = new FoodValue(1, 0.2f);
        @Config.RequiresMcRestart
        @Config.Comment(value={"Hunger Amount and Saturation modifier applied to dried food items"})
        public static FoodValue FOOD_VALUE_MODIFIER_DRIED = new FoodValue(3, 0.4f);
        @Config.RequiresMcRestart
        @Config.Comment(value={"Hunger Amount and Saturation modifier applied to cured food items"})
        public static FoodValue FOOD_VALUE_MODIFIER_CURED = new FoodValue(4, 0.6f);
        @Config.RequiresMcRestart
        @Config.Comment(value={"Hunger Amount and Saturation modifier applied to cooked food items"})
        public static FoodValue FOOD_VALUE_MODIFIER_COOKED = new FoodValue(5, 0.6f);
        @Config.RequiresMcRestart
        @Config.Comment(value={"Hunger Amount and Saturation"})
        public static FoodValue FOOD_VALUE_ANIMAL_FAT = new FoodValue(1, 0.8f);
        @Config.RequiresMcRestart
        @Config.Comment(value={"Hunger Amount and Saturation"})
        public static FoodValue FOOD_VALUE_LARD_SUET = new FoodValue(1, 0.8f);
        @Config.RequiresMcRestart
        @Config.Comment(value={"Hunger Amount and Saturation"})
        public static FoodValue FOOD_VALUE_SALO = new FoodValue(4, 1.0f);
        @Config.RequiresMcRestart
        @Config.Comment(value={"Hunger Amount and Saturation"})
        public static FoodValue FOOD_VALUE_CHUM = new FoodValue(1, 0.5f);
        @Config.RequiresMcRestart
        @Config.Comment(value={"Hunger Amount and Saturation"})
        public static FoodValue FOOD_VALUE_ROT = new FoodValue(1, 0.0f);
        @Config.RequiresMcRestart
        @Config.Comment(value={"Hunger Amount and Saturation"})
        public static FoodValue FOOD_VALUE_LAVA_WORM = new FoodValue(2, 0.2f);
        @Config.RequiresMcRestart
        @Config.Comment(value={"Hunger Amount and Saturation"})
        public static FoodValue FOOD_VALUE_LAVA_CRAWDAD = new FoodValue(2, 0.2f);
        @Config.RequiresMcRestart
        @Config.Comment(value={"Hunger Amount and Saturation"})
        public static FoodValue FOOD_VALUE_SHARK = new FoodValue(2, 0.2f);
        @Config.RequiresMcRestart
        @Config.Comment(value={"Hunger Amount and Saturation"})
        public static FoodValue FOOD_VALUE_GATOR = new FoodValue(2, 0.2f);
        @Config.RequiresMcRestart
        @Config.Comment(value={"Hunger Amount and Saturation"})
        public static FoodValue FOOD_VALUE_HORSE = new FoodValue(3, 0.3f);
        @Config.RequiresMcRestart
        @Config.Comment(value={"Hunger Amount and Saturation"})
        public static FoodValue FOOD_VALUE_BEAR = new FoodValue(3, 0.3f);
        @Config.RequiresMcRestart
        @Config.Comment(value={"Hunger Amount and Saturation"})
        public static FoodValue FOOD_VALUE_LLAMA = new FoodValue(2, 0.4f);
        @Config.RequiresMcRestart
        @Config.Comment(value={"Hunger Amount and Saturation"})
        public static FoodValue FOOD_VALUE_BAT = new FoodValue(2, 0.2f);
        @Config.RequiresMcRestart
        @Config.Comment(value={"Hunger Amount and Saturation"})
        public static FoodValue FOOD_VALUE_WOLF = new FoodValue(2, 0.2f);
        @Config.RequiresMcRestart
        @Config.Comment(value={"Hunger Amount and Saturation"})
        public static FoodValue FOOD_VALUE_OVIS = new FoodValue(3, 0.2f);
        @Config.RequiresMcRestart
        @Config.Comment(value={"Hunger Amount and Saturation"})
        public static FoodValue FOOD_VALUE_PIGMAN = new FoodValue(3, 0.4f);
        @Config.RequiresMcRestart
        @Config.Comment(value={"Hunger Amount and Saturation"})
        public static FoodValue FOOD_VALUE_CHEESES = new FoodValue(5, 0.8f);
        @Config.Comment(value={"Hunger Amount and Saturation"})
        public static FoodValue FOOD_VALUE_OVIS_ATRE_MILK = new FoodValue(6, 0.8f);
        @Config.RequiresMcRestart
        @Config.Comment(value={"Hunger Amount and Saturation"})
        public static FoodValue FOOD_VALUE_CORN_COB = new FoodValue(1, 0.2f);
        @Config.RequiresMcRestart
        @Config.Comment(value={"Hunger Amount and Saturation"})
        public static FoodValue FOOD_VALUE_CORN_BREAD = new FoodValue(5, 0.6f);
        @Config.RequiresMcRestart
        @Config.Comment(value={"Hunger Amount and Saturation"})
        public static FoodValue FOOD_VALUE_DAUCUS_ROOT = new FoodValue(5, 0.6f);
        @Config.RequiresMcRestart
        @Config.Comment(value={"Hunger Amount and Saturation"})
        public static FoodValue FOOD_VALUE_VALUS_MELON = new FoodValue(3, 0.2f);
        @Config.RequiresMcRestart
        @Config.Comment(value={"Hunger Amount and Saturation"})
        public static FoodValue FOOD_VALUE_VALUS_BREAD = new FoodValue(5, 0.6f);
        @Config.RequiresMcRestart
        @Config.Comment(value={"Hunger Amount and Saturation"})
        public static FoodValue FOOD_VALUE_PUMPKIN_PIECE = new FoodValue(2, 0.3f);
        @Config.RequiresMcRestart
        @Config.Comment(value={"Hunger Amount and Saturation"})
        public static FoodValue FOOD_VALUE_EGG_BOILED = new FoodValue(3, 0.8f);
        @Config.RequiresMcRestart
        @Config.Comment(value={"Hunger Amount and Saturation"})
        public static FoodValue FOOD_VALUE_POTATO_BOILED = new FoodValue(2, 0.4f);
        @Config.RequiresMcRestart
        @Config.Comment(value={"Hunger Amount and Saturation"})
        public static FoodValue FOOD_VALUE_MUSHROOM_COOKED = new FoodValue(3, 0.2f);
        @Config.RequiresMcRestart
        @Config.Comment(value={"Hunger Amount and Saturation"})
        public static FoodValue FOOD_VALUE_SINUOUS_RESIN = new FoodValue(1, 0.1f);
    }

    public static class Development {
        @Config.Comment(value={"..."})
        public static Integer[] LOG_FILTER = new Integer[0];
        @Config.Comment(value={"Max distance squared that tile rending for things such as shelf items will occur. Setting to 0 effectively disables rendering."})
        @Config.RangeInt(min=0, max=32)
        public static double TILE_RENDER_DISTANCE = 16.0;
        public static double TILE_RENDER_DISTANCE_SQUARE = TILE_RENDER_DISTANCE * TILE_RENDER_DISTANCE;
        @Config.RequiresMcRestart
        @Config.Comment(value={"Hide colored wattle blocks in creative menu and jei"})
        public static boolean HIDE_CREATIVE_COLORED_WATTLE = false;
        @Config.RequiresMcRestart
        @Config.Comment(value={"Used for dev environments"})
        public static boolean ENABLE_PLAYER_TESTING = false;
        @Config.Comment(value={"Enable rendering for items held in the work table crafting grids"})
        public static boolean ENABLE_WORKTABLE_RENDERING = true;
        @Config.Comment(value={"Globally Enable TESRs for all Primal Tile Entity blocks with special rendering, shelves, racks, barrels, etc"})
        public static boolean ENABLE_TESR = true;
        @Config.Comment(value={"Max ID range for the forge registries used to store custom recipes, default is 0-1000"})
        @Config.RangeInt(min=1, max=10000)
        public static int RECIPE_REGISTRY_MAX_ID = 1000;
    }

    public static class Worldgen {
        @Config.Comment(value={"Global control for all primal Overworld worldgen"})
        public static boolean ENABLE_GENERATION_OVERWORLD = true;
        @Config.Comment(value={"Global control for all primal Nether worldgen"})
        public static boolean ENABLE_GENERATION_NETHER = true;
        @Config.Comment(value={"Global control for all primal End worldgen"})
        public static boolean ENABLE_GENERATION_END = true;
        @Config.Comment(value={"Allow Overworld generation to take place in unknown dimensions"})
        public static boolean ENABLE_MOD_DIMENSIONS = true;
        @Config.RequiresMcRestart
        @Config.Comment(value={"Override the Overworld World Provider, allows or changing length od day and night, this will conflict with such mods as StallearSky"})
        public static boolean SURFACE_PROVIDER_OVERRIDE = false;
        @Config.RequiresMcRestart
        @Config.Comment(value={"The length of a minecraft day in ticks, vanilla default is 24000.0. This feature requires SURFACE_PROVIDER_OVERRIDE set to true."})
        @Config.RangeDouble(min=24000.0, max=1728000.0)
        public static double SURFACE_DAY_LENGTH = 96000.0;
        @Config.RequiresMcRestart
        @Config.Comment(value={"Override the Nether World Provider, allows Nether spawn mechanics and additional features but could conflict with mods such as BOP or Natura"})
        public static boolean NETHER_PROVIDER_OVERRIDE = false;
        @Config.RequiresMcRestart
        @Config.Comment(value={"Enable spawning in the nether, this is used only when NETHER_PROVIDER_OVERRIDE is also set to true"})
        public static boolean NETHER_ALLOW_RESPAWN = false;
        @Config.RequiresMcRestart
        @Config.Comment(value={"Disable Nether Fog, this is used only when NETHER_PROVIDER_OVERRIDE is also set to true"})
        public static boolean NETHER_FOG_DISABLE = false;
        @Config.Comment(value={"Force Nether Fog Density, this helps if you want to modify the normal fog level or want to override something that removes fog yet doesn't provide a simple config to restore it (BOP). Vanilla level is approximately 0.02"})
        @Config.RangeDouble(min=0.0, max=1.0)
        public static double NETHER_FOG_DENSITY_OVERRIDE = 0.0;
        @Config.Comment(value={"Nether Fog Color"})
        public static double[] NETHER_FOG_COLOR = new double[]{0.2f, 0.03f, 0.03f};
        @Config.Comment(value={"Enable Worldgen for Carbonate/Limestone Stone, appears primarily in the Overworld"})
        public static boolean ENABLE_CARBONATE_STONE = true;
        @Config.Comment(value={"Enable Worldgen for Ferrocalcite Stone, appears primarily in the Nether"})
        public static boolean ENABLE_FERRO_STONE = true;
        @Config.Comment(value={"Enable Worldgen for Sarsen Stone, appears primarily in the Overworld"})
        public static boolean ENABLE_SARSEN_STONE = true;
        @Config.Comment(value={"Enable Worldgen for Blue Stone, appears primarily in the Overworld"})
        public static boolean ENABLE_BLUE_STONE = true;
        @Config.Comment(value={"Enable Worldgen for Ortho Stone, appears primarily in the Overworld"})
        public static boolean ENABLE_ORTHO_STONE = true;
        @Config.Comment(value={"Enable Worldgen for Greenschist Stone, appears primarily in the Overworld"})
        public static boolean ENABLE_GREEN_SCHIST = true;
        @Config.Comment(value={"Enable Worldgen for Blueschist Stone, appears primarily in the Overworld"})
        public static boolean ENABLE_BLUE_SCHIST = true;
        @Config.Comment(value={"Enable Worldgen for Night Stone, appears in the End"})
        public static boolean ENABLE_NIGHT_STONE = true;
        @Config.Comment(value={"Enable Worldgen for Eroded Stone, appears in the End"})
        public static boolean ENABLE_ERODED_END_STONE = true;
        @Config.Comment(value={"Enable Worldgen for Purpurite Stone, appears in the End"})
        public static boolean ENABLE_PURPURITE_STONE = true;
        @Config.Comment(value={"Enable Worldgen for Scoria Stone, appears mostly in the Nether"})
        public static boolean ENABLE_SCORIA_STONE = true;
        @Config.Comment(value={"Enable Worldgen for Satetsu, the Iron Sand, appears mostly in the Overworld"})
        public static boolean ENABLE_SATETSU = true;
        @Config.Comment(value={"Enable Worldgen for Magnetite Ore, this is used by Primal and Kitsu's ForgeCraft"})
        public static boolean ENABLE_MAGNETITE = true;
        @Config.Comment(value={"Enable Worldgen for Zinc Ore, this is used by Kitsu's ForgeCraft and MagnumOpus"})
        public static boolean ENABLE_ZINC = true;
        @Config.Comment(value={"Enable Worldgen for Bog Iron Ores, this generates along with mud, terra and cinis clays"})
        public static boolean ENABLE_BOG_IRON = true;
        @Config.Comment(value={"Enable Worldgen for Blood Opals, this is essentially nether equivalent of diamonds"})
        public static boolean ENABLE_OPAL = true;
        @Config.Comment(value={"Enable Worldgen for Bitumen Fluid, appears in the Overworld and the Nether"})
        public static boolean ENABLE_BITUMEN = true;
        @Config.Comment(value={"Enable Worldgen for Brine Fluid, appears in the Overworld"})
        public static boolean ENABLE_BRINE = true;
        @Config.Comment(value={"Enable Worldgen for Magma Fluid, appears in the Nether"})
        public static boolean ENABLE_MAGMA = true;
        @Config.Comment(value={"Enable Worldgen for Paraffin Earth Wax, appears in the Overworld"})
        public static boolean ENABLE_EARTHWAX = true;
        @Config.Comment(value={"Enable Worldgen for Calcified Paraffin fuel, appears in the Nether"})
        public static boolean ENABLE_NETHERWAX = true;
        @Config.Comment(value={"Enable Worldgen for Terracotta ClayLike, appears in Overworld"})
        public static boolean ENABLE_TERRACOTTA = true;
        @Config.Comment(value={"Enable Worldgen for Ciniscotta ClayLike, appears primarily in the Nether"})
        public static boolean ENABLE_CINISCOTTA = true;
        @Config.Comment(value={"Enable Worldgen for MudWet, appears in the Overworld near water"})
        public static boolean ENABLE_MUD = true;
        @Config.Comment(value={"Enable Worldgen for Rushes, primary resource for making Thatch, appears in the Overworld near water"})
        public static boolean ENABLE_RUSHES = true;
        @Config.Comment(value={"Enable Worldgen for PrimalPotion, appears in the Overworld in forested areas"})
        public static boolean ENABLE_ACONITE = true;
        @Config.Comment(value={"Enable Worldgen for Corn, appears in the Overworld"})
        public static boolean ENABLE_WILD_CORN = true;
        @Config.Comment(value={"Enable Worldgen for Nether Grass, early game Nether progression"})
        public static boolean ENABLE_CINERIS_CILIUM = true;
        @Config.Comment(value={"Enable Worldgen for Nether Dead Bushes, early game Nether progression"})
        public static boolean ENABLE_NETHER_DEADBUSH = true;
        @Config.Comment(value={"Enable Worldgen for Nether Palm wood, also known as Corypha Pachyptila, early game Nether progression"})
        public static boolean ENABLE_NETHER_PALM = true;
        @Config.Comment(value={"Enable Worldgen for Nether Vines, early game Nether progression"})
        public static boolean ENABLE_NETHER_VINES = true;
        @Config.Comment(value={"Enable Worldgen for Nether Creep, early game Nether progression"})
        public static boolean ENABLE_NETHER_CREEP = true;
        @Config.Comment(value={"Enable Worldgen for Strangle Weed Vines, early game Nether progression"})
        public static boolean ENABLE_STRANGLE_WEED = true;
        @Config.Comment(value={"Enable Worldgen for Sinuous Weed, dangerous reed-like nether canNewGrow"})
        public static boolean ENABLE_SINUOUS_WEED = true;
        @Config.Comment(value={"Enable Worldgen for the Valus Omniferum plant, grows in the Nether"})
        public static boolean ENABLE_VALUS_OMNIFERUM = true;
        @Config.Comment(value={"Enable Worldgen for the Daucus Murn plant, grows in the Nether"})
        public static boolean ENABLE_DAUCUS_MURN = true;
        @Config.Comment(value={"Enable Worldgen for the Devils' Tongue plant, grows in the Nether"})
        public static boolean ENABLE_DEVILS_TONGUE = true;
        @Config.Comment(value={"Enable Worldgen for Nether Growth blocks, a rare nether resource"})
        public static boolean ENABLE_NETHER_GROWTH = true;
        @Config.Comment(value={"Enable Worldgen for Nether Earth blocks, used as a building material and nether farming"})
        public static boolean ENABLE_NETHER_EARTH = true;
        @Config.Comment(value={"Enable Worldgen for Void Grass, expands consciousness and is vital to space travel"})
        public static boolean ENABLE_INERIS_CILIUM = true;
        @Config.Comment(value={"Enable Worldgen for Ironwood wood, appear primarily in the Overworld"})
        public static boolean ENABLE_IRONWOOD_TREES = true;
        @Config.Comment(value={"Enable Worldgen for Yew wood, appear primarily in the Overworld"})
        public static boolean ENABLE_YEW_TREES = true;
        @Config.Comment(value={"Enable Worldgen for Netjry Salt Falts, appears primarily in the Overworld"})
        public static boolean ENABLE_SALT_FLATS = true;
        @Config.Comment(value={"Enable Worldgen for Halite Rock Salt, appears primarily in the Overworld"})
        public static boolean ENABLE_SALT_ROCK = true;
        @Config.Comment(value={"Enable Worldgen for Fire Rock Salt, early game Nether progression"})
        public static boolean ENABLE_SALT_NETHER = true;
        @Config.Comment(value={"Enable Worldgen for Ancient Ice"})
        public static boolean ENABLE_ANCIENT_ICE = true;
        @Config.Comment(value={"Enable Worldgen for End Rock Salt, early game End progression"})
        public static boolean ENABLE_SALT_END = true;
        @Config.Comment(value={"Enable Worldgen for Primal Iron AbstractOre, this generates in large deposits with ore blocks of varying density. EXPERIMENTAL"})
        public static boolean ENABLE_PRIMAL_ORE_IRON = false;
        @Config.Comment(value={"Enable Worldgen for Primal Gold AbstractOre, this generates in large deposits with ore blocks of varying density. EXPERIMENTAL"})
        public static boolean ENABLE_PRIMAL_ORE_GOLD = false;
        @Config.Comment(value={"Disable worldgen for vanilla iron ore"})
        public static boolean DISABLE_VANILLA_IRON = false;
        @Config.Comment(value={"Disable worldgen for vanilla gold ore"})
        public static boolean DISABLE_VANILLA_GOLD = false;
        @Config.Comment(value={"Disable worldgen for vanilla coal ore"})
        public static boolean DISABLE_VANILLA_COAL = false;
        @Config.Comment(value={"Disable worldgen for vanilla redstone ore"})
        public static boolean DISABLE_VANILLA_REDSTONE = false;
        @Config.Comment(value={"Disable worldgen for vanilla lapis ore"})
        public static boolean DISABLE_VANILLA_LAPIS = false;
        @Config.Comment(value={"Disable worldgen for vanilla diamond ore"})
        public static boolean DISABLE_VANILLA_DIAMOND = false;
        @Config.Comment(value={"Disable worldgen for vanilla emerald ore"})
        public static boolean DISABLE_VANILLA_EMERALD = false;
        @Config.Comment(value={"Disable worldgen for vanilla quartz ore"})
        public static boolean DISABLE_VANILLA_QUARTZ = false;
        @Config.Comment(value={"Disable worldgen for vanilla andesite stone"})
        public static boolean DISABLE_VANILLA_ANDESITE = false;
        @Config.Comment(value={"Disable worldgen for vanilla granite stone"})
        public static boolean DISABLE_VANILLA_GRANITE = false;
        @Config.Comment(value={"Disable worldgen for vanilla diorite stone"})
        public static boolean DISABLE_VANILLA_DIORITE = false;
        @Config.Comment(value={"Disable worldgen for vanilla gravel"})
        public static boolean DISABLE_VANILLA_GRAVEL = false;
        @Config.Comment(value={"Disable worldgen for vanilla dirt"})
        public static boolean DISABLE_VANILLA_DIRT = false;
        @Config.Comment(value={"Cineris (Nether Grass) will avoid world generation on these blocks."})
        public static String[] GEN_CINERIS_BLACKLIST = new String[]{"minecraft:magma", "nex:block_ice_frostburn", "primal:nether_earth", "primal:cinisclay_block"};
        @Config.Comment(value={"Ineris (Void Grass) will avoid world generation on these blocks."})
        public static String[] GEN_INERIS_BLACKLIST = new String[]{"primal:night_stone"};
        @Config.Comment(value={"Control the density of Cineris (Nether Grass) world generation"})
        @Config.RangeInt(min=0, max=300)
        public static int GEN_CINERIS_AMOUNT = 50;
        @Config.Comment(value={"Control the density of Cineris Bloom"})
        @Config.RangeDouble(min=0.0, max=0.9)
        public static double GEN_CINERIS_BLOOM_RATIO = 0.12;
        @Config.Comment(value={"Control the density of Ineris (Void Grass) world generation"})
        @Config.RangeInt(min=0, max=300)
        public static int GEN_INERIS_AMOUNT = 14;
        @Config.Comment(value={"Chance that a given Ineris will bloom during world generation"})
        @Config.RangeDouble(min=0.0, max=1.0)
        public static double GEN_INERIS_BLOOM_CHANCE = 0.15;
        @Config.Comment(value={"Chance of the worldgen appearing in a given chunck"})
        @Config.RangeInt(min=10, max=1000)
        public static int GEN_NETHER_EARTH_CHANCE = 20;
        @Config.Comment(value={"Min and Max size of the deposits, these values must be above 0 and max must be greater than min"})
        public static int[] GEN_NETHER_EARTH_SIZE = new int[]{16, 120};
        @Config.Comment(value={"Chance of the worldgen appearing in a given chunck"})
        @Config.RangeInt(min=10, max=1000)
        public static int GEN_CINIS_CLAY_CHANCE = 120;
        @Config.Comment(value={"Min and Max size of the deposits, these values must be above 0 and max must be greater than min"})
        public static int[] GEN_CINIS_CLAY_SIZE = new int[]{50, 160};
        @Config.Comment(value={"Chance of the worldgen appearing in a given chunck"})
        @Config.RangeInt(min=10, max=1000)
        public static int GEN_SCORIA_STONE_SMALL_CHANCE = 6;
        @Config.Comment(value={"Min and Max size of the deposits, these values must be above 0 and max must be greater than min"})
        public static int[] GEN_SCORIA_STONE_SMALL_SIZE = new int[]{8, 36};
        @Config.Comment(value={"Chance of the worldgen appearing in a given chunck"})
        @Config.RangeInt(min=10, max=1000)
        public static int GEN_SCORIA_STONE_CHANCE = 200;
        @Config.Comment(value={"Min and Max size of the deposits, these values must be above 0 and max must be greater than min"})
        public static int[] GEN_SCORIA_STONE_SIZE = new int[]{60, 160};
        @Config.Comment(value={"Chance of the worldgen appearing in a given chunck"})
        @Config.RangeInt(min=10, max=1000)
        public static int GEN_FERRO_STONE_CHANCE = 160;
        @Config.Comment(value={"Min and Max size of the deposits, these values must be above 0 and max must be greater than min"})
        public static int[] GEN_FERRO_STONE_SIZE = new int[]{60, 200};
        @Config.Comment(value={"Min and Max height of MudWet worldgen"})
        public static int[] GEN_MUD_MIN_MAX = new int[]{48, 68};
        @Config.Comment(value={"Min and Max height of Terracotta ClayLike worldgen"})
        public static int[] GEN_CLAY_MIN_MAX = new int[]{34, 80};
        @Config.Comment(value={"Min and Max height of Satetsu/Iron Sand worldgen"})
        public static int[] GEN_SATETSU_MIN_MAX = new int[]{48, 68};
    }

    public static class Monsters {
        @Config.RequiresMcRestart
        @Config.Comment(value={"Spawn Weight, 0 will Disable spawning entire"})
        @Config.RangeInt(min=0, max=100)
        public static int STEPPE_WOLF_SPAWN_WEIGHT = 4;
        @Config.RequiresMcRestart
        @Config.Comment(value={"Food Items that the Steppe Wolves should not eat, overrides items otherwise returned by one of the dictionary names"})
        public static String[] STEPPE_WOLF_FOOD_BLACKLIST = new String[]{"primal:wolf_meat_raw"};
        @Config.RequiresMcRestart
        @Config.Comment(value={"Additional Food Items that the Steppe Wolves should eat. These are internally assigned the dictionary name foodCanis"})
        public static String[] STEPPE_WOLF_FOOD_WHITELIST = new String[0];
        @Config.RequiresMcRestart
        @Config.Comment(value={"Additional Food Items that the Steppe Wolves should eat"})
        public static String[] STEPPE_WOLF_FOOD_DICTIONARY_NAMES = new String[]{"foodCanis", "foodFat", "listAllmeatraw", "listAllfishraw"};
        @Config.RequiresMcRestart
        @Config.Comment(value={"Movement Speed, Max Health, Attack Damage, Follow Range, Knockback Resistance"})
        public static double[] STEPPE_WOLF_STATS = new double[]{0.32, 25.0, 2.5, 32.0, 0.2};
        @Config.RequiresMcRestart
        @Config.Comment(value={"Spawn Weight, 0 will Disable spawning entire"})
        @Config.RangeInt(min=0, max=100)
        public static int OVIS_ATRE_SPAWN_WEIGHT = 90;
        @Config.RequiresMcRestart
        @Config.Comment(value={"Chance of adult Ovis to look for grass within their current block. The Vanilla sheep value is 1000"})
        @Config.RangeInt(min=100, max=10000)
        public static int OVIS_ATRE_GRAZE_CHANCE = 1600;
        @Config.RequiresMcRestart
        @Config.Comment(value={"Maximum number of wool blocks returned by shears, vanilla sheep is 3"})
        @Config.RangeInt(min=1, max=6)
        public static int OVIS_ATRE_WOOL_SHEAR_AMOUNT = 1;
        @Config.RequiresMcRestart
        @Config.Comment(value={"Chance when eating a food item in world that the Ovis will regrow it's wool and milk. This is separate from the passive consumption of grass."})
        @Config.RangeDouble(min=0.0, max=1.0)
        public static double OVIS_ATRE_REGROWTH_CHANCE = 0.45;
        @Config.RequiresMcRestart
        @Config.Comment(value={"Food Items that the Ovis Atre should not eat, overrides items otherwise returned by one of the dictionary names"})
        public static String[] OVIS_ATRE_FOOD_BLACKLIST = new String[]{"primal:ovis_meat_raw"};
        @Config.RequiresMcRestart
        @Config.Comment(value={"Additional Food Items that the Ovis Atre should eat. These are internally assigned the dictionary name foodAtre"})
        public static String[] OVIS_ATRE_FOOD_WHITELIST = new String[0];
        @Config.RequiresMcRestart
        @Config.Comment(value={"Additional Food Items that the Ovis Atre should eat"})
        public static String[] OVIS_ATRE_FOOD_DICTIONARY_NAMES = new String[]{"foodAtre", "foodPoison", "foodRot", "foodFat", "listAllmeatraw", "listAllmeatrotten", "listAllfishraw", "listAllfishrotten"};
        @Config.RequiresMcRestart
        @Config.Comment(value={"Movement Speed, Max Health, Attack Damage, Follow Range, Knockback Resistance"})
        public static double[] OVIS_ATRE_STATS = new double[]{0.26, 20.0, 3.0, 16.0, 0.2};
        @Config.RequiresMcRestart
        @Config.Comment(value={"Spawn Weight, 0 will Disable spawning entire"})
        @Config.RangeInt(min=0, max=100)
        public static int SHARKS_SPAWN_WEIGHT = 1;
        @Config.Comment(value={"Sharks will attack squid and other entities that extend EntityWaterMob"})
        public static boolean SHARKS_ATTACK_WATER_MOBS = false;
        @Config.Comment(value={"Sharks will attack entities that extend EntityGuardian"})
        public static boolean SHARKS_ATTACK_GUARDIANS = false;
        @Config.Comment(value={"Sharks will attack the boat that a target is riding in"})
        public static boolean SHARKS_ATTACK_BOATS = true;
        @Config.Comment(value={"How many blocks away will sharks find player targets"})
        public static double SHARKS_TARGET_RANGE = 32.0;
        @Config.RequiresMcRestart
        @Config.Comment(value={"Max Health, Attack Damage, Swim Radius, Swim Speed, Vertical Speed"})
        public static double[] SHARKS_STATS = new double[]{20.0, 4.0, 25.0, 0.5, 0.5};
        @Config.RequiresMcRestart
        @Config.Comment(value={"Spawn Weight, 0 will Disable spawning entire"})
        @Config.RangeInt(min=0, max=100)
        public static int BEAR_BLACK_SPAWN_WEIGHT = 3;
        @Config.RequiresMcRestart
        @Config.Comment(value={"Spawn Weight, 0 will Disable spawning entire"})
        @Config.RangeInt(min=0, max=100)
        public static int BEAR_BROWN_SPAWN_WEIGHT = 2;
        @Config.RequiresMcRestart
        @Config.Comment(value={"Movement Speed, Max Health, Attack Damage, Follow Range, Knockback Resistance"})
        public static double[] BEAR_BLACK_STATS = new double[]{0.3, 30.0, 6.0, 30.0, 0.5};
        @Config.RequiresMcRestart
        @Config.Comment(value={"Movement Speed, Max Health, Attack Damage, Follow Range, Knockback Resistance"})
        public static double[] BEAR_BROWN_STATS = new double[]{0.28, 50.0, 6.0, 40.0, 0.8};
        @Config.RequiresMcRestart
        @Config.Comment(value={"Spawn Weight, 0 will Disable spawning entire"})
        @Config.RangeInt(min=0, max=100)
        public static int NETHER_CREEPER_SPAWN_WEIGHT = 3;
        @Config.RequiresMcRestart
        @Config.Comment(value={"Movement Speed, Max Health, Follow Range, Knockback Resistance"})
        public static double[] NETHER_CREEPER_STATS = new double[]{0.25, 10.0, 16.0, 0.0};
        @Config.RequiresMcRestart
        @Config.Comment(value={"Spawn Weight, 0 will Disable spawning entire"})
        @Config.RangeInt(min=0, max=100)
        public static int ALLIGATOR_SPAWN_WEIGHT = 1;
        @Config.RequiresMcRestart
        @Config.Comment(value={"Movement Speed, Max Health, Attack Damage, Follow Range, Knockback Resistance"})
        public static double[] ALLIGATOR_STATS = new double[]{0.22, 15.0, 2.0, 16.0, 0.4};
        @Config.Comment(value={"Chance of creepers exploding each tick they are on fire"})
        public static double BURNING_CREEPERS = 0.65;
        @Config.Comment(value={"Chance of chickens to drop feathers, higher numbers drops are less likely, while 0 disables drops"})
        public static int CHICKEN_FEATHER_CHANCE = 16000;
        @Config.Comment(value={"Making Endermen harder to cheese"})
        public static boolean ENHANCED_ENDERMEN = true;
        @Config.Comment(value={"Apply AI to Vanilla Animals that will cause them to eat items in-world"})
        public static boolean HUNGRY_ANIMALS = true;
        @Config.Comment(value={"Disable vanilla squid spawns"})
        public static boolean DISABLE_VANILLA_SQUID = false;
        @Config.Comment(value={"Disable vanilla wolf spawns"})
        public static boolean DISABLE_VANILLA_WOLVES = false;
        @Config.Comment(value={"Prevent Water mobs that die from natural causes from dropping items. Namely this applies to sharks killing squid."})
        public static boolean SAFETY_WATER_DROPS = true;
        @Config.Comment(value={"Prevent Wither Skeletons spawning outside of nether dimension"})
        public static boolean SAFETY_WITHER_SKELETON = false;
        @Config.Comment(value={"Prevent Blaze from spawning outside of nether dimension"})
        public static boolean SAFETY_BLAZE = false;
    }

    public static class Machines {
        @Config.RequiresMcRestart
        @Config.Comment(value={"Items which can be used to sponge unwanted fluid from the cauldron or barrels"})
        public static String[] FLUID_SPONGE_ITEMS = new String[]{"minecraft:sponge", "primal:ovis_atre_wool"};
        @Config.Comment(value={"Log Stacks Burn into various grades of charcoal based on the type of wood, this is used primarily by Kitsu's ForgeCraft. Otherwise drop vanilla charcoal."})
        public static boolean CHARCOAL_PIT_GRADES = true;
        @Config.Comment(value={"Base tick rate that Burning Log Stacks will run updates, this is further modified by wood type/charcoal grade"})
        @Config.RangeInt(min=1000, max=24000)
        public static int CHARCOAL_PIT_TICK_RATE = 4000;
        @Config.Comment(value={"Charcoal output_items from a charcoal log stack"})
        @Config.RequiresMcRestart
        public static CharcoalPit CHARCOAL_PIT_OUTPUT_AMOUNT = new CharcoalPit(4, 16);
        @Config.Comment(value={"This setting controls the base number of ticks the block will use when scheduling an update"})
        @Config.RangeInt(min=20, max=24000)
        public static int FISH_TRAP_TICK_RATE = 5400;
        @Config.Comment(value={"Base chance of a fish trap catching fish"})
        @Config.RangeDouble(min=0.01, max=1.0)
        public static double FISH_TRAP_BASE_CATCH = 0.25;
        @Config.Comment(value={"Base chance of a fish trap catching junk"})
        @Config.RangeDouble(min=0.01, max=1.0)
        public static double FISH_TRAP_BASE_JUNK = 0.05;
        @Config.Comment(value={"Base chance of a fish trap catching treasure"})
        @Config.RangeDouble(min=0.01, max=1.0)
        public static double FISH_TRAP_BASE_TREASURE = 0.025;
        @Config.Comment(value={"Add additional bait items for fish traps. example: harvestcraft:fruitbaititem"})
        @Config.RequiresMcRestart
        public static String[] FISH_TRAP_BAIT = new String[]{"harvestcraft:fruitbaititem", "rustic:wildberries"};
        @Config.Comment(value={"This setting controls the base number of ticks the block will use when scheduling an update"})
        @Config.RangeInt(min=20, max=24000)
        public static int DRYING_RACK_TICK_RATE = 2000;
        @Config.Comment(value={"Time modifier for recipe drying times"})
        @Config.RangeDouble(min=0.0, max=10.0)
        public static double DRYING_RACK_DRY_TIME_MODIFIER = 1.0;
        @Config.Comment(value={"Base time modifier that gets added to drying rack recipes, higher values make rotting less likely"})
        @Config.RangeInt(min=0, max=120000)
        public static int DRYING_RACK_ROT_MODIFIER = 0;
        @Config.Comment(value={"This setting controls the base number of ticks the block will use when scheduling an update"})
        @Config.RangeInt(min=20, max=24000)
        public static int HIBACHI_TICK_RATE = 90;
        @Config.Comment(value={"Cook Time modifier"})
        @Config.RangeDouble(min=0.01, max=10.0)
        public static double HIBACHI_COOK_TIME_MODIFIER = 1.0;
        @Config.Comment(value={"Fuel Burn Time modifier"})
        @Config.RangeDouble(min=0.01, max=10.0)
        public static double HIBACHI_FUEL_TIME_MODIFIER = 0.2;
        @Config.Comment(value={"Base cook time for recipes picked up from the vanilla furnace, the total time is further modified by the food value of the item being cooked"})
        @Config.RangeInt(min=1, max=1000)
        public static int HIBACHI_BASE_FURNACE_RECIPE_TIME = 8;
        @Config.Comment(value={"Automatically pickup vanilla furnace recipes for food items"})
        public static boolean HIBACHI_PICKUP_FURNACE_RECIPES = true;
        @Config.Comment(value={"Blacklist food furnace items"})
        public static String[] HIBACHI_FURNACE_BLACKLIST = new String[0];
        @Config.Comment(value={"This setting controls the base number of ticks the block will use when scheduling an update"})
        @Config.RangeInt(min=20, max=24000)
        public static int SMELTER_TICK_RATE = 600;
        @Config.Comment(value={"Chance of a burning smelter has to generate slag or potash in unused slots"})
        @Config.RangeDouble(min=0.001, max=1.0)
        public static double SMELTER_SLAG_CHANCE = 0.02;
        @Config.Comment(value={"Chance of a smelter producing smoke when a recipe completes"})
        @Config.RangeDouble(min=0.0, max=1.0)
        public static double SMELTER_SMOKE_CHANCE = 0.05;
        @Config.Comment(value={"Cook Time modifier"})
        @Config.RangeDouble(min=0.01, max=10.0)
        public static double SMELTER_TIME_MODIFIER = 1.0;
        @Config.Comment(value={"This setting controls the base number of ticks the block will use when scheduling an update"})
        @Config.RangeInt(min=20, max=24000)
        public static int CAULDRON_TICK_RATE = 1600;
        @Config.Comment(value={"Amount that cauldron heat is incremented on each update with a valid heat source, the range is 0.0 to 1.0"})
        @Config.RangeDouble(min=0.001, max=1.0)
        public static double CAULDRON_HEAT_UP = 0.25;
        @Config.Comment(value={"Amount that cauldron heat is decreased on each update without a valid heat source, the range is 0.0 to 1.0"})
        @Config.RangeDouble(min=0.001, max=1.0)
        public static double CAULDRON_COOL_DOWN = 0.05;
        @Config.Comment(value={"Chance of a heated cauldron that is processing recipes has to generate slag in unused slots"})
        @Config.RangeDouble(min=0.001, max=1.0)
        public static double CAULDRON_SLAG_CHANCE = 0.02;
        @Config.Comment(value={"Chance of a cauldron producing smoke when a recipe completes"})
        @Config.RangeDouble(min=0.0, max=1.0)
        public static double CAULDRON_SMOKE_CHANCE = 0.05;
        @Config.Comment(value={"Modifier that gets added to the base cook chance for all cauldron recipes."})
        @Config.RangeDouble(min=0.01, max=10.0)
        public static double CAULDRON_TIME_MODIFIER = 1.0;
        @Config.Comment(value={"Cauldron amount recipe for melting stone into lava. Setting this to zero will cause the recipe to not register."})
        @Config.RangeInt(min=0, max=64)
        public static int CAULDRON_RECIPE_STONE_TO_LAVA = 16;
        @Config.Comment(value={"This setting controls the base number of ticks the block will use when scheduling an update"})
        @Config.RangeInt(min=20, max=24000)
        public static int BARREL_TICK_RATE = 600;
        @Config.Comment(value={"Storage Crates retain their Inventory when broken."})
        public static boolean CRATES_RETAIN_INVENTORY = true;
    }

    public static class Plants {
        @Config.RequiresMcRestart
        @Config.Comment(value={"IPlantable items will attempt to plant themselves when left in the world. Default chance of success is 100%, setting 0.0 will effectively disable auto-planting"})
        @Config.RangeDouble(min=0.0, max=1.0)
        public static double PLANT_AUTO_MAGIC_CHANCE = 1.0;
        @Config.Comment(value={"IPlantable blocks to skip while attempting to auto-plant."})
        public static String[] PLANT_AUTO_MAGIC_BLACKLIST = new String[]{"coralreef:reef", "coralreef:coral", "bamboozled:bamboo"};
        @Config.Comment(value={"Base tick rate for plant updates, the scheduled update is randomized based off the provided number. Vanilla plants update randomly within a 20 tick period."})
        @Config.RangeInt(min=20, max=20000)
        public static int PLANT_BASE_TICK_RATE = 6200;
        @Config.Comment(value={"Base growth modifier for certain primal plants, these base values get modified by factors at grow time"})
        @Config.RangeDouble(min=0.0, max=1.0)
        public static double PLANT_BASE_GROWTH_CHANCE = 0.35;
        @Config.Comment(value={"Base bloom modifier for certain primal plants, these base values get modified by factors at bloom time"})
        @Config.RangeDouble(min=0.0, max=1.0)
        public static double PLANT_BLOOM_MODIFIER = 0.0;
        @Config.Comment(value={"Base spread modifier for invasive plants,  these base values get modified by factors at spread time"})
        @Config.RangeDouble(min=0.0, max=1.0)
        public static double PLANT_BASE_SPREAD_CHANCE = 0.05;
        @Config.Comment(value={"Base growth modifier for primal plants, higher values cause growth to take longer"})
        @Config.RangeInt(min=0, max=100)
        public static int PLANT_RAIN_SENSITIVITY = 2;
        @Config.Comment(value={"Allow certain plants to spread under circumstances specific to each canNewGrow. For example Equisetum Cineris will spread aggressively when planted outside the Nether"})
        public static boolean INVASIVE_PLANTS_SPREAD = true;
        @Config.Comment(value={"Certain perennial plants will leave roots behind allowing the plant to regrow."})
        public static boolean PERENNIAL_PLANTS_ROOT = true;
        @Config.Comment(value={"Vanilla Tall Grass will leave roots behind that allow it to regrow."})
        public static boolean TALL_GRASS_GROWTH = true;
        @Config.Comment(value={"Tall Grass roots will spread in the rain. This does not effect the grown vanilla block."})
        public static boolean TALL_GRASS_RAIN_SPREAD = true;
        @Config.Comment(value={"Amount of movement impact from walking through fully grown rushes."})
        @Config.RangeDouble(min=0.0, max=0.9)
        public static double RUSH_MOVEMENT = 0.8;
        @Config.Comment(value={"Chance of blooming Equisetum Ineris has to teleport an entity that collides with the plant."})
        @Config.RangeDouble(min=0.0, max=1.0)
        public static double INERIS_TELEPORT_CHANCE = 0.05;
        @Config.Comment(value={"Movement modifier used for Cineris thatch and carpet blocks, for reference naturally growing cineris has a modifier of 0.012F"})
        public static double[] CINERIS_CARPET_SPEED_MODIFIERS = new double[]{0.012, 0.066, 0.125, 0.6, 1.9};
        @Config.Comment(value={"Cineris Carpet prevents items/entities from de-spawning"})
        public static boolean CINERIS_CARPET_PREVENTS_DESPAWN = true;
        @Config.Comment(value={"Cineris Carpet prevents items from being picked up"})
        public static boolean CINERIS_CARPET_PREVENTS_PICKUP = true;
    }

    public static class Lighting {
        @Config.Comment(value={"How long will torches stay lit? higher is a longer life, while 0 will disable the feature"})
        public static int TORCH_LIFESPAN = 16;
        @Config.Comment(value={"How likely are torches to go out when a player falls into water. Setting this to 0 will disable dousing completely."})
        public static int TORCH_DOUSE_CHANCE = 16;
        @Config.Comment(value={"How likely are torches to produce smoke when exposed to rain or snow. Higher is less likely"})
        public static int SMOKE_TORCH_CHANCE = 45;
        @Config.Comment(value={"How likely are torch arrows to produce smoke on impact with a block"})
        public static int SMOKE_TORCH_ARROW_CHANCE = 36;
        @Config.Comment(value={"How likely are lanterns to produce smoke when exposed to rain or snow. Higher is less likely"})
        public static int SMOKE_LANTERN_CHANCE = 65;
        @Config.Comment(value={"Amount of light produced by Jack o'Lanterns. Redstone torches 0.5D, Torch 0.9375D"})
        public static double JACK_LIGHT_LEVEL = 0.5;
        @Config.Comment(value={"Replace vanilla jack-o-lanterns during block placement"})
        public static boolean JACK_REPLACE_VANILLA = false;
        @Config.Comment(value={"Jack-o-lanterns can get put out, and or will naturally go out according to how torches are configured"})
        public static boolean JACK_CAN_EXPIRE = false;
        @Config.Comment(value={"Set this option for torches that will eventually go out even when not exposed to weather. This will also cause torches to create smoke regardless of weather. Separately weather sensitivity can be disabled by setting the lifespan to 0"})
        public static boolean TORCHES_DIE = false;
        @Config.Comment(value={"By default impose ambient light levels across all dimensions, changing this to false will cause AMBIENT_LIGHT_DIMENSIONS to be used as a whitelist"})
        public static boolean AMBIENT_LIGHT_GLOBAL = false;
        @Config.Comment(value={"Modified ambient light level"})
        @Config.RangeDouble(min=-1.0, max=1.0)
        public static double AMBIENT_LIGHT_LEVEL = -0.5;
        @Config.Comment(value={"Dimensions list for ambient light, if AMBIENT_LIGHT_GLOBAL is true this is a blacklist"})
        public static byte[] AMBIENT_LIGHT_DIMENSIONS = new byte[0];
    }

    public static class Fluids {
        @Config.Comment(value={"Breaking vanilla Magma Blocks has a chance to produce Primal's Fluid Magma"})
        public static double MAGMA_HARVEST_CHANCE = 0.025;
        @Config.Comment(value={"Modify the explosive potential of paraffin fluid in world (63502)"})
        @Config.RangeDouble(min=0.001, max=1.0)
        public static double PARAFFIN_FLUID_EXPLOSION_MODIFIER = 1.0;
        @Config.Comment(value={"Modify the explosive potential of paraffin fluid in barrels (63502)"})
        @Config.RangeDouble(min=0.001, max=1.0)
        public static double PARAFFIN_BARREL_EXPLOSION_MODIFIER = 1.0;
        @Config.Comment(value={"Enable various block generation by mixing blocks in-world with Primal Magma/Ovis Atre Milk"})
        public static boolean ENABLE_FLUID_MIXING_RECIPES = true;
        @Config.Comment(value={"Ovis Atre Milk has special interaction with other liquids"})
        public static boolean MILK_SPECIAL_INTERACTION = true;
        @Config.Comment(value={"Enable vanilla clay bucket. this is useful if another mod already adds a bucket such as Ceramics"})
        public static boolean BUCKETS_CLAY_ENABLED = true;
        @Config.Comment(value={"Enable primal terra clay bucket. this is useful if you hate buckets"})
        public static boolean BUCKETS_TERRA_ENABLED = true;
        @Config.Comment(value={"Enable primal terra clay bucket. this is useful if you hate buckets"})
        public static boolean BUCKETS_CINIS_ENABLED = true;
        @Config.Comment(value={"Allow unsafe buckets to pickup hot fluids, do so at the player's peril"})
        public static boolean BUCKETS_PICKUP_HOT_FLUIDS = true;
        @Config.Comment(value={"Show JEI recipes that dynamically acquire buckets, this is a safety measure in case a mod provided bucket isn't happy"})
        public static boolean JEI_SHOW_DYNAMIC_BUCKET_RECIPES = true;
    }

    public static class Flammability {
        @Config.Comment(value={"Chance that fire will spread and consume this block. 300 being a 100% chance and 0 being a 0% chance"})
        public static int THATCH_BURN_CHANCE = 120;
        @Config.Comment(value={"Called when fire is updating on a neighbor block. The higher the number returned, the faster fire will spread around this block"})
        public static int THATCH_FIRE_SPREAD = 60;
        @Config.Comment(value={"How likely are Overworld torches to set entities touching them on fire. Higher is less likely, think in large numbers as the check runs continually on block collision"})
        public static int TORCH_ENTITY_BURN = 500;
        @Config.Comment(value={"How likely are torch arrows that fail to place a torches to set flammable materials on fire. Higher is less likely per tick, 0 will disable"})
        public static int TORCH_ARROW_FIRE = 4;
        @Config.Comment(value={"Calcified Paraffin is Flammable in-world"})
        public static boolean CALCIFIED_PARAFFIN_BURNS = false;
        @Config.RequiresMcRestart
        @Config.Comment(value={"Additional blocks to be treated as sources of strong heat for purposes of heating cauldrons, drying racks,  or similar blocks, this is generally expected to be hotter than the average FIRE_SOURCE_BLOCKS"})
        public static String[] HEAT_SOURCE_BLOCKS = new String[]{"minecraft:magma", "minecraft:lit_furnace", "primal:nether_growth", "primal:hibachi", "primal:smelter", "magnum:quartz_ignis_block"};
        @Config.RequiresMcRestart
        @Config.Comment(value={"Additional blocks to be treated as sources of fire for purposes of heat and igniting items such as the primal torches"})
        public static String[] FIRE_SOURCE_BLOCKS = new String[]{"minecraft:torch", "minecraft:lit_furnace", "minecraft:lit_pumpkin", "minecraft:magma", "totemic:totem_torch", "rustic:iron_lantern", "natura:lit_netherrack_furnace", "thebetweenlands:sulfur_torch", "thaumcraft:cinderpearl", "thaumcraft:candle_white", "thaumcraft:candle_orange", "thaumcraft:candle_magenta", "thaumcraft:candle_lightblue", "thaumcraft:candle_yellow", "thaumcraft:candle_lime", "thaumcraft:candle_pink", "thaumcraft:candle_gray", "thaumcraft:candle_silver", "thaumcraft:candle_cyan", "thaumcraft:candle_purple", "thaumcraft:candle_blue", "thaumcraft:candle_brown", "thaumcraft:candle_green", "thaumcraft:candle_red", "thaumcraft:candle_black", "primal_tech:fibre_torch_lit", "primal:nether_growth", "magnum:quartz_ignis_block"};
        @Config.RequiresMcRestart
        @Config.Comment(value={"Additional items to be treated as sources of fire for purposes of igniting items such as the primal torches. Not all items work ie: totemic:totem_torch, primal_tech:fibre_torch_lit"})
        public static String[] FIRE_SOURCE_ITEMS = new String[]{"minecraft:magma", "minecraft:blaze_rod", "magnum:pin_blaze", "magnum:quartz_ignis", "magnum:quartz_ignis_flake", "magnum:quartz_ignis_point", "magnum:quartz_ignis_block", "thebetweenlands:sulfur_torch", "thaumcraft:cinderpearl", "thaumcraft:candle_white", "thaumcraft:candle_orange", "thaumcraft:candle_magenta", "thaumcraft:candle_lightblue", "thaumcraft:candle_yellow", "thaumcraft:candle_lime", "thaumcraft:candle_pink", "thaumcraft:candle_gray", "thaumcraft:candle_silver", "thaumcraft:candle_cyan", "thaumcraft:candle_purple", "thaumcraft:candle_blue", "thaumcraft:candle_brown", "thaumcraft:candle_green", "thaumcraft:candle_red", "thaumcraft:candle_black", "totemic:totem_torch", "primal_tech:fibre_torch_lit"};
    }

    public static class Survival {
        @Config.RequiresMcRestart
        @Config.Comment(value={"Hide player REGISTRY_NAME tags"})
        public static boolean HIDE_PLAYER_NAMES = false;
        @Config.Comment(value={"Hide the F3 Info Overlay"})
        public static boolean HIDE_F3_INFO = false;
        @Config.Comment(value={"Disable the use of Bone Meal"})
        public static boolean DISABLE_BONE_MEAL = false;
        @Config.Comment(value={"Chance of certain materials spreading from their native dimension when players travel though a portal."})
        public static boolean PORTAL_SPREAD = true;
        @Config.Comment(value={"Base change of materials looking for a place to spread. Higher is less likely, 0 is every time."})
        public static int PORTAL_SPREAD_CHANCE = 120;
        @Config.Comment(value={"Add steps to refining vanilla leather, animal pelts processed into hide treated with salt, dried, tanned, and dried again"})
        public static boolean HARD_LEATHER = true;
        @Config.Comment(value={"Crafting dried hide on the way to created leather requires salt."})
        public static boolean LEATHER_REQUIRES_SALT = true;
        @Config.Comment(value={"Trying to break blocks with a bare hand that cannot be harvested without a inworld will hurt the player. Damage is scaled by the hardness of the block. Setting this to 0 will disable the feature"})
        @Config.RangeDouble(min=0.0, max=100.0)
        public static double HARD_BLOCKS_HARDNESS = 1.0;
        @Config.Comment(value={"Modifier to adjust the damage applied by HARD_BLOCKS"})
        @Config.RangeDouble(min=0.0, max=1.0)
        public static double HARD_BLOCKS_MODIFIER = 0.5;
        @Config.Comment(value={"Breaking leaf blocks will sometimes drop sticks"})
        public static boolean DROPS_STICK_FROM_LEAF = true;
        @Config.Comment(value={"Animals will drop additional items such as suet or lard, used as food and various crafting recipes"})
        public static boolean DROPS_EXTRA_ANIMAL_STUFF = true;
        @Config.Comment(value={"Vanilla animals such as Horses, will drop meat"})
        public static boolean DROPS_VANILLA_MEAT = true;
        @Config.Comment(value={"Harvesting smooth stone with a pickaxe drops a number of rocks based on inworld level, cobble stone must be crafted"})
        public static boolean DROPS_ROCKS_FROM_STONE = false;
        @Config.Comment(value={"Crafting Cobble requires the use of mortar, this is most relevant if you are using DROPS_ROCKS_FROM_STONE = true"})
        public static boolean COBBLE_REQUIRES_MORTAR = false;
        @Config.Comment(value={"Harvesting Ground or Sand materials has a chance of dropping rocks, 0 will disable drop while higher values are less likely"})
        public static int DROPS_EXTRA_ROCKS = 50;
        @Config.Comment(value={"Harvesting Ground or Sand materials has a chance of dropping flint, 0 will disable drop while higher values are less likely"})
        public static int DROPS_EXTRA_FLINT = 50;
        @Config.Comment(value={"Harvesting Nether Earth or Soul Sand has a chance of dropping quartz or bones, 0 will disable drop while higher values are less likely"})
        public static int DROPS_EXTRA_NETHER = 50;
        @Config.Comment(value={"Chance that Animals will drop bones, 0 will disable while higher values are less likely"})
        public static int DROPS_EXTRA_BONES = 6;
        @Config.Comment(value={"Chance of dropping sticks from dead bushes, the leaf drops will be updated to use this also"})
        public static double DROPS_STICKS = 0.6;
        @Config.Comment(value={"Chance of dropping plant fibers from many common plants, especially vanilla tall grass"})
        public static double DROPS_PLANT_FIBERS = 0.65;
        @Config.Comment(value={"Chance of dropping nether fibers from Equisetum Cineris grass"})
        public static double DROPS_CINERIS_FIBERS = 0.8;
        @Config.Comment(value={"Chance of dropping nether fibers from Equisetum Inanis grass"})
        public static double DROPS_VOID_FIBERS = 0.8;
        @Config.Comment(value={"Chance of dropping nether fibers from Sea grass"})
        public static double DROPS_SEA_FIBERS = 0.85;
        @Config.Comment(value={"Chance of dropping seeds from Equisetum Cineris grass"})
        public static double DROPS_CINERIS_SEEDS = 0.45;
        @Config.Comment(value={"Harvesting log blocks requires the use of appropriate tools"})
        public static boolean HARVEST_LOGS_REQUIRE_TOOLS = true;
        @Config.Comment(value={"Additional blocks to be treated like logWood for purposes of harvesting with a required inworld. See HARVEST_LOGS_REQUIRE_TOOLS. Example: primal:planks, minecraft:planks, minecraft:dirt, minecraft:dirt"})
        @Config.RequiresMcRestart
        public static String[] HARVEST_BLOCK_ADDITIONS = new String[0];
        @Config.Comment(value={"Enable simple recipes recipes for basic and colored daub"})
        public static boolean SIMPLE_DAUB_RECIPE = true;
        @Config.Comment(value={"Enable simple crafting recipes for basic and colored hardened stone"})
        public static boolean SIMPLE_HARDENED_STONE_RECIPE = true;
        @Config.Comment(value={"Enable simple crafting recipe for converting gravel to flint"})
        public static boolean SIMPLE_FLINT_RECIPE = true;
        @Config.Comment(value={"Enable simple crafting recipe for harvesting bark from supported logs"})
        public static boolean SIMPLE_BARK_RECIPE = true;
        @Config.Comment(value={"Enable simple crafting recipe for making stripped logs"})
        public static boolean SIMPLE_STRIPPED_RECIPE = true;
        @Config.Comment(value={"Enable Crafting recipe for the vanilla saddle"})
        public static boolean ENABLE_SADDLE_RECIPE = true;
        @Config.Comment(value={"Enable Crafting recipe for the vanilla horse armor"})
        public static boolean ENABLE_HORSE_ARMOR_RECIPE = true;
        @Config.Comment(value={"Enable Crafting recipe for vanilla spider web"})
        public static boolean ENABLE_SPIDER_WEB_RECIPE = true;
        @Config.Comment(value={"Replace vanilla armor recipes."})
        public static boolean REPLACE_VANILLA_ARMOR_RECIPES = true;
        @Config.Comment(value={"Replace chiseled block recipes to require a work blade"})
        public static boolean REPLACE_CHISELED_BLOCK_RECIPE = true;
        @Config.Comment(value={"Replace vanilla arrow recipe to use knapped flint"})
        public static boolean REPLACE_ARROW_RECIPE = true;
        @Config.Comment(value={"Enable a more realistic recipe for trip wire hooks, this drastically reduces the iron cost for early game"})
        public static boolean ALTERNATE_TRIPWIRE_RECIPE = true;
        @Config.Comment(value={"Enable a more realistic recipe for flint and steel, this drastically reduces the iron cost for early game"})
        public static boolean ALTERNATE_FLINTNSTEEL_RECIPE = true;
        @Config.Comment(value={"Disable recipes recipe for ender eyes"})
        public static boolean DISABLE_ENDEREYE_RECIPE = false;
        @Config.Comment(value={"Disable recipes recipe for ender chest"})
        public static boolean DISABLE_ENDERCHEST_RECIPE = false;
        @Config.Comment(value={"Disable smelting recipe for charcoal"})
        public static boolean DISABLE_CHARCOAL_RECIPE = true;
        @Config.Comment(value={"Crafting wooden planks and sticks require the use of a saw, work blade, or hatchet respectively"})
        public static boolean DISABLE_VANILLA_PLANK_RECIPE = true;
        @Config.Comment(value={"Crafting vanilla slabs requires the use of a saw of appropriate material"})
        public static boolean DISABLE_VANILLA_SLAB_RECIPE = false;
        @Config.Comment(value={"Enable recipes recipes for primal Obsidian Armor"})
        public static boolean ENABLE_OBSIDIAN_ARMOR = true;
        @Config.Comment(value={"Disable recipes recipes for vanilla wood tools, by default flint tools are meant to replace wood and stone"})
        public static boolean DISABLE_TOOLS_WOOD_RECIPE = true;
        @Config.Comment(value={"Disable recipes recipes for vanilla stone tools"})
        public static boolean DISABLE_TOOLS_STONE_RECIPE = false;
        @Config.Comment(value={"Disable recipes recipes for vanilla iron tools"})
        public static boolean DISABLE_TOOLS_IRON_RECIPE = false;
        @Config.Comment(value={"Disable recipes recipes for vanilla diamond tools"})
        public static boolean DISABLE_TOOLS_DIAMOND_RECIPE = false;
        @Config.Comment(value={"Disable recipes recipes for vanilla gold tools"})
        public static boolean DISABLE_TOOLS_GOLD_RECIPE = false;
        @Config.Comment(value={"Disable recipes recipes for vanilla wood swords"})
        public static boolean DISABLE_SWORD_WOOD_RECIPE = true;
        @Config.Comment(value={"Disable recipes recipes for vanilla stone swords"})
        public static boolean DISABLE_SWORD_STONE_RECIPE = true;
        @Config.Comment(value={"Disable recipes recipes for vanilla iron swords"})
        public static boolean DISABLE_SWORD_IRON_RECIPE = false;
        @Config.Comment(value={"Disable recipes recipes for vanilla diamond swords"})
        public static boolean DISABLE_SWORD_DIAMOND_RECIPE = false;
        @Config.Comment(value={"Disable recipes recipes for vanilla gold swords"})
        public static boolean DISABLE_SWORD_GOLD_RECIPE = false;
        @Config.RequiresMcRestart
        @Config.Comment(value={"Replace vanilla torches during block placement, Use an updated recipe and configurable output_items amount."})
        public static boolean REPLACE_VANILLA_TORCHES = true;
        @Config.Comment(value={"Pooh Pooh to the Whos, Down in Who-ville"})
        public static boolean DISABLE_VANILLA_FURNACE = false;
        @Config.Comment(value={"Prevent the player from skipping night, this is meant mostly for servers. Currently this simply stops the player from sleeping in a bed."})
        public static boolean DISABLE_PLAYER_NIGHT_SKIP = false;
        @Config.Comment(value={"Prevent the player from setting a spawn point, typically from a bed or similar block"})
        public static boolean DISABLE_PLAYER_SPAWN = false;
        @Config.Comment(value={"Allow beds to set the players spawn during the daytime, DISABLE_PLAYER_SPAWN must be disabled"})
        public static boolean ALLOW_DAYTIME_SPAWN = true;
    }

    public static class Features {
        @Config.Comment(value={"Enable the LANDING_BLOCKS_SAFE feature, this allows disabling the builtin material checks"})
        public static boolean ENABLE_LANDING_SAFE = true;
        @Config.RequiresMcRestart
        @Config.Comment(value={"Falling or jumping onto certain blocks, such as leaves, snow, ash, absorbs some damage and breaks the associated blocks"})
        public static String[] LANDING_BLOCKS_SAFE = new String[]{"primal:ash_layer", "primal:mud_wet", "primal:terraclay_block", "primal:cinisclay_block", "biomesoplenty:ash_block", "minecraft:snow", "minecraft:hay_block", "minecraft:wool", "minecraft:pumpkin", "minecraft:melon_block", "minecraft:glass", "minecraft:stained_glass", "minecraft:glass_pane", "minecraft:stained_glass_pane"};
        @Config.Comment(value={"Right clicking armor in hand will swap with with worn armor"})
        public static boolean ENABLE_ARMOR_SWAP = true;
        @Config.Comment(value={"Sneak-right clicking a torch in world will pickup the block as an item"})
        public static boolean ENABLE_TORCH_PICKUP = true;
        @Config.Comment(value={"Sneak-right clicking a lever in world will pickup the block as an item"})
        public static boolean ENABLE_LEVER_PICKUP = true;
        @Config.Comment(value={"Enable Wattle and WattleDaubOld blocks and items. This is disabled by default to save block IDs until I have time to rewrite."})
        public static boolean ENABLE_WATTLE_DAUB = false;
        @Config.Comment(value={"Enable Various Stair types. Could save a few Block IDs"})
        public static boolean ENABLE_STAIRS = true;
        @Config.Comment(value={"Register fuel values for numerous items."})
        public static boolean ENABLE_FUELS = true;
        @Config.Comment(value={"Enable the smoke and ash_bin placement from various sources."})
        public static boolean ENABLE_SMOKE = true;
        @Config.Comment(value={"Harvesting wet farmland produces mud clumps rather than dirt."})
        public static boolean ENABLE_MUD_HARVEST_FARMLAND = true;
        @Config.Comment(value={"Enable In-World Crafting fpr the firepit."})
        public static boolean ENABLE_FIRE_PIT_CRAFTING = true;
        @Config.Comment(value={"Enable the in-world flaking of materials such as flint or obsidian."})
        public static boolean ENABLE_FLAKING_RECIPES = true;
        @Config.Comment(value={"Enable In-World axe recipes."})
        public static boolean ENABLE_AXE_RECIPES = true;
        @Config.Comment(value={"Enable In-World hoe recipes, for items such as nether farmland. This does not effect vanilla recipes such as farmland"})
        public static boolean ENABLE_HOE_RECIPES = true;
        @Config.Comment(value={"Enable In-World shovel recipes, for items such as nether earth path. This does not effect vanilla recipes such as grass paths"})
        public static boolean ENABLE_SHOVEL_RECIPES = true;
        @Config.Comment(value={"Enable In-World shovel recipe for turning dirt into path blocks, could conflict with BWMs"})
        public static boolean ENABLE_SHOVEL_DIRT_PATH = true;
        @Config.Comment(value={"Enable the in-world bark removal. Used by the work blocks on log blocks"})
        public static boolean WORK_BLADE_BARK_HARVEST = true;
        @Config.Comment(value={"Disable the in-world drops for flint. This overrides the extra-flint option."})
        public static boolean DISABLE_FLINT_DROPS = false;
        @Config.Comment(value={"Modifier to the update speed of wet mud blocks set to dry in world"})
        @Config.RangeDouble(min=0.1, max=100.0)
        public static double MUD_DRYING_MODIFIER = 1.0;
        @Config.Comment(value={"Modifier to the update speed of nether growth blocks that are attempting to spread, setting to 0 will disable updates completely"})
        @Config.RangeDouble(min=0.0, max=100.0)
        public static double NETHER_GROWTH_MODIFIER = 1.0;
        @Config.Comment(value={"Chance of nether growth blocks attempting to spread, setting to 0 will disable spread completely"})
        @Config.RangeDouble(min=0.0, max=1.0)
        public static double NETHER_GROWTH_SPREAD = 0.025;
        @Config.Comment(value={"Chance of nether growth blocks decaying into netherrack per update"})
        @Config.RangeInt(min=0, max=24000)
        public static int NETHER_GROWTH_DECAY = 16;
        @Config.Comment(value={"Modifier to the update speed of wet thatch blocks set to dry in world"})
        @Config.RangeDouble(min=0.1, max=100.0)
        public static double THATCH_DRYING_MODIFIER = 1.0;
        @Config.Comment(value={"Modifier for how far away wooden slats can be from thatch and still provide support"})
        public static int THATCH_SUPPORT_RANGE = 2;
        @Config.Comment(value={"Base Amount of damage from a thrown rock"})
        public static double ROCK_DAMAGE = 1.5;
        @Config.Comment(value={"Base Amount of damage from a thrown mud-like projectiles"})
        public static double MUD_DAMAGE = 0.0;
        @Config.Comment(value={"Output amount from the mortar recipe"})
        @Config.RangeInt(min=1, max=64)
        public static int MORTAR_RECIPE_OUTPUT = 32;
        @Config.Comment(value={"Output amount from the cobblestone recipe"})
        @Config.RangeInt(min=1, max=64)
        public static int COBBLESTONE_RECIPE_OUTPUT = 2;
        @Config.Comment(value={"How many rocks can a rock stacker stack?"})
        public static int ROCK_STACKSIZE = 64;
        @Config.Comment(value={"How many bottles are able to stack, this only effects primal bottles, such as tannin or urushi"})
        public static int BOTTLE_STACKSIZE = 16;
        @Config.Comment(value={"Chance of success with the fire bow, higher is less likely"})
        public static int FIREBOW_DIFFICULTY = 8;
        @Config.Comment(value={"Harvest level for the flint tools, default is 2 due to lack of iron in the nether. Vanilla values, Wood/Gold 0, Stone 1, Iron 2, Diamond 3"})
        public static int FLINT_TOOL_HARVEST_LEVEL = 1;
        @Config.Comment(value={"Harvest level for the quartz tools, default is 2 due to lack of iron in the nether. Vanilla values, Wood/Gold 0, Stone 1, Iron 2, Diamond 3"})
        public static int QUARTZ_TOOL_HARVEST_LEVEL = 2;
    }

    public static class Compatibility {
        @Config.RequiresMcRestart
        @Config.Comment(value={"Replace the class of vanilla grass paths so it remains a path when touching certain blocks such as fence gates"})
        public static boolean VANILLA_GRASS_PATH_FIX = false;
        @Config.RequiresMcRestart
        @Config.Comment(value={"Allow integration with Primal Tech Torches"})
        public static boolean PTECH_TORCH_INTEGRATION = true;
        @Config.Comment(value={"Add smelter recipes for Thaumcraft Ore Clusters"})
        public static boolean THAUMCRAFT_SMELTER_RECIPES = true;
        @Config.Comment(value={"Add smelter recipes for EnderIO"})
        public static boolean ENDERIO_SMELTER_RECIPES = true;
        @Config.Comment(value={"Add smelter recipes for Applied Energistics"})
        public static boolean AE2_SMELTER_RECIPES = true;
        @Config.Comment(value={"Add tool recipes for deconstructing certain common items such as wooden doors or boats.."})
        public static boolean DECONSTRUCTION_RECIPES = true;
        @Config.Comment(value={"Add shapeless recipes for converting Pam's HarvestCraft fish"})
        public static boolean PAMS_SHAPELESS_FISH = true;
        @Config.Comment(value={"Add pelt and fat drops to Familiar Fauna Deer"})
        public static boolean FAMILIAR_FAUNA_DEER_DROPS = true;
        @Config.Comment(value={"Add alternate mud recipes to overcome conflicts from other mods"})
        public static boolean ALTERNATE_MUD_RECIPES = true;
        @Config.Comment(value={"Ore Dictionary Vanilla Magma Cream as slimeball"})
        public static boolean DICTIONARY_MAGMACREAM = true;
        @Config.Comment(value={"Ore Dictionary Vanilla ClayLike Ball as clayball"})
        public static boolean DICTIONARY_CLAYBALL = true;
        @Config.Comment(value={"Ore Dictionary Vanilla Levers as blockLever"})
        public static boolean DICTIONARY_LEVERS = true;
        @Config.Comment(value={"Ore Dictionary Vanilla fences as fenceWood and gateWood"})
        public static boolean DICTIONARY_FENCES = true;
        @Config.Comment(value={"Ore Dictionary Vanilla meats to listAllmeatraw and listAllmeatcooked"})
        public static boolean DICTIONARY_MEATS = true;
        @Config.Comment(value={"Ore Dictionary Vanilla logs/planks types, such as logOak/plankOak"})
        public static boolean DICTIONARY_WOOD = true;
        @Config.Comment(value={"Enable gallagher Recipes for metal plates, these are registered with the ore dictionary as plate[Name]."})
        public static boolean ENABLE_GALLAGHER_PLATES = true;
        @Config.Comment(value={"Attempt to disable various jetpacks, this is mostly for survival server play where personal flight isnt desired"})
        public static boolean DISABLE_JETPACKS = false;
        @Config.Comment(value={"Cause the Grue to ignore players with Night Vision"})
        public static boolean GRUE_IGNORE_NIGHT_VISION = true;
        @Config.RequiresMcRestart
        @Config.Comment(value={"A compliment to build-in recipe removal, this attempts to remove crafting for the listed items, format is minecraft:ender_chest"})
        public static String[] RECIPE_REMOVAL = new String[0];
        @Config.Comment(value={"Tough As Nails Integration, Replace water in cauldron recipes with Purified Water, this includes the fluid collected by rainfall in barrels and the primal cauldron"})
        public static boolean TAN_PURIFIED_WATER = true;
        @Config.Comment(value={"Tough As Nails Integration, Wolf armor Temperature Bonus."})
        public static int TAN_ARMOR_WOLF_HEAT_BONUS = 2;
        @Config.Comment(value={"Tough As Nails Integration, Ovis Atre armor Temperature Bonus."})
        public static int TAN_ARMOR_OVIS_HEAT_BONUS = 2;
        @Config.RequiresMcRestart
        @Config.Comment(value={"Additional items, that while in a players hand, will not trigger blocks that can be picked up, such as covered barrels, crates, etc.."})
        public static String[] BLACKLIST_BLOCK_PICKUP = new String[]{"thaumcraft:thaumometer"};
        @Config.RequiresMcRestart
        @Config.Comment(value={"Armor items that should be ignored by the swap feature"})
        public static String[] BLACKLIST_ARMOR_SWAP = new String[]{"openblocks:sleeping_bag"};
    }
}

