/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.helper;

import com.google.common.base.Predicate;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Locale;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import nmd.primal.core.api.PrimalAPI;
import nmd.primal.core.common.PrimalCore;
import nmd.primal.core.common.helper.checks.BlockMultiplexer;

public class CommonUtils {
    public static void dropItems(World world, BlockPos pos, NonNullList<ItemStack> list) {
        for (ItemStack stack : list) {
            if (stack.func_190926_b()) continue;
            float offset = 0.7f;
            double offsetX = (double)(PrimalCore.RANDOM.nextFloat() * offset) + (double)(1.0f - offset) * 0.5;
            double offsetY = (double)(PrimalCore.RANDOM.nextFloat() * offset) + (double)(1.0f - offset) * 0.5;
            double offsetZ = (double)(PrimalCore.RANDOM.nextFloat() * offset) + (double)(1.0f - offset) * 0.5;
            EntityItem item = new EntityItem(world, (double)pos.func_177958_n() + offsetX, (double)pos.func_177956_o() + offsetY, (double)pos.func_177952_p() + offsetZ, stack);
            item.func_174869_p();
            world.func_72838_d((Entity)item);
        }
    }

    public static ItemStack getRandomStack(int amount, Item ... items) {
        int count = items.length - 1;
        return new ItemStack(items[PrimalCore.RANDOM.nextInt(count)], amount);
    }

    public static ItemStack getRandomStack(int amount, Block ... blocks) {
        int count = blocks.length - 1;
        return new ItemStack(blocks[PrimalCore.RANDOM.nextInt(count)], amount);
    }

    public static boolean setBlock(World world, BlockPos pos, IBlockState state, int flag) {
        return !world.field_72995_K && world.func_180501_a(pos.func_177984_a(), state, flag);
    }

    public static boolean setBlock(World world, BlockPos pos, IBlockState state) {
        return CommonUtils.setBlock(world, pos, state, 2);
    }

    public static int updateFlag(World world) {
        return world.field_72995_K ? 11 : 2;
    }

    public static float getEntityQuadrantOnBlock(double pos) {
        return (float)((double)Math.round(pos % 1.0 * 100.0) / 100.0);
    }

    public static boolean hasState(IBlockState state, String name) {
        for (IProperty prop : state.func_177228_b().keySet()) {
            if (!prop.func_177701_a().equals(name)) continue;
            return true;
        }
        return false;
    }

    public static List<Block> getBlockList(String[] array) {
        ArrayList<Block> list = new ArrayList<Block>();
        for (String name : array) {
            Block block;
            if (name == null || name.isEmpty() || (block = Block.func_149684_b((String)name)) == null) continue;
            list.add(block);
        }
        return list;
    }

    public static List<Item> getItemList(String[] array) {
        ArrayList<Item> list = new ArrayList<Item>();
        for (String name : array) {
            Item item;
            if (name == null || name.isEmpty() || (item = Item.func_111206_d((String)name)) == null) continue;
            list.add(item);
        }
        return list;
    }

    public static List<ItemStack> getStackList(String[] array) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (String name : array) {
            PrimalAPI.logger(15, "adding item: " + name);
            if (name == null || name.isEmpty()) continue;
            PrimalAPI.logger(15, "trying to add item: " + name);
            Item item = Item.func_111206_d((String)name);
            if (item != null) {
                list.add(new ItemStack(item));
                continue;
            }
            PrimalAPI.logger(15, "trying to add block: " + name);
            Block block = Block.func_149684_b((String)name);
            if (block == null) continue;
            list.add(new ItemStack(Item.func_150898_a((Block)block)));
        }
        return list;
    }

    public static boolean matchItemList(String[] list, ItemStack stack) {
        return !stack.func_190926_b() && list.length > 0 && CommonUtils.getItemList(list).contains(stack.func_77973_b());
    }

    public static boolean matchItemList(List<ItemStack> list, ItemStack match) {
        if (!match.func_190926_b()) {
            for (ItemStack stack : list) {
                if (stack.func_77973_b() != match.func_77973_b()) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean spreadBlock(World world, BlockPos pos, IBlockState new_state, BlockMultiplexer predicate, int chance, int iteration, int range) {
        if (world.field_72995_K) {
            return true;
        }
        if (PrimalAPI.randomCheck(chance)) {
            for (int i = 0; i < iteration; ++i) {
                BlockPos spread_pos = new BlockPos((double)pos.func_177958_n() + world.field_73012_v.nextGaussian() * (double)range, (double)pos.func_177956_o() + world.field_73012_v.nextGaussian() * (double)(range * 2), (double)pos.func_177952_p() + world.field_73012_v.nextGaussian() * (double)range);
                IBlockState spread_state = world.func_180495_p(spread_pos);
                if (world.func_189509_E(spread_pos) || !spread_state.func_177230_c().isReplaceableOreGen(spread_state, (IBlockAccess)world, spread_pos, (Predicate)predicate)) continue;
                PrimalAPI.logger(2, "spread block", "success: " + predicate + "@" + spread_pos);
                return world.func_180501_a(spread_pos, new_state, 2);
            }
        }
        return false;
    }

    public static boolean checkForAir(IBlockAccess world, BlockPos pos) {
        for (EnumFacing face : EnumFacing.values()) {
            if (!world.func_175623_d(pos.func_177972_a(face))) continue;
            return true;
        }
        return false;
    }

    public static boolean isSurroundedBy(IBlockAccess world, BlockPos pos, Material ... materials) {
        for (EnumFacing face : EnumFacing.values()) {
            List<Material> list = Arrays.asList(materials);
            if (list.contains(world.func_180495_p(pos.func_177972_a(face)).func_185904_a())) continue;
            return false;
        }
        return true;
    }

    public static boolean isSurroundedBy(IBlockAccess world, BlockPos pos, Block ... blocks) {
        for (EnumFacing face : EnumFacing.values()) {
            List<Block> list = Arrays.asList(blocks);
            if (list.contains(world.func_180495_p(pos.func_177972_a(face)).func_177230_c())) continue;
            return false;
        }
        return true;
    }

    public static boolean hasNearByMaterial(IBlockAccess world, BlockPos pos, int range, int height, Material ... materials) {
        for (BlockPos.MutableBlockPos blockpos$mutableblockpos : BlockPos.func_177975_b((BlockPos)pos.func_177982_a(-range, -height, -range), (BlockPos)pos.func_177982_a(range, height, range))) {
            for (Material material : materials) {
                if (world.func_180495_p((BlockPos)blockpos$mutableblockpos).func_185904_a() != material) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasNearByBlock(IBlockAccess world, BlockPos pos, int range, int height, Block ... blocks) {
        for (BlockPos.MutableBlockPos blockpos$mutableblockpos : BlockPos.func_177975_b((BlockPos)pos.func_177982_a(-range, -height, -range), (BlockPos)pos.func_177982_a(range, height, range))) {
            for (Block block : blocks) {
                if (world.func_180495_p((BlockPos)blockpos$mutableblockpos).func_177230_c() != block) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasNearByMaterial(IBlockAccess world, BlockPos pos, int range, Material ... materials) {
        return CommonUtils.hasNearByMaterial(world, pos, range, 1, materials);
    }

    public static boolean hasAdjacentMaterial(IBlockAccess world, BlockPos pos, Material ... materials) {
        for (Material material : materials) {
            for (EnumFacing face : EnumFacing.values()) {
                if (world.func_180495_p(pos.func_177972_a(face)).func_185904_a() != material) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasAdjacentMaterial(IBlockAccess world, BlockPos pos, EnumFacing[] facings, Material ... materials) {
        for (Material material : materials) {
            for (EnumFacing facing : facings) {
                if (world.func_180495_p(pos.func_177972_a(facing)).func_185904_a() != material) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasAdjacentBlock(IBlockAccess world, BlockPos pos, EnumFacing[] facings, Block ... blocks) {
        for (Block block : blocks) {
            for (EnumFacing facing : facings) {
                if (world.func_180495_p(pos.func_177972_a(facing)).func_177230_c() != block) continue;
                return true;
            }
        }
        return false;
    }

    @Deprecated
    public static boolean isExposedToRain(World world, BlockPos pos) {
        return world.field_73011_w.func_191066_m() && world.func_175678_i(pos) && world.func_72896_J() && !world.canSnowAtBody(pos, false) && world.getBiomeForCoordsBody(pos).func_76727_i() > 0.0f && world.func_175725_q(pos).func_177956_o() <= pos.func_177956_o();
    }

    @Deprecated
    public static boolean isExposedToWeather(World world, BlockPos pos) {
        return world.field_73011_w.func_191066_m() && world.func_175678_i(pos) && world.func_72896_J() && world.getBiomeForCoordsBody(pos).func_76727_i() > 0.0f && world.func_175725_q(pos).func_177956_o() <= pos.func_177956_o();
    }

    public static boolean isExposedToSun(World world, BlockPos pos) {
        return world.field_73011_w.func_191066_m() && world.func_175678_i(pos) && !world.func_72896_J() && world.func_72935_r() && world.getSunBrightnessFactor(1.0f) > 0.375f;
    }

    public static String[] splitString(String string, String delimiter) {
        return string.replaceAll("\\s+", "").split(delimiter);
    }

    public static String[] splitString(String string) {
        return CommonUtils.splitString(string, ",");
    }

    public static boolean isValueMatch(int source, int ... values) {
        for (int value : values) {
            if (source != value) continue;
            return true;
        }
        return false;
    }

    public static String prefix(String name) {
        return String.format("%s.%s", "primal", name.toLowerCase(Locale.US));
    }

    public static String stringToBase64(String string) {
        return Base64.getEncoder().withoutPadding().encodeToString(string.getBytes());
    }

    public static String stringFromBase64(String string) {
        return new String(Base64.getDecoder().decode(string));
    }

    public static JsonArray getJSONArray(String location, String member) {
        BufferedReader buffer = CommonUtils.getBufferedFile(location);
        if (buffer != null) {
            JsonObject json = new JsonParser().parse((Reader)buffer).getAsJsonObject();
            return json.getAsJsonArray(member);
        }
        return new JsonArray();
    }

    public static BufferedReader getBufferedFile(String location) {
        InputStream file = PrimalCore.class.getResourceAsStream(location);
        if (file != null) {
            InputStreamReader stream = new InputStreamReader(file, StandardCharsets.UTF_8);
            return new BufferedReader(stream);
        }
        return null;
    }

    public static void removeDrop(List<EntityItem> drops, ItemStack stack) {
        drops.removeIf(i -> i.func_92059_d().func_77969_a(stack));
    }

    public static void addDrop(EntityLiving entity, List<EntityItem> drops, ItemStack stack) {
        drops.add(new EntityItem(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u + entity.func_70033_W(), entity.field_70161_v, stack));
    }

    public static RayTraceResult rayTrace(World worldIn, EntityPlayer player, boolean useLiquids) {
        float f = player.field_70125_A;
        float f1 = player.field_70177_z;
        double d0 = player.field_70165_t;
        double d1 = player.field_70163_u + (double)player.func_70047_e();
        double d2 = player.field_70161_v;
        Vec3d vec3d = new Vec3d(d0, d1, d2);
        float f2 = MathHelper.func_76134_b((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = MathHelper.func_76126_a((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = -MathHelper.func_76134_b((float)(-f * ((float)Math.PI / 180)));
        float f5 = MathHelper.func_76126_a((float)(-f * ((float)Math.PI / 180)));
        float f6 = f3 * f4;
        float f7 = f2 * f4;
        double d3 = 5.0;
        if (player instanceof EntityPlayerMP) {
            d3 = ((EntityPlayerMP)player).field_71134_c.getBlockReachDistance();
        }
        Vec3d vec3d1 = vec3d.func_72441_c((double)f6 * d3, (double)f5 * d3, (double)f7 * d3);
        return worldIn.func_147447_a(vec3d, vec3d1, useLiquids, !useLiquids, false);
    }

    public static void spawnChicken(World world, BlockPos pos) {
        EntityChicken entitychicken = new EntityChicken(world);
        entitychicken.func_70873_a(-24000);
        entitychicken.func_70012_b((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), MathHelper.func_76142_g((float)(PrimalCore.RANDOM.nextFloat() * 360.0f)), 0.0f);
        world.func_72838_d((Entity)entitychicken);
    }

    public static boolean addStack(ItemStackHandler stackHandler, EntityPlayer player, ItemStack held_stack, int slot) {
        ItemStack remainder;
        if (!held_stack.func_190926_b() && ((remainder = stackHandler.insertItem(slot, held_stack, false)).func_190926_b() || remainder.func_190916_E() != held_stack.func_190916_E())) {
            player.func_184611_a(EnumHand.MAIN_HAND, remainder);
            return true;
        }
        return false;
    }

    @Deprecated
    public static ItemStack removeStack(ItemStackHandler stackHandler, int slot, int amount) {
        ItemStack shelf_stack = stackHandler.getStackInSlot(slot);
        if (!shelf_stack.func_190926_b()) {
            if (shelf_stack.func_190916_E() > 1 && shelf_stack.func_190916_E() > amount) {
                stackHandler.setStackInSlot(slot, new ItemStack(shelf_stack.func_77973_b(), shelf_stack.func_190916_E() - amount, shelf_stack.func_77952_i()));
            } else {
                stackHandler.setStackInSlot(slot, ItemStack.field_190927_a);
            }
            return ItemHandlerHelper.copyStackWithSize((ItemStack)shelf_stack, (int)amount);
        }
        return ItemStack.field_190927_a;
    }

    public static void spawnLivingEntity(World world, EntityLiving entity, double x, double y, double z) {
        entity.func_70012_b(x, y, z, MathHelper.func_76142_g((float)(PrimalCore.RANDOM.nextFloat() * 360.0f)), 0.0f);
        entity.field_70759_as = entity.field_70177_z;
        entity.field_70761_aq = entity.field_70177_z;
        world.func_72838_d((Entity)entity);
        entity.func_70642_aH();
    }
}

