/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.fluids;

import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import nmd.primal.core.api.PrimalAPI;
import nmd.primal.core.common.fluids.AbstractFluidBlock;
import nmd.primal.core.common.helper.FXHelper;
import nmd.primal.core.common.helper.RecipeHelper;
import nmd.primal.core.common.init.ModConfig;

public class OvisAtreMilk
extends AbstractFluidBlock {
    public OvisAtreMilk(Fluid fluid, Material material) {
        super(fluid, material);
    }

    @Override
    public PathNodeType getAiPathNodeType(IBlockState state, IBlockAccess world, BlockPos pos) {
        return PathNodeType.LAVA;
    }

    @Override
    public boolean isSolidTexture() {
        return true;
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        super.func_180634_a(world, pos, state, entity);
        if (PrimalAPI.randomCheck(16) && entity instanceof EntityLivingBase && ((EntityLivingBase)entity).func_70644_a(MobEffects.field_82731_v)) {
            ((EntityLivingBase)entity).func_184589_d(MobEffects.field_82731_v);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        super.func_180655_c(state, world, pos, rand);
        if (world.func_180495_p(pos.func_177984_a()).func_185904_a() == Material.field_151579_a && !world.func_180495_p(pos.func_177984_a()).func_185914_p() && !world.func_175727_C(pos.func_177984_a())) {
            FXHelper.makeParticles(world, pos, EnumParticleTypes.EXPLOSION_NORMAL, 2, 16, 0.9f, 0.0);
        }
    }

    public void func_180650_b(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull Random rand) {
        super.func_180650_b(world, pos, state, rand);
        if (world.field_73011_w.func_177495_o()) {
            if (!this.isSourceBlock((IBlockAccess)world, pos) && !this.isFlowingVertically((IBlockAccess)world, pos)) {
                world.func_180501_a(pos, Blocks.field_150480_ab.func_176223_P(), 2);
            }
        } else if (PrimalAPI.randomCheck(6) && world.func_175727_C(pos.func_177984_a())) {
            RecipeHelper.changeBlock(world, pos, PrimalAPI.Blocks.DESICCATED_STONE.func_176223_P(), 16);
        }
    }

    @Override
    public boolean doFluidMixing(World world, BlockPos pos, IBlockState state) {
        if (ModConfig.Fluids.ENABLE_FLUID_MIXING_RECIPES) {
            block4: for (EnumFacing facing : EnumFacing.values()) {
                IBlockState facing_state = world.func_180495_p(pos.func_177972_a(facing));
                Material facing_material = facing_state.func_185904_a();
                Block facing_block = facing_state.func_177230_c();
                IBlockState output_lava = Blocks.field_150343_Z.func_176223_P();
                switch (facing) {
                    case UP: {
                        if (facing_block == Blocks.field_150353_l || facing_block == Blocks.field_150356_k) {
                            return RecipeHelper.changeBlock(world, pos.func_177972_a(facing), Blocks.field_150347_e.func_176223_P(), 16);
                        }
                        if (facing_material != Material.field_151586_h) continue block4;
                        return RecipeHelper.changeBlock(world, pos, PrimalAPI.Blocks.DESICCATED_STONE.func_176223_P(), 16);
                    }
                    case DOWN: {
                        if (facing_block == PrimalAPI.Fluids.MAGMA.getBlock()) {
                            if ((Integer)facing_state.func_177229_b((IProperty)BlockLiquid.field_176367_b) == 0) {
                                return RecipeHelper.changeBlock(world, pos.func_177972_a(facing), PrimalAPI.Blocks.OBSIDIAN_TRANSPARENT.func_176223_P(), 16);
                            }
                            return RecipeHelper.changeBlock(world, pos.func_177972_a(facing), ModConfig.Fluids.MILK_SPECIAL_INTERACTION ? output_lava : Blocks.field_189877_df.func_176223_P(), 16);
                        }
                        if (facing_block == PrimalAPI.Fluids.PARAFFIN.getBlock() && (Integer)facing_state.func_177229_b((IProperty)BlockLiquid.field_176367_b) == 0) {
                            return RecipeHelper.changeBlock(world, pos.func_177972_a(facing), PrimalAPI.Blocks.PORPHYRY_STONE.func_176223_P(), 16);
                        }
                        if (facing_block == Blocks.field_150356_k || facing_block == Blocks.field_150353_l) {
                            if ((Integer)facing_state.func_177229_b((IProperty)BlockLiquid.field_176367_b) == 0) {
                                return RecipeHelper.changeBlock(world, pos.func_177972_a(facing), output_lava, 16);
                            }
                            return RecipeHelper.changeBlock(world, pos.func_177972_a(facing), ModConfig.Fluids.MILK_SPECIAL_INTERACTION ? output_lava : Blocks.field_150348_b.func_176223_P(), 16);
                        }
                        if (facing_material != Material.field_151586_h) continue block4;
                        return RecipeHelper.changeBlock(world, pos, PrimalAPI.Blocks.DESICCATED_STONE.func_176223_P(), 16);
                    }
                    default: {
                        if (facing_block == Blocks.field_150356_k || facing_block == Blocks.field_150353_l) {
                            if ((Integer)facing_state.func_177229_b((IProperty)BlockLiquid.field_176367_b) == 0) {
                                return RecipeHelper.changeBlock(world, pos.func_177972_a(facing), output_lava, 16);
                            }
                            return RecipeHelper.changeBlock(world, pos.func_177972_a(facing), Blocks.field_150347_e.func_176223_P(), 16);
                        }
                        if (facing_material != Material.field_151586_h) continue block4;
                        return RecipeHelper.changeBlock(world, pos, PrimalAPI.Blocks.DESICCATED_STONE.func_176223_P(), 16);
                    }
                }
            }
        }
        return false;
    }

    public boolean isFlammable(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return true;
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return 24;
    }

    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return 2;
    }

    public boolean isFireSource(World world, BlockPos pos, EnumFacing face) {
        return face == EnumFacing.UP;
    }
}

