/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.events;

import net.minecraft.item.ItemStack;
import net.minecraftforge.event.furnace.FurnaceFuelBurnTimeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import nmd.primal.core.api.PrimalAPI;
import nmd.primal.core.common.init.ModConfig;
import nmd.primal.core.common.recipes.misc.FuelValue;

@Mod.EventBusSubscriber
public final class FuelHandler {
    @SubscribeEvent(priority=EventPriority.NORMAL)
    public static void fuelHandler(FurnaceFuelBurnTimeEvent event) {
        ItemStack eventStack;
        FuelValue fuelValue;
        if (ModConfig.Features.ENABLE_FUELS && (fuelValue = FuelValue.getFuelObject(eventStack = event.getItemStack())) != null) {
            if (!FuelValue.isAlreadyFuel(eventStack)) {
                ItemStack stack = fuelValue.getFuelStack();
                int value = fuelValue.getFuelValue();
                event.setBurnTime(value);
                PrimalAPI.logger(7, "Registering Fuel value for: " + stack + ":" + value);
            } else {
                PrimalAPI.logger(7, "Fuel Value already registered for: " + eventStack + ":" + event.getBurnTime());
            }
        }
    }

    static {
        if (ModConfig.Features.ENABLE_FUELS) {
            PrimalAPI.logger(1, "Registering Fuel Values");
        }
    }
}

