/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.entities.projectiles;

import net.minecraft.block.Block;
import net.minecraft.block.BlockLever;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import nmd.primal.core.api.PrimalAPI;
import nmd.primal.core.common.PrimalCore;
import nmd.primal.core.common.helper.FXHelper;
import nmd.primal.core.common.init.ModConfig;
import nmd.primal.core.common.items.projectiles.Rock;

public class TypeRock
extends EntityThrowable {
    private static final DataParameter<String> TYPE = EntityDataManager.func_187226_a(TypeRock.class, (DataSerializer)DataSerializers.field_187194_d);

    public TypeRock(World world) {
        super(world);
    }

    public TypeRock(World world, double x, double y, double z) {
        super(world, x, y, z);
    }

    public TypeRock(World world, EntityLivingBase entity) {
        super(world, entity);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(TYPE, (Object)"stone");
    }

    public ItemStack getTypeStack() {
        switch ((String)this.field_70180_af.func_187225_a(TYPE)) {
            case "andesite": {
                return new ItemStack(PrimalAPI.Items.ROCK_ANDESITE);
            }
            case "diorite": {
                return new ItemStack(PrimalAPI.Items.ROCK_DIORITE);
            }
            case "granite": {
                return new ItemStack(PrimalAPI.Items.ROCK_GRANITE);
            }
            case "netherrack": {
                return new ItemStack(PrimalAPI.Items.ROCK_NETHERRACK);
            }
            case "end": {
                return new ItemStack(PrimalAPI.Items.ROCK_END);
            }
        }
        return new ItemStack(PrimalAPI.Items.ROCK_STONE);
    }

    public String getType() {
        return (String)this.field_70180_af.func_187225_a(TYPE);
    }

    public void setType(String type) {
        this.field_70180_af.func_187227_b(TYPE, (Object)type);
    }

    protected float func_70185_h() {
        return 0.03f;
    }

    protected void func_70184_a(RayTraceResult hit) {
        IBlockState state;
        Block block;
        World world = this.func_130014_f_();
        if (hit.field_72308_g != null) {
            float damage = (float)ModConfig.Features.ROCK_DAMAGE + Rock.Type.byName((String)this.field_70180_af.func_187225_a(TYPE)).getDamgeModifier();
            hit.field_72308_g.func_70097_a(DamageSource.func_76356_a((Entity)this, (Entity)this.func_85052_h()), damage);
        }
        if (hit.field_72313_a == RayTraceResult.Type.BLOCK && (block = (state = world.func_180495_p(hit.func_178782_a())).func_177230_c()) instanceof BlockLever) {
            world.func_180501_a(hit.func_178782_a(), state.func_177231_a((IProperty)BlockLever.field_176359_b), 3);
            world.func_175685_c(hit.func_178782_a(), block, false);
            EnumFacing enumfacing = ((BlockLever.EnumOrientation)state.func_177229_b((IProperty)BlockLever.field_176360_a)).func_176852_c();
            world.func_175685_c(hit.func_178782_a().func_177972_a(enumfacing.func_176734_d()), block, false);
        }
        FXHelper.itemParticles(world, this.getTypeStack(), this.field_70165_t, this.field_70163_u, this.field_70161_v, 16);
        if (!world.field_72995_K) {
            this.func_70106_y();
            if (PrimalAPI.randomCheck(Rock.Type.byName((String)this.field_70180_af.func_187225_a(TYPE)).getDropChance())) {
                world.func_72838_d((Entity)new EntityItem(world, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.getTypeStack()));
            }
            world.func_184133_a((EntityPlayer)null, this.func_180425_c(), SoundEvents.field_187835_fT, SoundCategory.NEUTRAL, 0.5f, 0.4f / (PrimalCore.RANDOM.nextFloat() * 0.4f + 0.8f));
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
    }

    public boolean matchType(Rock.Type ... types) {
        for (Rock.Type type : types) {
            if (!this.getType().equals(type.func_176610_l())) continue;
            return true;
        }
        return false;
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74778_a("type", this.getType());
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setType(compound.func_74779_i("type"));
    }
}

