/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.entities.projectiles;

import net.minecraft.block.Block;
import net.minecraft.block.BlockLever;
import net.minecraft.block.BlockTorch;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import nmd.primal.core.api.PrimalAPI;
import nmd.primal.core.api.interfaces.ILit;
import nmd.primal.core.common.PrimalCore;
import nmd.primal.core.common.helper.FXHelper;
import nmd.primal.core.common.helper.FireHelper;
import nmd.primal.core.common.init.ModConfig;
import nmd.primal.core.common.items.projectiles.Mud;

public class TypeMud
extends EntityThrowable {
    private static final DataParameter<String> TYPE = EntityDataManager.func_187226_a(TypeMud.class, (DataSerializer)DataSerializers.field_187194_d);

    public TypeMud(World world) {
        super(world);
    }

    public TypeMud(World world, double x, double y, double z) {
        super(world, x, y, z);
    }

    public TypeMud(World world, EntityLivingBase entity) {
        super(world, entity);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(TYPE, (Object)"mud");
    }

    public String getType() {
        return (String)this.field_70180_af.func_187225_a(TYPE);
    }

    public void setType(String type) {
        this.field_70180_af.func_187227_b(TYPE, (Object)type);
    }

    public ItemStack getTypeStack() {
        switch ((String)this.field_70180_af.func_187225_a(TYPE)) {
            case "muck": {
                return new ItemStack(PrimalAPI.Items.MUCK);
            }
            case "muck_molten": {
                return new ItemStack(PrimalAPI.Items.MUCK_MOLTEN);
            }
            case "terra": {
                return new ItemStack(PrimalAPI.Items.TERRA_CLUMP);
            }
            case "cinis": {
                return new ItemStack(PrimalAPI.Items.CINIS_CLUMP);
            }
            case "adobe": {
                return new ItemStack(PrimalAPI.Items.ADOBE_CLUMP);
            }
            case "wax": {
                return new ItemStack(PrimalAPI.Items.PARAFFIN_CLUMP);
            }
            case "slag": {
                return new ItemStack(PrimalAPI.Items.SLAG);
            }
            case "fermented_jungle": {
                return new ItemStack(PrimalAPI.Items.FERMENTED_JUNGLE);
            }
            case "ancient_ice": {
                return new ItemStack(PrimalAPI.Items.ANCIENT_ICE_CHUNK);
            }
        }
        return new ItemStack(PrimalAPI.Items.MUD_CLUMP);
    }

    public SoundEvent getTypeSound() {
        switch ((String)this.field_70180_af.func_187225_a(TYPE)) {
            case "muck": 
            case "muck_molten": {
                return SoundEvents.field_187872_fl;
            }
            case "ancient_ice": {
                return PrimalAPI.Sounds.SOUND_BLOCK_ICE_FREEZE;
            }
        }
        return SoundEvents.field_187581_bW;
    }

    protected float func_70185_h() {
        return 0.03f;
    }

    protected void func_70184_a(RayTraceResult hit) {
        World world = this.func_130014_f_();
        if (hit.field_72308_g != null && hit.field_72308_g instanceof EntityLivingBase && hit.field_72308_g != this.field_70192_c) {
            float damage = (float)ModConfig.Features.ROCK_DAMAGE + Mud.Type.byName((String)this.field_70180_af.func_187225_a(TYPE)).getDamgeModifier();
            hit.field_72308_g.func_70097_a(DamageSource.func_76356_a((Entity)this, (Entity)this.func_85052_h()), damage);
            switch (this.getType()) {
                case "muck": {
                    ((EntityLivingBase)hit.field_72308_g).func_70690_d(new PotionEffect(MobEffects.field_76421_d, 80, 2));
                    break;
                }
                case "fermented_jungle": {
                    ((EntityLivingBase)hit.field_72308_g).func_70690_d(new PotionEffect(MobEffects.field_76431_k, 60, 1));
                    break;
                }
                case "ancient_ice": {
                    ((EntityLivingBase)hit.field_72308_g).func_70690_d(new PotionEffect(MobEffects.field_76437_t, 160, 1));
                    break;
                }
                case "muck_molten": {
                    hit.field_72308_g.func_70015_d(PrimalCore.RANDOM.nextInt(6, 24));
                }
            }
        }
        if (hit.field_72313_a == RayTraceResult.Type.BLOCK) {
            IBlockState state = world.func_180495_p(hit.func_178782_a());
            Block block = state.func_177230_c();
            switch (this.getType()) {
                case "muck_molten": {
                    if (block instanceof ILit && !((Boolean)state.func_177229_b((IProperty)ILit.LIT)).booleanValue()) {
                        world.func_180501_a(hit.func_178782_a(), state.func_177226_a((IProperty)ILit.LIT, (Comparable)Boolean.valueOf(true)), 3);
                        world.func_175685_c(hit.func_178782_a(), block, false);
                    }
                    if (block instanceof BlockLever) {
                        world.func_180501_a(hit.func_178782_a(), state.func_177231_a((IProperty)BlockLever.field_176359_b), 3);
                        world.func_175685_c(hit.func_178782_a(), block, false);
                        EnumFacing enumfacing = ((BlockLever.EnumOrientation)state.func_177229_b((IProperty)BlockLever.field_176360_a)).func_176852_c();
                        world.func_175685_c(hit.func_178782_a().func_177972_a(enumfacing.func_176734_d()), block, false);
                    }
                    FireHelper.setFire(world, hit.func_178782_a());
                    break;
                }
                default: {
                    if (block == Blocks.field_150478_aa) {
                        world.func_180501_a(hit.func_178782_a(), PrimalAPI.Blocks.TORCH_WOOD.func_176223_P().func_177226_a((IProperty)ILit.LIT, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)BlockTorch.field_176596_a, state.func_177229_b((IProperty)BlockTorch.field_176596_a)), 3);
                        world.func_175685_c(hit.func_178782_a(), block, false);
                        break;
                    }
                    if (block instanceof ILit && ((Boolean)state.func_177229_b((IProperty)ILit.LIT)).booleanValue()) {
                        world.func_180501_a(hit.func_178782_a(), state.func_177226_a((IProperty)ILit.LIT, (Comparable)Boolean.valueOf(false)), 3);
                        world.func_175685_c(hit.func_178782_a(), block, true);
                        break;
                    }
                    if (!(block instanceof BlockLever)) break;
                    world.func_180501_a(hit.func_178782_a(), state.func_177231_a((IProperty)BlockLever.field_176359_b), 3);
                    world.func_175685_c(hit.func_178782_a(), block, false);
                    EnumFacing enumfacing = ((BlockLever.EnumOrientation)state.func_177229_b((IProperty)BlockLever.field_176360_a)).func_176852_c();
                    world.func_175685_c(hit.func_178782_a().func_177972_a(enumfacing.func_176734_d()), block, false);
                }
            }
        }
        FXHelper.itemParticles(world, this.getTypeStack(), this.field_70165_t, this.field_70163_u, this.field_70161_v, 16);
        if (!world.field_72995_K) {
            this.func_70106_y();
            if (!(!PrimalAPI.randomCheck(Mud.Type.byName((String)this.field_70180_af.func_187225_a(TYPE)).getDropChance()) || this.getType().equals("muck_molten") && this.func_70090_H() || this.getType().equals("ancient_ice") && this.func_180799_ab())) {
                world.func_72838_d((Entity)new EntityItem(world, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.getTypeStack()));
            }
            world.func_184133_a((EntityPlayer)null, this.func_180425_c(), this.getTypeSound(), SoundCategory.NEUTRAL, 0.5f, 0.4f / (PrimalCore.RANDOM.nextFloat() * 0.4f + 0.8f));
        }
    }

    public void func_70030_z() {
        super.func_70030_z();
        World world = this.func_130014_f_();
        BlockPos pos = this.func_180425_c();
        String type = this.getType();
        if (!world.field_72995_K) {
            if (type.equals("muck_molten") && this.func_70090_H() && world.func_180495_p(pos).func_185904_a() == Material.field_151586_h) {
                world.func_180501_a(pos, Blocks.field_150348_b.func_176223_P(), 2);
                this.func_70106_y();
            }
            if (type.equals("ancient_ice")) {
                if (this.func_70090_H() && world.func_180495_p(pos).func_185904_a() == Material.field_151586_h) {
                    world.func_180501_a(pos, Blocks.field_150432_aD.func_176223_P(), 2);
                    FXHelper.fxIce(world, pos, 1.5f);
                    this.func_70106_y();
                } else if (this.func_180799_ab() && world.func_180495_p(pos.func_177972_a(EnumFacing.DOWN)).func_185904_a() == Material.field_151587_i) {
                    IBlockState state = world.func_180495_p(pos.func_177972_a(EnumFacing.DOWN));
                    Block block = state.func_177230_c();
                    IBlockState change_state = block == PrimalAPI.Fluids.OVIS_ATRE_MILK.getBlock() ? PrimalAPI.Blocks.DESICCATED_STONE.func_176223_P() : (block == PrimalAPI.Fluids.MAGMA.getBlock() ? PrimalAPI.Blocks.SARSEN_STONE.func_176223_P() : Blocks.field_150347_e.func_176223_P());
                    world.func_180501_a(pos.func_177972_a(EnumFacing.DOWN), change_state, 2);
                    FXHelper.fxLava(world, pos);
                    this.func_70106_y();
                }
            }
        }
    }

    public boolean matchType(Mud.Type ... types) {
        for (Mud.Type type : types) {
            if (!this.getType().equals(type.func_176610_l())) continue;
            return true;
        }
        return false;
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74778_a("type", this.getType());
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setType(compound.func_74779_i("type"));
    }
}

