/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.entities.living;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockGrass;
import net.minecraft.block.BlockGrassPath;
import net.minecraft.block.BlockSnow;
import net.minecraft.block.BlockSnowBlock;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFollowParent;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityGolem;
import net.minecraft.entity.monster.EntityPolarBear;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import nmd.primal.core.api.PrimalAPI;
import nmd.primal.core.common.compat.ModLoot;
import nmd.primal.core.common.entities.living.EntityBlackBear;
import nmd.primal.core.common.entities.living.EntityNetherCreeper;
import nmd.primal.core.common.entities.living.EntityOvisAtre;
import nmd.primal.core.common.helper.WorldHelper;
import nmd.primal.core.common.init.ModConfig;

public class EntityBrownBear
extends EntityAnimal
implements IMob {
    private static final DataParameter<Boolean> IS_STANDING = EntityDataManager.func_187226_a(EntityBrownBear.class, (DataSerializer)DataSerializers.field_187198_h);
    private float clientSideStandAnimation0;
    private float clientSideStandAnimation;
    private int warningSoundTicks;

    public EntityBrownBear(World worldIn) {
        super(worldIn);
        this.func_70105_a(1.3f, 1.4f);
    }

    public EntityAgeable func_90011_a(EntityAgeable ageable) {
        return new EntityBrownBear(this.field_70170_p);
    }

    public boolean func_70877_b(ItemStack stack) {
        return false;
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AIMeleeAttack());
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityCreeper.class, 6.0f, 1.0, 1.2));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityNetherCreeper.class, 6.0f, 1.0, 1.2));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityOvisAtre.class, 6.0f, 1.0, 1.2));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityGolem.class, 6.0f, 1.0, 1.2));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIFollowParent((EntityAnimal)this, 1.25));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityLivingBase.class, 6.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new AIHurtByTarget());
        this.field_70715_bh.func_75776_a(3, new AISpecialTarget<EntityLivingBase>(this, EntityLivingBase.class));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(ModConfig.Monsters.BEAR_BROWN_STATS[0]);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(ModConfig.Monsters.BEAR_BROWN_STATS[1]);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(ModConfig.Monsters.BEAR_BROWN_STATS[2]);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(ModConfig.Monsters.BEAR_BROWN_STATS[3]);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(ModConfig.Monsters.BEAR_BROWN_STATS[4]);
    }

    public boolean func_70686_a(Class attack) {
        return EntityPolarBear.class != attack && EntityBrownBear.class != attack && EntityBlackBear.class != attack && EntityOvisAtre.class != attack && EntityNetherCreeper.class != attack && EntityCreeper.class != attack;
    }

    protected SoundEvent func_184639_G() {
        return this.func_70631_g_() ? SoundEvents.field_190027_es : SoundEvents.field_190026_er;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundEvents.field_190029_eu;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_190028_et;
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(SoundEvents.field_190030_ev, 0.15f, 1.0f);
    }

    protected void playWarningSound() {
        if (this.warningSoundTicks <= 0) {
            this.func_184185_a(SoundEvents.field_190031_ew, 1.0f, 1.0f);
            this.warningSoundTicks = 40;
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(IS_STANDING, (Object)false);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            this.clientSideStandAnimation0 = this.clientSideStandAnimation;
            this.clientSideStandAnimation = this.isStanding() ? MathHelper.func_76131_a((float)(this.clientSideStandAnimation + 1.0f), (float)0.0f, (float)6.0f) : MathHelper.func_76131_a((float)(this.clientSideStandAnimation - 1.0f), (float)0.0f, (float)6.0f);
        }
        if (this.warningSoundTicks > 0) {
            --this.warningSoundTicks;
        }
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean flag = entityIn.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)((int)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e()));
        if (flag) {
            this.func_174815_a((EntityLivingBase)this, entityIn);
        }
        return flag;
    }

    public boolean isStanding() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_STANDING);
    }

    public void setStanding(boolean standing) {
        this.field_70180_af.func_187227_b(IS_STANDING, (Object)standing);
    }

    @SideOnly(value=Side.CLIENT)
    public float getStandingAnimationScale(float p_189795_1_) {
        return (this.clientSideStandAnimation0 + (this.clientSideStandAnimation - this.clientSideStandAnimation0) * p_189795_1_) / 6.0f;
    }

    protected float func_189749_co() {
        return 0.98f;
    }

    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, IEntityLivingData livingdata) {
        if (livingdata instanceof GroupData) {
            if (((GroupData)livingdata).madeParent) {
                this.func_70873_a(-24000);
            }
        } else {
            GroupData entitypolarbear$groupdata = new GroupData();
            entitypolarbear$groupdata.madeParent = true;
            livingdata = entitypolarbear$groupdata;
        }
        return livingdata;
    }

    public boolean func_70601_bi() {
        IBlockState ground = this.field_70170_p.func_180495_p(new BlockPos((Entity)this).func_177977_b());
        if (ground.func_189884_a((Entity)this)) {
            BlockPos blockPos = new BlockPos(this.field_70165_t, this.func_174813_aQ().field_72338_b, this.field_70161_v);
            if (this.func_180484_a(blockPos) >= 0.0f) {
                BlockPos blockpos = new BlockPos(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b), MathHelper.func_76128_c((double)this.field_70161_v));
                Block block = this.field_70170_p.func_180495_p(blockpos.func_177977_b()).func_177230_c();
                return WorldHelper.isMobLightLevel((EntityLivingBase)this) && (block instanceof BlockGrass || block instanceof BlockGrassPath || block instanceof BlockSnow || block instanceof BlockSnowBlock);
            }
        }
        return false;
    }

    public int func_70641_bl() {
        return 1;
    }

    protected boolean func_70692_ba() {
        return !this.func_145818_k_() && this.field_70173_aa > 24000;
    }

    protected ResourceLocation func_184647_J() {
        return ModLoot.ENTITIES_BROWN_BEAR;
    }

    static class GroupData
    implements IEntityLivingData {
        public boolean madeParent;

        private GroupData() {
        }
    }

    class AIPanic
    extends EntityAIPanic {
        public AIPanic() {
            super((EntityCreature)EntityBrownBear.this, 2.0);
        }

        public boolean func_75250_a() {
            return !EntityBrownBear.this.func_70631_g_() && !EntityBrownBear.this.func_70027_ad() ? false : super.func_75250_a();
        }
    }

    class AIMeleeAttack
    extends EntityAIAttackMelee {
        public AIMeleeAttack() {
            super((EntityCreature)EntityBrownBear.this, 1.25, true);
        }

        protected void func_190102_a(EntityLivingBase entity, double p_190102_2_) {
            double d0 = this.func_179512_a(entity);
            if (p_190102_2_ <= d0 && this.field_75439_d <= 0) {
                this.field_75439_d = 20;
                this.field_75441_b.func_70652_k((Entity)entity);
                EntityBrownBear.this.setStanding(false);
            } else if (p_190102_2_ <= d0 * 2.0) {
                if (this.field_75439_d <= 0) {
                    EntityBrownBear.this.setStanding(false);
                    this.field_75439_d = 20;
                }
                if (this.field_75439_d <= 10) {
                    EntityBrownBear.this.setStanding(true);
                    EntityBrownBear.this.playWarningSound();
                }
            } else {
                this.field_75439_d = 20;
                EntityBrownBear.this.setStanding(false);
            }
        }

        public void func_75251_c() {
            EntityBrownBear.this.setStanding(false);
            super.func_75251_c();
        }

        protected double func_179512_a(EntityLivingBase attackTarget) {
            return 4.0f + attackTarget.field_70130_N;
        }
    }

    class AIHurtByTarget
    extends EntityAIHurtByTarget {
        public AIHurtByTarget() {
            super((EntityCreature)EntityBrownBear.this, false, new Class[0]);
        }

        public void func_75249_e() {
            if (EntityBrownBear.this.field_70170_p.func_175659_aa() != EnumDifficulty.PEACEFUL) {
                super.func_75249_e();
                if (EntityBrownBear.this.func_70631_g_()) {
                    this.func_190105_f();
                    this.func_75251_c();
                }
            }
        }

        protected void func_179446_a(EntityCreature creatureIn, EntityLivingBase entityLivingBaseIn) {
            if (creatureIn != null && creatureIn instanceof EntityBrownBear && !creatureIn.func_70631_g_()) {
                super.func_179446_a(creatureIn, entityLivingBaseIn);
            }
        }
    }

    class AIAttackPlayer
    extends EntityAINearestAttackableTarget<EntityPlayer> {
        public AIAttackPlayer() {
            super((EntityCreature)EntityBrownBear.this, EntityPlayer.class, 20, true, true, null);
        }

        public boolean func_75250_a() {
            if (EntityBrownBear.this.func_70631_g_()) {
                return false;
            }
            if (super.func_75250_a()) {
                for (EntityBrownBear entitypolarbear : EntityBrownBear.this.field_70170_p.func_72872_a(EntityBrownBear.class, EntityBrownBear.this.func_174813_aQ().func_72321_a(8.0, 4.0, 8.0))) {
                    if (!entitypolarbear.func_70631_g_()) continue;
                    return true;
                }
            }
            EntityBrownBear.this.func_70624_b(null);
            return false;
        }

        protected double func_111175_f() {
            return super.func_111175_f() * 0.5;
        }
    }

    static class AISpecialTarget<T extends EntityLivingBase>
    extends EntityAINearestAttackableTarget<T> {
        public AISpecialTarget(EntityBrownBear canis, Class<T> classTarget) {
            super((EntityCreature)canis, classTarget, true);
        }

        public boolean func_75250_a() {
            World world = this.field_75299_d.func_130014_f_();
            if (world.func_175659_aa() != EnumDifficulty.PEACEFUL) {
                float attack_weight = 0.65f;
                float attack_range = 12.0f;
                if (this.field_75309_a != null) {
                    return PrimalAPI.randomCheck(attack_weight) && super.func_75250_a();
                }
                List list = world.func_175647_a(this.field_75307_b, this.func_188511_a(attack_range), this.field_82643_g);
                if (!list.isEmpty()) {
                    list.sort(this.field_75306_g);
                    this.field_75309_a = (EntityLivingBase)list.get(0);
                    return PrimalAPI.randomCheck(attack_weight);
                }
            }
            return false;
        }
    }
}

