/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.compat.ct;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ModOnly;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.registries.IForgeRegistryEntry;
import nmd.primal.core.common.PrimalCore;
import nmd.primal.core.common.helper.RecipeHelper;
import nmd.primal.core.common.recipes.tile.SmelterRecipe;
import stanhebben.zenscript.annotations.NotNull;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.primal.Smelter")
@ModOnly(value="primal")
@ZenRegister
public class CTSmelter {
    @ZenMethod
    public static void addRecipe(String recipe_name, int cook_time, @NotNull IIngredient[] input, @NotNull IItemStack[] output, @Optional IItemStack catalyst) {
        CraftTweakerAPI.apply((IAction)new Add(recipe_name, cook_time, input, output, catalyst));
    }

    @ZenMethod
    public static void removeRecipe(String recipe_name) {
        CraftTweakerAPI.apply((IAction)new Remove(recipe_name));
    }

    @ZenMethod
    public static void removeAll() {
        CraftTweakerAPI.apply((IAction)new RemoveAll());
    }

    static {
        PrimalCore.LOGGER.info("Registering CraftTweaker: smelter");
    }

    private static class RemoveAll
    implements IAction {
        public void apply() {
            for (SmelterRecipe recipe : SmelterRecipe.RECIPES) {
                if (recipe.isHidden()) continue;
                recipe.setDisabled(true);
            }
        }

        public String describe() {
            return "[PrimalCore] Removing Crafting Tweaker recipe for: smelter";
        }
    }

    private static class Remove
    implements IAction {
        private String recipe_name;

        public Remove(String recipe_name) {
            this.recipe_name = recipe_name;
        }

        public void apply() {
            SmelterRecipe recipe = (SmelterRecipe)SmelterRecipe.REGISTRY.getValue(SmelterRecipe.getFullRecipeName(this.recipe_name));
            if (recipe != null && !recipe.isHidden()) {
                PrimalCore.LOGGER.info("Remove CraftTweaker Recipe: " + this.recipe_name);
                recipe.setDisabled(true);
            }
        }

        public String describe() {
            return "[PrimalCore] Removing Crafting Tweaker recipe for: smelter";
        }
    }

    private static class Add
    implements IAction {
        private final String recipe_name;
        private final List<ItemStack> input_slot_1;
        private final List<ItemStack> input_slot_2;
        private final List<ItemStack> input_slot_3;
        private final List<ItemStack> input_slot_4;
        private final ItemStack output_slot_1;
        private final ItemStack output_slot_2;
        private final ItemStack output_slot_3;
        private final ItemStack output_slot_4;
        private final ItemStack catalyst;
        private final int cook_time;
        private boolean is_disabled;
        private boolean is_hidden;
        private boolean has_slag;

        public Add(String recipe_name, int cook_time, IIngredient[] input, IItemStack[] output, IItemStack catalyst) {
            this.recipe_name = recipe_name;
            this.cook_time = cook_time;
            this.is_disabled = false;
            this.is_hidden = false;
            this.catalyst = RecipeHelper.getStackFromCT(catalyst);
            this.input_slot_1 = input.length > 0 ? RecipeHelper.getIIngredientStacks(input[0]) : null;
            this.input_slot_2 = input.length > 1 ? RecipeHelper.getIIngredientStacks(input[1]) : null;
            this.input_slot_3 = input.length > 2 ? RecipeHelper.getIIngredientStacks(input[2]) : null;
            this.input_slot_4 = input.length > 3 ? RecipeHelper.getIIngredientStacks(input[3]) : null;
            this.output_slot_1 = output.length > 0 ? RecipeHelper.getStackFromCT(output[0]) : ItemStack.field_190927_a;
            this.output_slot_2 = output.length > 1 ? RecipeHelper.getStackFromCT(output[1]) : ItemStack.field_190927_a;
            this.output_slot_3 = output.length > 2 ? RecipeHelper.getStackFromCT(output[2]) : ItemStack.field_190927_a;
            this.output_slot_4 = output.length > 3 ? RecipeHelper.getStackFromCT(output[3]) : ItemStack.field_190927_a;
        }

        public void apply() {
            PrimalCore.LOGGER.info("Add CraftTweaker Recipe: " + this.recipe_name);
            SmelterRecipe.REGISTRY.register((IForgeRegistryEntry)((SmelterRecipe)new SmelterRecipe(this.cook_time, this.input_slot_1, this.input_slot_2, this.input_slot_3, this.input_slot_4, this.output_slot_1, this.output_slot_2, this.output_slot_3, this.output_slot_4).setRecipeName(this.recipe_name)).setCatalyst(this.catalyst).setSlag(true));
        }

        public String describe() {
            return "[PrimalCore] Removing Crafting Tweaker recipe for: smelter";
        }
    }
}

