/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.compat.ct;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ModOnly;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.minecraft.CraftTweakerMC;
import net.minecraft.block.state.IBlockState;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.registries.IForgeRegistryEntry;
import nmd.primal.core.common.PrimalCore;
import nmd.primal.core.common.recipes.inworld.MagmaRecipe;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.primal.Magma")
@ModOnly(value="primal")
@ZenRegister
public class CTMagma {
    @ZenMethod
    public static void addRecipe(String recipe_name, Fluid input, crafttweaker.api.block.IBlockState output) {
        CraftTweakerAPI.apply((IAction)new Add(recipe_name, input, CraftTweakerMC.getBlockState((crafttweaker.api.block.IBlockState)output)));
    }

    @ZenMethod
    public static void removeRecipe(String recipe_name) {
        CraftTweakerAPI.apply((IAction)new Remove(recipe_name));
    }

    @ZenMethod
    public static void removeAll() {
        CraftTweakerAPI.apply((IAction)new RemoveAll());
    }

    static {
        PrimalCore.LOGGER.info("Registering CraftTweaker: magma");
    }

    private static class RemoveAll
    implements IAction {
        public void apply() {
            for (MagmaRecipe recipe : MagmaRecipe.RECIPES) {
                if (recipe.isHidden()) continue;
                recipe.setDisabled(true);
            }
        }

        public String describe() {
            return "[PrimalCore] Removing Crafting Tweaker recipe for: magma";
        }
    }

    private static class Remove
    implements IAction {
        private String recipe_name;

        public Remove(String recipe_name) {
            this.recipe_name = recipe_name;
        }

        public void apply() {
            MagmaRecipe recipe = (MagmaRecipe)MagmaRecipe.REGISTRY.getValue(MagmaRecipe.getFullRecipeName(this.recipe_name));
            if (recipe != null && !recipe.isHidden()) {
                PrimalCore.LOGGER.info("Remove CraftTweaker Recipe: " + this.recipe_name);
                recipe.setDisabled(true);
            }
        }

        public String describe() {
            return "[PrimalCore] Removing Crafting Tweaker recipe for: magma";
        }
    }

    private static class Add
    implements IAction {
        private final String recipe_name;
        private final Fluid input;
        private final IBlockState output;
        private boolean is_disabled;
        private boolean is_hidden;

        public Add(String recipe_name, Fluid input, IBlockState output) {
            this.recipe_name = recipe_name;
            this.input = input;
            this.output = output;
            this.is_disabled = false;
            this.is_hidden = false;
        }

        public void apply() {
            PrimalCore.LOGGER.info("Add CraftTweaker Recipe: " + this.recipe_name);
            MagmaRecipe.REGISTRY.register((IForgeRegistryEntry)new MagmaRecipe(this.input, this.output).setRecipeName(this.recipe_name));
        }

        public String describe() {
            return "[PrimalCore] Removing Crafting Tweaker recipe for: magma";
        }
    }
}

