/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.compat.ct;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ModOnly;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.liquid.ILiquidStack;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.IForgeRegistryEntry;
import nmd.primal.core.common.PrimalCore;
import nmd.primal.core.common.helper.RecipeHelper;
import nmd.primal.core.common.recipes.tile.CauldronRecipe;
import stanhebben.zenscript.annotations.NotNull;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.primal.Cauldron")
@ModOnly(value="primal")
@ZenRegister
public class CTCauldron {
    @ZenMethod
    public static void addRecipe(String recipe_name, int cook_time, ILiquidStack fluid_input, ILiquidStack fluid_output, @NotNull IIngredient[] item_input, @NotNull IItemStack[] item_output, @Optional IItemStack catalyst) {
        CraftTweakerAPI.apply((IAction)new Add(recipe_name, cook_time, fluid_input, fluid_output, item_input, item_output, catalyst));
    }

    @ZenMethod
    public static void addRecipe(String recipe_name, int cook_time, ILiquidStack fluid_input, IIngredient[] item_input, IItemStack[] item_output, @Optional IItemStack catalyst) {
        CTCauldron.addRecipe(recipe_name, cook_time, fluid_input, null, item_input, item_output, catalyst);
    }

    @ZenMethod
    public static void removeRecipe(String recipe_name) {
        CraftTweakerAPI.apply((IAction)new Remove(recipe_name));
    }

    @ZenMethod
    public static void removeAll() {
        CraftTweakerAPI.apply((IAction)new RemoveAll());
    }

    static {
        PrimalCore.LOGGER.info("Registering CraftTweaker: cauldron");
    }

    private static class RemoveAll
    implements IAction {
        public void apply() {
            for (CauldronRecipe recipe : CauldronRecipe.RECIPES) {
                if (recipe.isHidden()) continue;
                recipe.setDisabled(true);
            }
        }

        public String describe() {
            return "[PrimalCore] Removing Crafting Tweaker recipe for: cauldron";
        }
    }

    private static class Remove
    implements IAction {
        private String recipe_name;

        public Remove(String recipe_name) {
            this.recipe_name = recipe_name;
        }

        public void apply() {
            CauldronRecipe recipe = (CauldronRecipe)CauldronRecipe.REGISTRY.getValue(CauldronRecipe.getFullRecipeName(this.recipe_name));
            if (recipe != null && !recipe.isHidden()) {
                PrimalCore.LOGGER.info("Remove CraftTweaker Recipe: " + this.recipe_name);
                recipe.setDisabled(true);
            } else {
                PrimalCore.LOGGER.info("Failed to Remove CraftTweaker Recipe: " + this.recipe_name);
            }
        }

        public String describe() {
            return "[PrimalCore] Removing Crafting Tweaker recipe for: cauldron";
        }
    }

    private static class Add
    implements IAction {
        private final String recipe_name;
        private final FluidStack fluid_input;
        private final FluidStack fluid_output;
        private final List<ItemStack> item_input_1;
        private final List<ItemStack> item_input_2;
        private final List<ItemStack> item_input_3;
        private final List<ItemStack> item_input_4;
        private final ItemStack item_output_1;
        private final ItemStack item_output_2;
        private final ItemStack catalyst;
        private final int cook_time;
        private boolean is_disabled;
        private boolean is_hidden;

        public Add(String recipe_name, int cook_time, ILiquidStack fluid_input, ILiquidStack fluid_output, IIngredient[] item_input, IItemStack[] item_output, IItemStack catalyst) {
            this.recipe_name = recipe_name;
            this.cook_time = cook_time;
            this.is_disabled = false;
            this.is_hidden = false;
            this.catalyst = catalyst != null ? (ItemStack)catalyst.getInternal() : ItemStack.field_190927_a;
            this.fluid_input = RecipeHelper.getStackFromCT(fluid_input);
            this.fluid_output = RecipeHelper.getStackFromCT(fluid_output);
            this.item_input_1 = item_input.length > 0 ? RecipeHelper.getIIngredientStacks(item_input[0]) : null;
            this.item_input_2 = item_input.length > 1 ? RecipeHelper.getIIngredientStacks(item_input[1]) : null;
            this.item_input_3 = item_input.length > 2 ? RecipeHelper.getIIngredientStacks(item_input[2]) : null;
            this.item_input_4 = item_input.length > 3 ? RecipeHelper.getIIngredientStacks(item_input[3]) : null;
            this.item_output_1 = item_output.length > 0 ? RecipeHelper.getStackFromCT(item_output[0]) : ItemStack.field_190927_a;
            this.item_output_2 = item_output.length > 1 ? RecipeHelper.getStackFromCT(item_output[1]) : ItemStack.field_190927_a;
        }

        public void apply() {
            PrimalCore.LOGGER.info("Add CraftTweaker Recipe: " + this.recipe_name);
            CauldronRecipe.REGISTRY.register((IForgeRegistryEntry)((CauldronRecipe)new CauldronRecipe(this.cook_time, this.fluid_input, this.fluid_output, this.item_input_1, this.item_input_2, this.item_input_3, this.item_input_4, this.item_output_1, this.item_output_2).setRecipeName(this.recipe_name)).setCatalyst(this.catalyst));
        }

        public String describe() {
            return "[PrimalCore] Removing Crafting Tweaker recipe for: cauldron";
        }
    }
}

