/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.blocks.saxum;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import nmd.primal.core.api.PrimalAPI;
import nmd.primal.core.common.blocks.AbstractSoil;

public class NetherPath
extends AbstractSoil {
    private static final AxisAlignedBB field_194405_c = new AxisAlignedBB(0.0, 0.9375, 0.0, 1.0, 1.0, 1.0);

    public NetherPath() {
        this.func_149713_g(255);
        this.func_149649_H();
    }

    private void updateBlockState(World world, BlockPos pos) {
        if (world.func_180495_p(pos.func_177984_a()).isSideSolid((IBlockAccess)world, pos, EnumFacing.DOWN)) {
            NetherPath.turnToDirt(world, pos);
        }
    }

    private static void turnToDirt(World world, BlockPos pos) {
        world.func_175656_a(pos, Blocks.field_150346_d.func_176223_P());
        AxisAlignedBB axisalignedbb = field_194405_c.func_186670_a(pos);
        for (Entity entity : world.func_72839_b((Entity)null, axisalignedbb)) {
            double d0 = Math.min(axisalignedbb.field_72337_e - axisalignedbb.field_72338_b, axisalignedbb.field_72337_e - entity.func_174813_aQ().field_72338_b);
            entity.func_70634_a(entity.field_70165_t, entity.field_70163_u + d0 + 0.001, entity.field_70161_v);
        }
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        super.func_189540_a(state, world, pos, block, fromPos);
        this.updateBlockState(world, pos);
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return PrimalAPI.Blocks.NETHER_EARTH.func_180660_a(PrimalAPI.Blocks.NETHER_EARTH.func_176223_P(), rand, fortune);
    }

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        return new ItemStack((Block)this);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return PrimalAPI.Bounds.AABB_FARMLAND;
    }

    @Override
    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entity, boolean isActualState) {
        if (entity instanceof EntityLivingBase) {
            NetherPath.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)PrimalAPI.Bounds.AABB_FARMLAND);
        } else {
            NetherPath.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)field_185505_j);
        }
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return face == EnumFacing.DOWN ? BlockFaceShape.SOLID : BlockFaceShape.UNDEFINED;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        switch (side) {
            case UP: {
                return true;
            }
            case NORTH: 
            case SOUTH: 
            case WEST: 
            case EAST: {
                IBlockState iblockstate = blockAccess.func_180495_p(pos.func_177972_a(side));
                Block block = iblockstate.func_177230_c();
                return !iblockstate.func_185914_p() && block != Blocks.field_150458_ak && block != Blocks.field_185774_da && block != PrimalAPI.Blocks.STAIRS_PATH && block != PrimalAPI.Blocks.NETHER_PATH;
            }
        }
        return super.func_176225_a(blockState, blockAccess, pos, side);
    }
}

