/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.blocks.saxum;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import nmd.primal.core.api.PrimalAPI;
import nmd.primal.core.api.interfaces.ISchedule;
import nmd.primal.core.api.interfaces.ISpreadBlock;
import nmd.primal.core.api.interfaces.IStackedLand;
import nmd.primal.core.common.blocks.AbstractSoil;
import nmd.primal.core.common.helper.BlockHelper;
import nmd.primal.core.common.helper.FXHelper;
import nmd.primal.core.common.helper.PlayerHelper;
import nmd.primal.core.common.init.ModConfig;

public class NetherGrowth
extends AbstractSoil
implements ISchedule,
IStackedLand,
ISpreadBlock {
    public NetherGrowth() {
        super(Material.field_151578_c, MapColor.field_151655_K, SoundType.field_185849_b, 1);
        this.func_149711_c(4.0f);
        this.func_149752_b(10.0f);
        this.func_149715_a(0.6f);
    }

    @Override
    public float getSpreadChance(World world, BlockPos pos) {
        float chance = (float)ModConfig.Features.NETHER_GROWTH_SPREAD;
        return BlockHelper.hasStabilizingBlock((IBlockAccess)world, pos, EnumFacing.values()) ? chance * 2.0f : chance;
    }

    @Override
    public IBlockState getSpreadBlock(World world, BlockPos source_pos, BlockPos spread_pos) {
        return this.func_176223_P();
    }

    @Override
    public boolean canSpreadTo(World world, BlockPos source_pos, BlockPos spread_pos) {
        return PrimalAPI.Predicates.SPREAD_NETHER_GROWTH.apply((Object)world.func_180495_p(spread_pos));
    }

    @Override
    public void onSpread(World world, BlockPos source_pos, BlockPos spread_pos) {
        FXHelper.fxOoze(world, spread_pos, 1.0f);
    }

    @Override
    public boolean shouldSchedule(World world, BlockPos pos, IBlockState state) {
        return !world.field_73011_w.func_177495_o() && ModConfig.Features.NETHER_GROWTH_MODIFIER > 0.0;
    }

    @Override
    public boolean shouldScheduleOnPlacement() {
        return true;
    }

    @Override
    public int scheduledTicks(World world, BlockPos pos, IBlockState state) {
        return RANDOM.nextInt((int)Math.floor(2600.0 * Math.max(0.01, ModConfig.Features.NETHER_GROWTH_MODIFIER)), (int)Math.floor(6600.0 * Math.max(0.01, ModConfig.Features.NETHER_GROWTH_MODIFIER)));
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (world.field_72995_K) {
            return;
        }
        if (PrimalAPI.randomCheck(ModConfig.Features.NETHER_GROWTH_DECAY) && !BlockHelper.hasStabilizingBlock((IBlockAccess)world, pos, EnumFacing.values())) {
            world.func_180501_a(pos, Blocks.field_150424_aL.func_176223_P(), 2);
        } else {
            this.scheduleUpdate(world, pos, state);
        }
        this.spreadBlock(world, pos, this.getSpreadChance(world, pos));
    }

    public void func_176224_k(World world, BlockPos pos) {
        if (PrimalAPI.randomCheck(2)) {
            world.func_180501_a(pos, Blocks.field_150424_aL.func_176223_P(), 2);
            FXHelper.fxLava(world, pos);
        }
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        IBlockState neighbor = world.func_180495_p(fromPos);
        if (PrimalAPI.Predicates.COOLING_SOURCE.apply((Object)neighbor)) {
            world.func_180501_a(pos, Blocks.field_150424_aL.func_176223_P(), 2);
            FXHelper.fxLava(world, pos);
        } else {
            this.spreadBlock(world, pos, this.getSpreadChance(world, pos) * 2.0f);
        }
    }

    public void func_176208_a(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        super.func_176208_a(world, pos, state, player);
        this.spreadBlock(world, pos, this.getSpreadChance(world, pos) * 2.0f);
    }

    public void func_180658_a(World world, BlockPos pos, Entity entity, float fallDistance) {
        super.func_180658_a(world, pos, entity, fallDistance);
        PrimalAPI.logger(44, "fall: " + fallDistance);
        this.spreadBlock(world, pos, this.getSpreadChance(world, pos) * 2.0f);
    }

    public void func_176199_a(World world, BlockPos pos, Entity entity) {
        super.func_176199_a(world, pos, entity);
        if (!entity.func_70045_F() && entity instanceof EntityLivingBase && !EnchantmentHelper.func_189869_j((EntityLivingBase)((EntityLivingBase)entity))) {
            entity.func_70097_a(DamageSource.field_190095_e, 1.5f);
        }
    }

    @Override
    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        if (!PlayerHelper.isNetherEntity(entity)) {
            entity.field_70159_w *= 0.4;
            entity.field_70179_y *= 0.4;
        }
    }

    @Override
    public boolean canCreatureSpawn(IBlockState state, IBlockAccess world, BlockPos pos, EntityLiving.SpawnPlacementType type) {
        return false;
    }

    @Override
    public boolean isFlammable(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return false;
    }

    @Override
    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return 0;
    }

    @Override
    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return 60;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return this.canConnectTo(source, pos.func_177984_a()) ? field_185505_j : PrimalAPI.Bounds.AABB_FARMLAND;
    }

    @Override
    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entity, boolean isActualState) {
        if (entity instanceof EntityLivingBase) {
            NetherGrowth.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)PrimalAPI.Bounds.AABB_FARMLAND);
        } else {
            NetherGrowth.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)field_185505_j);
        }
    }

    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing face) {
        return face == EnumFacing.UP && (Boolean)this.func_176221_a(state, world, pos).func_177229_b((IProperty)STACKED) == false ? BlockFaceShape.UNDEFINED : BlockFaceShape.SOLID;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        switch (side) {
            case UP: {
                return !this.canConnectTo(world, pos.func_177984_a());
            }
            case DOWN: 
            case NORTH: 
            case SOUTH: 
            case WEST: 
            case EAST: {
                IBlockState neighbor_state = world.func_180495_p(pos.func_177972_a(side));
                Block block = neighbor_state.func_177230_c();
                return !neighbor_state.func_185914_p() && (!(block instanceof IStackedLand) || this.canConnectTo(world, pos.func_177984_a()) && !this.canConnectTo(world, pos.func_177972_a(side).func_177984_a()));
            }
        }
        return super.func_176225_a(state, world, pos, side);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World world, BlockPos pos, Random rand) {
        if (world.func_180495_p(pos.func_177984_a()).func_177230_c() != this) {
            FXHelper.smokeParticlesWeather(world, pos, 3, 3, 0.92f, 0.5);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(IBlockState state, World world, RayTraceResult target, ParticleManager manager) {
        BlockPos pos = target.func_178782_a();
        if (PrimalAPI.randomCheck(3)) {
            FXHelper.smokeParticles(world, pos, 4, 0, 0.9);
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(World world, BlockPos pos, ParticleManager manager) {
        for (int i = 0; i <= 8; ++i) {
            world.func_175688_a(EnumParticleTypes.SMOKE_LARGE, (double)pos.func_177958_n() + 0.8, (double)pos.func_177956_o() + 0.8, (double)pos.func_177952_p() + 0.8, (Math.random() - 0.5) / 10.0, (Math.random() - 0.5) / 10.0, (Math.random() - 0.5) / 10.0, new int[0]);
            world.func_175688_a(EnumParticleTypes.FLAME, (double)pos.func_177958_n() + 0.8, (double)pos.func_177956_o() + 0.8, (double)pos.func_177952_p() + 0.8, (Math.random() - 0.5) / 10.0, (Math.random() - 0.5) / 10.0, (Math.random() - 0.5) / 10.0, new int[0]);
        }
        return true;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{STACKED});
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return state.func_177226_a((IProperty)STACKED, (Comparable)Boolean.valueOf(this.canConnectTo(world, pos.func_177984_a())));
    }
}

