/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.blocks.redstone;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.IAnimals;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import nmd.primal.core.common.blocks.redstone.AbstractTrigger;

public class PressurePlate
extends AbstractTrigger {
    private static final AxisAlignedBB PRESSED_AABB = new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 0.03125, 0.9375);
    private static final AxisAlignedBB UNPRESSED_AABB = new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 0.0625, 0.9375);
    private static final AxisAlignedBB PRESSURE_AABB = new AxisAlignedBB(0.125, 0.0, 0.125, 0.875, 0.25, 0.875);

    public PressurePlate() {
        super(Material.field_151594_q);
        this.func_149713_g(0);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Override
    public boolean func_176205_b(IBlockAccess worldIn, BlockPos pos) {
        return true;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        boolean flag = this.getRedstoneStrength(state) > 0;
        return flag ? PRESSED_AABB : UNPRESSED_AABB;
    }

    @Override
    protected int getRedstoneStrength(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)POWERED) != false ? 15 : 0;
    }

    @Override
    protected IBlockState setRedstoneStrength(IBlockState state, int strength) {
        return state.func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(strength > 0));
    }

    @Override
    protected int computeRedstoneStrength(World world, BlockPos pos) {
        List list;
        AxisAlignedBB axisalignedbb = PRESSURE_AABB.func_186670_a(pos);
        switch (this.sensitivity) {
            case EVERYTHING: {
                list = world.func_72839_b((Entity)null, axisalignedbb);
                break;
            }
            case PLAYERS: {
                list = world.func_72872_a(EntityPlayer.class, axisalignedbb);
                break;
            }
            case MONSTERS: 
            case ANIMALS: 
            case CHILD: {
                list = world.func_72872_a(EntityLiving.class, axisalignedbb);
                break;
            }
            default: {
                return 0;
            }
        }
        if (!list.isEmpty()) {
            for (Entity entity : list) {
                if (entity.func_145773_az()) continue;
                switch (this.sensitivity) {
                    case MONSTERS: {
                        return entity instanceof IMob ? 15 : 0;
                    }
                    case ANIMALS: {
                        return entity instanceof IAnimals ? 15 : 0;
                    }
                    case CHILD: {
                        return ((EntityLiving)entity).func_70631_g_() ? 15 : 0;
                    }
                }
                return 15;
            }
        }
        return 0;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        return state.func_177229_b((IProperty)TYPE) == EnumType.SOUL_GLASS ? BlockRenderLayer.TRANSLUCENT == layer : this.func_180664_k() == layer;
    }

    public SoundType getSoundType(IBlockState state, World world, BlockPos pos, @Nullable Entity entity) {
        return this.func_185467_w();
    }

    @Override
    protected void playClickOnSound(World world, BlockPos color) {
        if (this.field_149764_J == Material.field_151575_d) {
            world.func_184133_a((EntityPlayer)null, color, SoundEvents.field_187895_gX, SoundCategory.BLOCKS, 0.3f, 0.8f);
        } else if (this.field_149764_J == Material.field_151592_s) {
            world.func_184133_a((EntityPlayer)null, color, SoundEvents.field_187901_ga, SoundCategory.BLOCKS, 0.3f, 0.6f);
        } else {
            world.func_184133_a((EntityPlayer)null, color, SoundEvents.field_187901_ga, SoundCategory.BLOCKS, 0.3f, 0.6f);
        }
    }

    @Override
    protected void playClickOffSound(World world, BlockPos pos) {
        if (this.field_149764_J == Material.field_151575_d) {
            world.func_184133_a((EntityPlayer)null, pos, SoundEvents.field_187893_gW, SoundCategory.BLOCKS, 0.3f, 0.7f);
        } else if (this.field_149764_J == Material.field_151592_s) {
            world.func_184133_a((EntityPlayer)null, pos, SoundEvents.field_187901_ga, SoundCategory.BLOCKS, 0.3f, 0.7f);
        } else {
            world.func_184133_a((EntityPlayer)null, pos, SoundEvents.field_187847_fZ, SoundCategory.BLOCKS, 0.3f, 0.5f);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        for (EnumType blocks$enumtype : EnumType.values()) {
            list.add((Object)new ItemStack((Block)this, 1, blocks$enumtype.getMetadata()));
        }
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing face, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a((IProperty)TYPE, (Comparable)((Object)EnumType.byMetadata(placer.func_184586_b(hand).func_77952_i())));
    }

    public int func_180651_a(IBlockState state) {
        return ((EnumType)((Object)state.func_177229_b((IProperty)TYPE))).getMetadata();
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{POWERED, TYPE});
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(meta == 1));
    }

    @Override
    public int func_176201_c(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)POWERED) != false ? 1 : 0;
    }

    public static enum EnumType implements IStringSerializable
    {
        IRONWOOD(0, "ironwood", Material.field_151575_d),
        SOUL_GLASS(1, "soul_glass", Material.field_151592_s);

        private static final EnumType[] META_LOOKUP;
        private final int meta;
        private final String name;
        private final Material material;

        private EnumType(int meta, String name, Material material) {
            this.meta = meta;
            this.name = name;
            this.material = material;
        }

        public String toString() {
            return this.name;
        }

        public String func_176610_l() {
            return this.name;
        }

        public Material getMaterial() {
            return this.material;
        }

        public int getMetadata() {
            return this.meta;
        }

        public static EnumType byMetadata(int meta) {
            if (meta < 0 || meta >= META_LOOKUP.length) {
                meta = 0;
            }
            return META_LOOKUP[meta];
        }

        static {
            META_LOOKUP = new EnumType[EnumType.values().length];
            EnumType[] enumTypeArray = EnumType.values();
            int n = enumTypeArray.length;
            for (int i = 0; i < n; ++i) {
                EnumType blocks$enumtype;
                EnumType.META_LOOKUP[blocks$enumtype.getMetadata()] = blocks$enumtype = enumTypeArray[i];
            }
        }
    }

    public static enum Sensitivity {
        EVERYTHING,
        MONSTERS,
        ANIMALS,
        CHILD,
        PLAYERS;

    }
}

