/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.blocks.redstone;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFence;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import nmd.primal.core.common.blocks.AbstractContainer;
import nmd.primal.core.common.blocks.redstone.PressurePlate;
import nmd.primal.core.common.tiles.machines.TilePressurePlate;

public abstract class AbstractTrigger
extends AbstractContainer<TilePressurePlate> {
    public static final PropertyEnum<PressurePlate.EnumType> TYPE = PropertyEnum.func_177709_a((String)"type", PressurePlate.EnumType.class);
    public static final PropertyBool POWERED = PropertyBool.func_177716_a((String)"powered");
    public final PressurePlate.Sensitivity sensitivity;

    protected AbstractTrigger(Material materialIn) {
        this(materialIn, materialIn.func_151565_r());
    }

    protected AbstractTrigger(Material materialIn, MapColor mapColorIn) {
        super(materialIn, mapColorIn);
        this.func_149647_a(CreativeTabs.field_78028_d);
        this.func_149675_a(true);
        this.func_149713_g(0);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false)));
        this.sensitivity = PressurePlate.Sensitivity.PLAYERS;
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TilePressurePlate();
    }

    public EnumPushReaction func_149656_h(IBlockState state) {
        return EnumPushReaction.DESTROY;
    }

    @Override
    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        if (this.getRedstoneStrength(state) > 0) {
            this.updateNeighbors(worldIn, pos);
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return this.canBePlacedOn(worldIn, pos.func_177977_b());
    }

    private boolean canBePlacedOn(World worldIn, BlockPos pos) {
        return worldIn.func_180495_p(pos).func_185896_q() || worldIn.func_180495_p(pos).func_177230_c() instanceof BlockFence;
    }

    public boolean func_181623_g() {
        return true;
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return field_185506_k;
    }

    public BlockFaceShape func_193383_a(IBlockAccess p_193383_1_, IBlockState p_193383_2_, BlockPos p_193383_3_, EnumFacing p_193383_4_) {
        return BlockFaceShape.UNDEFINED;
    }

    @Override
    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        int i;
        if (!worldIn.field_72995_K && (i = this.getRedstoneStrength(state)) == 0) {
            this.updateState(worldIn, pos, state, i);
        }
    }

    public int func_149738_a(World worldIn) {
        return 20;
    }

    public void func_180645_a(World worldIn, BlockPos pos, IBlockState state, Random random) {
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        int i;
        if (!worldIn.field_72995_K && (i = this.getRedstoneStrength(state)) > 0) {
            this.updateState(worldIn, pos, state, i);
        }
    }

    protected void updateState(World worldIn, BlockPos pos, IBlockState state, int oldRedstoneStrength) {
        boolean flag1;
        int i = this.computeRedstoneStrength(worldIn, pos);
        boolean flag = oldRedstoneStrength > 0;
        boolean bl = flag1 = i > 0;
        if (oldRedstoneStrength != i) {
            state = this.setRedstoneStrength(state, i);
            worldIn.func_180501_a(pos, state, 2);
            this.updateNeighbors(worldIn, pos);
            worldIn.func_175704_b(pos, pos);
        }
        if (!flag1 && flag) {
            this.playClickOffSound(worldIn, pos);
        } else if (flag1 && !flag) {
            this.playClickOnSound(worldIn, pos);
        }
        if (flag1) {
            worldIn.func_175684_a(new BlockPos((Vec3i)pos), (Block)this, this.func_149738_a(worldIn));
        }
    }

    protected void updateNeighbors(World worldIn, BlockPos pos) {
        worldIn.func_175685_c(pos, (Block)this, false);
        worldIn.func_175685_c(pos.func_177977_b(), (Block)this, false);
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (!this.canBePlacedOn(worldIn, pos.func_177977_b())) {
            this.func_176226_b(worldIn, pos, state, 0);
            worldIn.func_175698_g(pos);
        }
    }

    public boolean func_149744_f(IBlockState state) {
        return true;
    }

    public int func_180656_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return this.getRedstoneStrength(blockState);
    }

    public int func_176211_b(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return side == EnumFacing.UP ? this.getRedstoneStrength(blockState) : 0;
    }

    protected abstract int computeRedstoneStrength(World var1, BlockPos var2);

    protected abstract int getRedstoneStrength(IBlockState var1);

    protected abstract IBlockState setRedstoneStrength(IBlockState var1, int var2);

    protected abstract void playClickOnSound(World var1, BlockPos var2);

    protected abstract void playClickOffSound(World var1, BlockPos var2);

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{POWERED, TYPE});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(meta == 1));
    }

    public int func_176201_c(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)POWERED) != false ? 1 : 0;
    }

    public static enum EnumType implements IStringSerializable
    {
        IRONWOOD(0, "ironwood", Material.field_151575_d),
        SOUL_GLASS(1, "soul_glass", Material.field_151592_s);

        private static final EnumType[] META_LOOKUP;
        private final int meta;
        private final String name;
        private final Material material;

        private EnumType(int meta, String name, Material material) {
            this.meta = meta;
            this.name = name;
            this.material = material;
        }

        public String toString() {
            return this.name;
        }

        public String func_176610_l() {
            return this.name;
        }

        public Material getMaterial() {
            return this.material;
        }

        public int getMetadata() {
            return this.meta;
        }

        public static EnumType byMetadata(int meta) {
            if (meta < 0 || meta >= META_LOOKUP.length) {
                meta = 0;
            }
            return META_LOOKUP[meta];
        }

        static {
            META_LOOKUP = new EnumType[EnumType.values().length];
            EnumType[] enumTypeArray = EnumType.values();
            int n = enumTypeArray.length;
            for (int i = 0; i < n; ++i) {
                EnumType blocks$enumtype;
                EnumType.META_LOOKUP[blocks$enumtype.getMetadata()] = blocks$enumtype = enumTypeArray[i];
            }
        }
    }
}

