/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.blocks.plants.wood;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.event.terraingen.TerrainGen;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import nmd.primal.core.api.PrimalAPI;
import nmd.primal.core.api.interfaces.plants.IPrimalPlants;
import nmd.primal.core.api.interfaces.types.ITypeSaplings;
import nmd.primal.core.common.PrimalCore;
import nmd.primal.core.common.blocks.plants.AbstractPlant;
import nmd.primal.core.common.blocks.plants.wood.CoryphaStalk;
import nmd.primal.core.common.world.feature.plants.GenCoryphaSapling;
import nmd.primal.core.common.world.feature.plants.GenTreeIronwood;
import nmd.primal.core.common.world.feature.plants.GenTreeYew;

public class TreeSapling
extends AbstractPlant
implements ITypeSaplings,
IGrowable,
IPlantable {
    public static final PropertyInteger STAGE = PropertyInteger.func_177719_a((String)"stage", (int)0, (int)1);

    public TreeSapling() {
        this.func_149675_a(true);
        this.func_149672_a(SoundType.field_185850_c);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)TYPE, (Comparable)((Object)ITypeSaplings.EnumType.IRONWOOD)).func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(0)));
    }

    @Override
    public IPrimalPlants.EnumType getType(IBlockState state) {
        return state.func_177229_b((IProperty)TYPE) == ITypeSaplings.EnumType.CORYPHA ? IPrimalPlants.EnumType.NETHER : IPrimalPlants.EnumType.NORMAL;
    }

    @Override
    public boolean canBloom(World world, BlockPos pos, IBlockState state) {
        return false;
    }

    @Override
    public float getGrowChance(World world, BlockPos pos, IBlockState state) {
        return 0.0f;
    }

    @Override
    public float getBloomChance(World world, BlockPos pos, IBlockState state) {
        return 0.0f;
    }

    @Override
    public boolean isMature(IBlockState state) {
        return true;
    }

    public void grow(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if ((Integer)state.func_177229_b((IProperty)STAGE) == 0) {
            worldIn.func_180501_a(pos, state.func_177231_a((IProperty)STAGE), 4);
        } else {
            this.generateTree(worldIn, pos, state, rand);
        }
    }

    public void generateTree(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        Object worldgenerator;
        if (!TerrainGen.saplingGrowTree((World)worldIn, (Random)rand, (BlockPos)pos)) {
            return;
        }
        int i = 0;
        int j = 0;
        boolean flag = false;
        switch ((ITypeSaplings.EnumType)((Object)state.func_177229_b((IProperty)TYPE))) {
            case IRONWOOD: {
                worldgenerator = new GenTreeIronwood(true);
                break;
            }
            case YEW: {
                worldgenerator = new GenTreeYew(true);
                break;
            }
            default: {
                worldgenerator = new GenCoryphaSapling((CoryphaStalk)PrimalAPI.Blocks.CORYPHA_STALK, 30, true);
            }
        }
        IBlockState iblockstate2 = Blocks.field_150350_a.func_176223_P();
        if (flag) {
            worldIn.func_180501_a(pos.func_177982_a(i, 0, j), iblockstate2, 4);
            worldIn.func_180501_a(pos.func_177982_a(i + 1, 0, j), iblockstate2, 4);
            worldIn.func_180501_a(pos.func_177982_a(i, 0, j + 1), iblockstate2, 4);
            worldIn.func_180501_a(pos.func_177982_a(i + 1, 0, j + 1), iblockstate2, 4);
        } else {
            worldIn.func_180501_a(pos, iblockstate2, 4);
        }
        if (!worldgenerator.func_180709_b(worldIn, rand, pos.func_177982_a(i, 0, j))) {
            if (flag) {
                worldIn.func_180501_a(pos.func_177982_a(i, 0, j), state, 4);
                worldIn.func_180501_a(pos.func_177982_a(i + 1, 0, j), state, 4);
                worldIn.func_180501_a(pos.func_177982_a(i, 0, j + 1), state, 4);
                worldIn.func_180501_a(pos.func_177982_a(i + 1, 0, j + 1), state, 4);
            } else {
                worldIn.func_180501_a(pos, state, 4);
            }
        }
    }

    private boolean isTwoByTwoOfType(World worldIn, BlockPos pos, int p_181624_3_, int p_181624_4_, ITypeSaplings.EnumType type) {
        return this.isTypeAt(worldIn, pos.func_177982_a(p_181624_3_, 0, p_181624_4_), type) && this.isTypeAt(worldIn, pos.func_177982_a(p_181624_3_ + 1, 0, p_181624_4_), type) && this.isTypeAt(worldIn, pos.func_177982_a(p_181624_3_, 0, p_181624_4_ + 1), type) && this.isTypeAt(worldIn, pos.func_177982_a(p_181624_3_ + 1, 0, p_181624_4_ + 1), type);
    }

    public boolean isTypeAt(World worldIn, BlockPos pos, ITypeSaplings.EnumType type) {
        IBlockState iblockstate = worldIn.func_180495_p(pos);
        return iblockstate.func_177230_c() == this && iblockstate.func_177229_b((IProperty)TYPE) == type;
    }

    @Override
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return PrimalAPI.Bounds.AABB_SAPLING;
    }

    @Override
    public boolean canSustainPlant(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing direction, IPlantable plantable) {
        IBlockState plant_state = plantable.getPlant(world, pos.func_177972_a(direction));
        Block plant = plant_state.func_177230_c();
        PrimalAPI.logger(2, "sapling", "1: " + plant);
        return plant == this && world.isSideSolid(pos, EnumFacing.UP, false);
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (!world.field_72995_K) {
            super.func_180650_b(world, pos, state, rand);
            if (rand.nextInt(7) == 0) {
                this.grow(world, pos, state, PrimalCore.RANDOM);
            }
        }
    }

    public boolean func_176473_a(World world, BlockPos pos, IBlockState state, boolean isClient) {
        return true;
    }

    public boolean func_180670_a(World world, Random rand, BlockPos pos, IBlockState state) {
        return (double)world.field_73012_v.nextFloat() < 0.45;
    }

    public void func_176474_b(World world, Random rand, BlockPos pos, IBlockState state) {
        this.grow(world, pos, state, rand);
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing face, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a((IProperty)TYPE, (Comparable)((Object)ITypeSaplings.EnumType.byMetadata(placer.func_184586_b(hand).func_77952_i()))).func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(0));
    }

    public int func_180651_a(IBlockState state) {
        return ((ITypeSaplings.EnumType)((Object)state.func_177229_b((IProperty)TYPE))).getMetadata();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        this.getTypes(new ItemStack((Block)this).func_77973_b(), tab, list);
    }

    @Override
    public boolean isFlammable(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return this.getTypeFlammability(world, pos, world.func_180495_p(pos)) > 0;
    }

    @Override
    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return this.getTypeFlammability(world, pos, world.func_180495_p(pos));
    }

    @Override
    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return this.getTypeEncouragement(world, pos, world.func_180495_p(pos));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{TYPE, STAGE});
    }

    public int func_176201_c(IBlockState state) {
        int i = ((ITypeSaplings.EnumType)((Object)state.func_177229_b((IProperty)TYPE))).getMetadata();
        if ((Integer)state.func_177229_b((IProperty)STAGE) > 0) {
            i |= 8;
        }
        return i;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)TYPE, (Comparable)((Object)ITypeSaplings.EnumType.byMetadata(meta & 7))).func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(this.getStageMeta(meta)));
    }

    private int getStageMeta(int meta) {
        return meta > 7 ? 1 : 0;
    }
}

