/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.blocks.plants.wood;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLog;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import nmd.primal.core.api.interfaces.crafting.IDictionaryName;
import nmd.primal.core.api.interfaces.types.ITypeLogs;
import nmd.primal.core.common.helper.RegistryHelper;

public class TreeLog
extends BlockLog
implements ITypeLogs,
IDictionaryName<Block> {
    private boolean flammable;
    private String[] dictionary_names;

    public TreeLog(boolean flammable) {
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)field_176299_a, (Comparable)BlockLog.EnumAxis.Y));
        this.setHarvestLevel("axe", 0);
        this.flammable = flammable;
    }

    public TreeLog() {
        this(true);
    }

    @Override
    public Block setDictionaryNames(String ... strings) {
        this.dictionary_names = strings;
        return this;
    }

    @Override
    public String[] getDictionaryNames() {
        return this.dictionary_names;
    }

    @Override
    public void registerDictionaryNames() {
        for (ITypeLogs.EnumType blocks$enumtype : ITypeLogs.EnumType.values()) {
            for (String name : blocks$enumtype.getOreNames()) {
                RegistryHelper.registerDictionaryNames(new ItemStack((Block)this, 1, blocks$enumtype.getMetadata()), name);
            }
        }
    }

    public boolean canCreatureSpawn(IBlockState state, IBlockAccess world, BlockPos pos, EntityLiving.SpawnPlacementType type) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        this.getTypes(new ItemStack((Block)this).func_77973_b(), tab, list);
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing face, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a((IProperty)TYPE, (Comparable)((Object)ITypeLogs.EnumType.byMetadata(placer.func_184586_b(hand).func_77952_i()))).func_177226_a((IProperty)field_176299_a, (Comparable)BlockLog.EnumAxis.func_176870_a((EnumFacing.Axis)face.func_176740_k()));
    }

    public int func_180651_a(IBlockState state) {
        return ((ITypeLogs.EnumType)((Object)state.func_177229_b((IProperty)TYPE))).getMetadata();
    }

    public float func_176195_g(IBlockState state, World world, BlockPos pos) {
        return ((ITypeLogs.EnumType)((Object)state.func_177229_b((IProperty)TYPE))).getHardness();
    }

    public float getExplosionResistance(World world, BlockPos pos, @Nullable Entity exploder, Explosion explosion) {
        IBlockState state = world.func_180495_p(pos);
        return ((ITypeLogs.EnumType)((Object)state.func_177229_b((IProperty)TYPE))).getResistance();
    }

    public boolean isFlammable(IBlockAccess world, BlockPos pos, EnumFacing face) {
        IBlockState state = world.func_180495_p(pos);
        return ((ITypeLogs.EnumType)((Object)state.func_177229_b((IProperty)TYPE))).getFlammability() > 0;
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        IBlockState state = world.func_180495_p(pos);
        return ((ITypeLogs.EnumType)((Object)state.func_177229_b((IProperty)TYPE))).getFlammability();
    }

    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
        IBlockState state = world.func_180495_p(pos);
        return ((ITypeLogs.EnumType)((Object)state.func_177229_b((IProperty)TYPE))).getEncouragement();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{TYPE, field_176299_a});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)TYPE, (Comparable)((Object)this.getType(meta))).func_177226_a((IProperty)field_176299_a, (Comparable)this.getAxis(meta));
    }

    public int func_176201_c(IBlockState state) {
        int i = 0;
        i |= ((ITypeLogs.EnumType)((Object)state.func_177229_b((IProperty)TYPE))).getMetadata();
        switch ((BlockLog.EnumAxis)state.func_177229_b((IProperty)field_176299_a)) {
            case X: {
                i |= 4;
                break;
            }
            case Z: {
                i |= 8;
                break;
            }
            case NONE: {
                i |= 0xC;
            }
        }
        return i;
    }

    public ITypeLogs.EnumType getType(int meta) {
        return ITypeLogs.EnumType.byMetadata(meta & 3);
    }

    public BlockLog.EnumAxis getAxis(int meta) {
        return meta < 5 ? BlockLog.EnumAxis.Y : (meta < 9 ? BlockLog.EnumAxis.X : (meta < 13 ? BlockLog.EnumAxis.Z : BlockLog.EnumAxis.NONE));
    }
}

