/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.blocks.plants.thatch;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import nmd.primal.core.api.PrimalAPI;
import nmd.primal.core.api.enums.EnumMoisture;
import nmd.primal.core.api.interfaces.IFace;
import nmd.primal.core.api.interfaces.ISchedule;
import nmd.primal.core.common.blocks.AbstractBlock;
import nmd.primal.core.common.blocks.parts.SlabFull;
import nmd.primal.core.common.entities.projectiles.TypeArrow;
import nmd.primal.core.common.helper.CommonUtils;
import nmd.primal.core.common.helper.FireHelper;
import nmd.primal.core.common.init.ModConfig;
import nmd.primal.core.common.items.projectiles.Arrow;

public class ThatchWet
extends AbstractBlock
implements IFace,
ISchedule {
    public ThatchWet() {
        super(Material.field_151577_b);
        this.func_149672_a(SoundType.field_185850_c);
        this.setHarvestLevel("axe", 1);
        this.func_149711_c(1.0f);
        this.func_149752_b(0.2f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(PrimalAPI.States.WET_DRY, (Comparable)((Object)EnumMoisture.WET)));
        this.func_149675_a(true);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable World player, List<String> tooltip, ITooltipFlag advanced) {
        tooltip.add(TextFormatting.GREEN + I18n.func_74838_a((String)"tooltip.info.primal.abstract_wet_block"));
        tooltip.add(TextFormatting.GOLD + I18n.func_74838_a((String)"tooltip.info.primal.abstract_environment"));
    }

    @Override
    public boolean shouldSchedule(World world, BlockPos pos, IBlockState state) {
        return true;
    }

    @Override
    public boolean shouldScheduleOnPlacement() {
        return true;
    }

    @Override
    public int scheduledTicks(World world, BlockPos pos, IBlockState state) {
        return RANDOM.nextInt((int)Math.floor(4500.0 * ModConfig.Features.THATCH_DRYING_MODIFIER), (int)Math.floor(6500.0 * ModConfig.Features.THATCH_DRYING_MODIFIER));
    }

    private float getDryChance(World world, BlockPos pos) {
        float chance = 0.05f;
        if (world.func_72935_r() && world.func_175678_i(pos)) {
            chance += 0.15f;
        } else if (!CommonUtils.checkForAir((IBlockAccess)world, pos)) {
            chance += 0.1f;
        }
        if (FireHelper.hasNearByHeat(world, pos, 4, 2, true)) {
            chance += 0.15f;
        }
        return chance;
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        float dry_chance;
        if (world.field_72995_K) {
            return;
        }
        boolean getting_wet = world.func_175727_C(pos.func_177984_a()) || CommonUtils.hasNearByMaterial((IBlockAccess)world, pos, 1, -1, Material.field_151586_h);
        float f = dry_chance = getting_wet ? 0.0f : this.getDryChance(world, pos);
        if (this.isWet(state)) {
            if (PrimalAPI.randomCheck(dry_chance)) {
                world.func_180501_a(pos, state.func_177226_a(PrimalAPI.States.WET_DRY, (Comparable)((Object)EnumMoisture.DRY)), 18);
            }
        } else if (getting_wet) {
            world.func_180501_a(pos, state.func_177226_a(PrimalAPI.States.WET_DRY, (Comparable)((Object)EnumMoisture.WET)), 18);
        } else if (PrimalAPI.randomCheck(dry_chance)) {
            world.func_180501_a(pos, this.getDryState(state), 18);
            return;
        }
        PrimalAPI.scheduleBlock(world, pos, state);
    }

    private IBlockState getDryState(IBlockState state) {
        return PrimalAPI.Blocks.THATCH.func_176223_P().func_177226_a((IProperty)IFace.FACING, (Comparable)this.getFacing(state)).func_177226_a(SlabFull.HALF, (Comparable)((Object)SlabFull.EnumSlab.FULL));
    }

    @Override
    public boolean canCreatureSpawn(IBlockState state, IBlockAccess world, BlockPos pos, EntityLiving.SpawnPlacementType type) {
        return false;
    }

    @Override
    public boolean isFlammable(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return !this.isWet(world.func_180495_p(pos));
    }

    @Override
    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return this.isWet(world.func_180495_p(pos)) ? 0 : 180;
    }

    @Override
    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return this.isWet(world.func_180495_p(pos)) ? 0 : 10;
    }

    @Override
    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entity) {
        if (!this.isWet(state) && PrimalAPI.randomCheck(8) && entity.func_70027_ad() && worldIn.func_175623_d(pos.func_177984_a())) {
            worldIn.func_180501_a(pos.func_177984_a(), Blocks.field_150480_ab.func_176223_P(), 2);
            if (entity instanceof TypeArrow && ((TypeArrow)entity).matchType(Arrow.Type.TORCH_WOOD, Arrow.Type.TORCH_NETHER)) {
                entity.func_70106_y();
            }
        }
    }

    public MapColor func_180659_g(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return MapColor.field_151651_C;
    }

    public void func_176216_a(World world, Entity entity) {
        if (entity.func_70093_af()) {
            super.func_176216_a(world, entity);
        } else if (entity.field_70181_x < 0.0) {
            entity.field_70181_x = -entity.field_70181_x * 0.3600000262260437;
            if (!(entity instanceof EntityLivingBase)) {
                entity.field_70181_x *= 0.75;
            }
        }
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return this.isWet(state) ? Item.func_150898_a((Block)this) : Item.func_150898_a((Block)PrimalAPI.Blocks.THATCH);
    }

    public int quantityDropped(IBlockState state, int fortune, Random random) {
        return this.isWet(state) ? 1 : 2;
    }

    public EnumPushReaction func_149656_h(IBlockState state) {
        return this.isWet(state) ? EnumPushReaction.NORMAL : EnumPushReaction.DESTROY;
    }

    @Override
    public boolean canSilkHarvest(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        return false;
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a(PrimalAPI.States.WET_DRY, (Comparable)((Object)EnumMoisture.WET)).func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO());
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{PrimalAPI.States.WET_DRY, FACING});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(PrimalAPI.States.WET_DRY, (Comparable)((Object)EnumMoisture.byMetadata(this.getDampnessFromMeta(meta)))).func_177226_a((IProperty)FACING, (Comparable)this.getHorizontalFacingFromIndex(this.getFacingIndexFromMeta(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return this.getMetaFromDampness(state) + this.getHorizontalIndexFromState(state);
    }

    @Override
    public int getFacingIndexFromMeta(int meta) {
        int modifier = meta < 4 ? 0 : (meta < 8 ? 4 : 8);
        return meta - modifier;
    }

    public int getDampnessFromMeta(int meta) {
        return meta > 3 ? 1 : 0;
    }

    public int getMetaFromDampness(IBlockState state) {
        return this.isWet(state) ? 4 : 0;
    }

    public boolean isWet(IBlockState state) {
        return state.func_177229_b(PrimalAPI.States.WET_DRY) == EnumMoisture.WET;
    }
}

