/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.blocks.plants.invasive;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.IShearable;
import nmd.primal.core.api.PrimalAPI;
import nmd.primal.core.api.interfaces.IInflictedDamage;
import nmd.primal.core.api.interfaces.plants.IHarvest;
import nmd.primal.core.api.interfaces.plants.IPerennial;
import nmd.primal.core.api.interfaces.plants.IPrimalPlants;
import nmd.primal.core.common.blocks.plants.AbstractPlantInvasive;
import nmd.primal.core.common.helper.CommonUtils;
import nmd.primal.core.common.helper.DamageHelper;
import nmd.primal.core.common.init.ModConfig;

public class Aconite
extends AbstractPlantInvasive
implements IShearable,
IHarvest,
IPerennial,
IInflictedDamage {
    public Aconite() {
        this.func_149675_a(true);
    }

    @Override
    public boolean shouldDamage(World world, BlockPos pos) {
        return true;
    }

    @Override
    public DamageSource getSource(World world, BlockPos pos) {
        return DamageHelper.ACONITE;
    }

    @Override
    public float getDamage(World world, BlockPos pos) {
        return 0.5f;
    }

    @Override
    public IPrimalPlants.EnumType getType(IBlockState state) {
        return IPrimalPlants.EnumType.NORMAL;
    }

    @Override
    public ItemStack getStalk(IBlockState state) {
        return new ItemStack(PrimalAPI.Items.ACONITE_SPRIG);
    }

    @Override
    public ItemStack getSeed(IBlockState state) {
        return new ItemStack(PrimalAPI.Items.ACONITE_ROOT);
    }

    @Override
    public ItemStack getCrop(IBlockState state) {
        return new ItemStack(PrimalAPI.Items.ACONITE_PETAL);
    }

    @Override
    public float getGrowChance(World world, BlockPos pos, IBlockState state) {
        return 1.0f;
    }

    @Override
    public float getBloomChance(World world, BlockPos pos, IBlockState state) {
        return 0.35f;
    }

    @Override
    public boolean canBloom(World world, BlockPos pos, IBlockState state) {
        return CommonUtils.isValueMatch(this.getAge(state), 4);
    }

    @Override
    public boolean isBlooming(IBlockState state) {
        return state.func_177230_c() instanceof Aconite ? (Boolean)state.func_177229_b((IProperty)PLANT_BLOOM) : true;
    }

    @Override
    public boolean isMature(IBlockState state) {
        return CommonUtils.isValueMatch(this.getAge(state), 4);
    }

    @Override
    public boolean shouldSpread(World world, BlockPos pos, IBlockState state) {
        PrimalAPI.logger(8, "aconite", "shouldSpread: " + this.isBlooming(state));
        return this.isBlooming(state) && world.func_130001_d() == 1.0f && !world.func_72935_r();
    }

    @Override
    public boolean canSpreadTo(World world, BlockPos source_pos, BlockPos spread_pos) {
        PrimalAPI.logger(8, "aconite", "canSpreadTo: " + !world.func_175678_i(spread_pos) + ":" + !world.func_72935_r() + ":" + (world.func_130001_d() == 1.0f));
        return !world.func_175678_i(spread_pos.func_177984_a());
    }

    @Override
    public float getSpreadChance(World word, BlockPos source_pos, IBlockState source_state) {
        return 0.15f;
    }

    @Override
    public int getSpreadChecks(World word, BlockPos source_pos, IBlockState source_state) {
        return 3;
    }

    @Override
    public int getSpreadRange(World word, BlockPos source_pos, IBlockState source_state) {
        return 3;
    }

    @Override
    public IBlockState getNewPlant() {
        return this.func_176223_P();
    }

    @Override
    public boolean canNewGrow(World world, BlockPos pos, IBlockState state) {
        return true;
    }

    @Override
    public int harvestAmount() {
        return RANDOM.nextInt(1, 3);
    }

    @Override
    public boolean canHarvest(IBlockState state) {
        return this.isBlooming(state);
    }

    @Override
    public void updatePlant(World world, BlockPos pos, IBlockState state, Random rand, int age) {
        PrimalAPI.logger(80, "aconite", "updating");
        if (world.func_175678_i(pos)) {
            return;
        }
        switch (age) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                PrimalAPI.logger(80, "aconite", "growing");
                if (!PrimalAPI.randomCheck(ModConfig.Plants.PLANT_BASE_GROWTH_CHANCE)) break;
                this.growPlant(world, pos, state, RANDOM, 1, 0, false);
                break;
            }
            case 4: {
                PrimalAPI.logger(80, "aconite", "blooming");
                if (this.isBlooming(state)) {
                    if (!world.func_72935_r()) break;
                    PrimalAPI.logger(80, "aconite", "de-blooming");
                    world.func_180501_a(pos, state.func_177231_a((IProperty)PLANT_BLOOM), 2);
                    break;
                }
                if (world.func_72935_r() || world.getCurrentMoonPhaseFactorBody() != 1.0f || !PrimalAPI.randomCheck(this.getBloomChance(world, pos, state))) break;
                PrimalAPI.logger(80, "aconite", "blooming");
                world.func_180501_a(pos, state.func_177231_a((IProperty)PLANT_BLOOM), 2);
            }
        }
    }

    @Override
    public PathNodeType getAiPathNodeType(IBlockState state, IBlockAccess world, BlockPos pos) {
        return PathNodeType.DANGER_OTHER;
    }

    @Override
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return null;
    }

    @Override
    public int func_149745_a(Random random) {
        return 0;
    }

    public void func_180653_a(World world, BlockPos pos, IBlockState state, float chance, int fortune) {
        if (!world.field_72995_K && !world.restoringBlockSnapshots && this.getAge(state) == 4 && this.isBlooming(state)) {
            Aconite.func_180635_a((World)world, (BlockPos)pos, (ItemStack)this.getCrop(state));
        }
    }

    public boolean isShearable(ItemStack item, IBlockAccess world, BlockPos pos) {
        return true;
    }

    public List<ItemStack> onSheared(ItemStack item, IBlockAccess world, BlockPos pos, int fortune) {
        IBlockState state = world.func_180495_p(pos);
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        if (this.isMature(state)) {
            drops.add(this.getStalk(state));
            if (this.isBlooming(state)) {
                drops.add(this.getCrop(state));
            }
        }
        return drops;
    }

    @Override
    public boolean canBlockStay(World world, BlockPos pos, IBlockState state) {
        IBlockState soil = this.getSoil((IBlockAccess)world, pos);
        if (state.func_177230_c() == this && this.getAge(state) < 4) {
            return this.canSustainPlant(soil, (IBlockAccess)world, pos.func_177977_b(), EnumFacing.UP, this);
        }
        return this.canSustainPlant(soil, (IBlockAccess)world, pos.func_177977_b(), EnumFacing.UP, this);
    }

    @Override
    public boolean canSustainPlant(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing direction, IPlantable plantable) {
        IBlockState plant_state = plantable.getPlant(world, pos.func_177972_a(direction));
        Block plant = plant_state.func_177230_c();
        if (plant == this) {
            return this.isValidSoil(world, pos);
        }
        return super.canSustainPlant(state, world, pos, direction, plantable);
    }

    @Override
    public boolean isValidSoil(IBlockAccess world, BlockPos pos) {
        return PrimalAPI.Predicates.SOIL_SURFACE_COMMON.apply((Object)world.func_180495_p(pos));
    }

    @Override
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return PrimalAPI.Bounds.AABB_BUSH;
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing face, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a((IProperty)IPrimalPlants.PLANT_AGE, (Comparable)Integer.valueOf(4)).func_177226_a((IProperty)IPrimalPlants.PLANT_BLOOM, (Comparable)Boolean.valueOf(true));
    }
}

