/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.blocks.plants.crops;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import nmd.primal.core.api.PrimalAPI;
import nmd.primal.core.api.interfaces.ISchedule;
import nmd.primal.core.api.interfaces.plants.IHarvest;
import nmd.primal.core.api.interfaces.plants.IPrimalPlants;
import nmd.primal.core.common.blocks.plants.AbstractPlantGrowing;
import nmd.primal.core.common.helper.CommonUtils;
import nmd.primal.core.common.helper.FXHelper;
import nmd.primal.core.common.init.ModConfig;

public class ValusOmniferum
extends AbstractPlantGrowing
implements IHarvest,
ISchedule {
    @Override
    public boolean shouldSchedule(World world, BlockPos pos, IBlockState state) {
        return !this.isBlooming(state) && !CommonUtils.isValueMatch(this.getAge(state), 4);
    }

    @Override
    public boolean shouldScheduleOnPlacement() {
        return true;
    }

    @Override
    public int scheduledTicks(World world, BlockPos pos, IBlockState state) {
        return RANDOM.nextInt(ModConfig.Plants.PLANT_BASE_TICK_RATE / 2, ModConfig.Plants.PLANT_BASE_TICK_RATE);
    }

    @Override
    public IPrimalPlants.EnumType getType(IBlockState state) {
        return IPrimalPlants.EnumType.NETHER;
    }

    @Override
    public ItemStack getStalk(IBlockState state) {
        return new ItemStack(PrimalAPI.Items.VALUS_STALK_FRESH);
    }

    @Override
    public ItemStack getSeed(IBlockState state) {
        return new ItemStack(PrimalAPI.Items.VALUS_SEED);
    }

    @Override
    public ItemStack getCrop(IBlockState state) {
        return new ItemStack(PrimalAPI.Items.VALUS_MELON);
    }

    @Override
    public int getMaxHeight() {
        return 4;
    }

    @Override
    public boolean isMature(IBlockState state) {
        return CommonUtils.isValueMatch(this.getAge(state), 4, 6, 7);
    }

    @Override
    public void growFullPlant(World world, BlockPos pos, IBlockState state, int update_flag) {
        super.growFullPlant(world, pos, state, update_flag);
        if (this.isValidSoil((IBlockAccess)world, pos.func_177977_b())) {
            world.func_180501_a(pos, this.getAgedPlant(state, 4), update_flag);
            world.func_180501_a(pos.func_177984_a(), this.getBloomingPlant(state, 6, world.field_73012_v.nextBoolean()), update_flag);
            world.func_180501_a(pos.func_177981_b(2), this.getBloomingPlant(state, 6, world.field_73012_v.nextBoolean()), update_flag);
            world.func_180501_a(pos.func_177981_b(3), this.getBloomingPlant(state, 7, world.field_73012_v.nextBoolean()), update_flag);
        }
    }

    @Override
    public float getGrowChance(World world, BlockPos pos, IBlockState state) {
        return super.getGrowChance(world, pos, state);
    }

    @Override
    public float getBloomChance(World world, BlockPos pos, IBlockState state) {
        return 0.35f;
    }

    @Override
    public boolean canBloom(World world, BlockPos pos, IBlockState state) {
        return !this.isBlooming(state) && CommonUtils.isValueMatch(this.getAge(state), 6, 7);
    }

    @Override
    public void updatePlant(World world, BlockPos pos, IBlockState state, Random rand, int age) {
        PrimalAPI.logger(2, "valus update");
        if (this.isMature(state)) {
            if (this.canBloom(world, pos, state) && PrimalAPI.randomCheck(this.getBloomChance(world, pos, state))) {
                world.func_180501_a(pos, state.func_177231_a((IProperty)PLANT_BLOOM), 2);
            }
        } else {
            IBlockState aged_current = this.increaseAge(state, 1);
            IBlockState growth_stage = this.getAgedPlant(state, 5);
            IBlockState end_stage = this.getAgedPlant(state, 7);
            switch (age) {
                case 0: 
                case 1: 
                case 2: {
                    PrimalAPI.placeScheduledBlock(world, pos, aged_current, 2);
                    break;
                }
                case 3: {
                    world.func_180501_a(pos, aged_current, 2);
                    PrimalAPI.placeScheduledBlock(world, pos.func_177984_a(), growth_stage, 2);
                    break;
                }
                case 5: {
                    if (this.getCurrentHeight(world, pos) < this.getMaxHeight()) {
                        PrimalAPI.placeScheduledBlock(world, pos, aged_current, 2);
                        PrimalAPI.placeScheduledBlock(world, pos.func_177984_a(), growth_stage, 2);
                        break;
                    }
                    PrimalAPI.placeScheduledBlock(world, pos, end_stage, 2);
                }
            }
        }
    }

    @Override
    public int harvestAmount() {
        return RANDOM.nextInt(1, 3);
    }

    @Override
    public boolean canHarvest(IBlockState state) {
        return this.isBlooming(state);
    }

    @Override
    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        int age = this.getAge(world.func_180495_p(pos));
        if (age > 3) {
            entity.field_70159_w *= 0.6;
            entity.field_70179_y *= 0.6;
        }
    }

    @Override
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return null;
    }

    @Override
    public int func_149745_a(Random random) {
        return 0;
    }

    public void func_180653_a(World world, BlockPos pos, IBlockState state, float chance, int fortune) {
        if (!world.field_72995_K && !world.restoringBlockSnapshots) {
            if (this.getAge(state) == 4) {
                ValusOmniferum.func_180635_a((World)world, (BlockPos)pos, (ItemStack)this.getStalk(state));
            }
            if (this.getAge(state) > 5) {
                ValusOmniferum.func_180635_a((World)world, (BlockPos)pos, (ItemStack)this.getStalk(state));
                if (this.isBlooming(state)) {
                    ValusOmniferum.func_180635_a((World)world, (BlockPos)pos, (ItemStack)this.getCrop(state));
                }
            }
        }
    }

    @Override
    public boolean canBlockStay(World world, BlockPos pos, IBlockState state) {
        IBlockState soil = this.getSoil((IBlockAccess)world, pos);
        if (state.func_177230_c() == this && this.getAge(state) < 4) {
            return this.canSustainPlant(soil, (IBlockAccess)world, pos.func_177977_b(), EnumFacing.UP, this);
        }
        return this.canSustainPlant(soil, (IBlockAccess)world, pos.func_177977_b(), EnumFacing.UP, this);
    }

    @Override
    public boolean canSustainPlant(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing direction, IPlantable plantable) {
        IBlockState plant_state = plantable.getPlant(world, pos.func_177972_a(direction));
        Block soil = state.func_177230_c();
        if (plantable == this) {
            int age = this.getAge(plant_state);
            if (age > 3) {
                return soil == this || this.isValidSoil(world, pos);
            }
            return PrimalAPI.Predicates.SOIL_NETHER_FARMING.apply((Object)state);
        }
        return super.canSustainPlant(state, world, pos.func_177977_b(), direction, plantable);
    }

    @Override
    public boolean isValidSoil(IBlockAccess world, BlockPos pos) {
        return PrimalAPI.Predicates.SOIL_NETHER_COMMON.apply((Object)world.func_180495_p(pos));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        if (CommonUtils.isExposedToSun(world, pos.func_177984_a())) {
            FXHelper.smokeParticles(world, pos, 3, 6, 0.62f);
        }
    }
}

