/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.blocks.machines;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBed;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import nmd.primal.core.api.interfaces.types.ITypeNBT;
import nmd.primal.core.api.interfaces.types.ITypeWood;
import nmd.primal.core.common.blocks.AbstractBed;
import nmd.primal.core.common.helper.NBTHelper;
import nmd.primal.core.common.tiles.machines.TileTatamiBed;

public class TatamiBed
extends AbstractBed
implements ITypeWood {
    public TatamiBed() {
        super(Material.field_151575_d, MapColor.field_151676_q);
        this.func_149672_a(SoundType.field_185848_a);
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileTatamiBed();
    }

    @Override
    public void func_176216_a(World world, Entity entity) {
        if (entity.func_70093_af()) {
            super.func_176216_a(world, entity);
        } else if (entity.field_70181_x < 0.0) {
            entity.field_70181_x = -entity.field_70181_x * (double)0.66f;
            if (!(entity instanceof EntityLivingBase)) {
                entity.field_70181_x *= 0.65;
            }
        }
    }

    @Override
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        double height_top = 0.5;
        double height_bottom = 0.125;
        double offset_one = 0.125;
        double offset_two = 0.875;
        switch ((EnumFacing)state.func_177229_b((IProperty)BlockHorizontal.field_185512_D)) {
            case NORTH: {
                return TatamiBed.isHead(state) ? new AxisAlignedBB(offset_one, height_bottom, offset_one, offset_two, height_top, 1.0) : new AxisAlignedBB(offset_one, height_bottom, 0.0, offset_two, height_top, offset_two);
            }
            case SOUTH: {
                return TatamiBed.isHead(state) ? new AxisAlignedBB(offset_one, height_bottom, 0.0, offset_two, height_top, offset_two) : new AxisAlignedBB(offset_one, height_bottom, offset_one, offset_two, height_top, 1.0);
            }
            case EAST: {
                return TatamiBed.isHead(state) ? new AxisAlignedBB(0.0, height_bottom, offset_one, offset_two, height_top, offset_two) : new AxisAlignedBB(offset_one, height_bottom, offset_one, 1.0, height_top, offset_two);
            }
            case WEST: {
                return TatamiBed.isHead(state) ? new AxisAlignedBB(offset_one, height_bottom, offset_one, 1.0, height_top, offset_two) : new AxisAlignedBB(0.0, height_bottom, offset_one, offset_two, height_top, offset_two);
            }
        }
        return super.func_185496_a(state, source, pos);
    }

    @Override
    public void func_180653_a(World world, BlockPos pos, IBlockState state, float chance, int fortune) {
        if (TatamiBed.isHead(state)) {
            ItemStack stack = this.func_185473_a(world, pos, state);
            TatamiBed.func_180635_a((World)world, (BlockPos)pos, (ItemStack)stack);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        for (ITypeWood.EnumType blocks$enumtype : ITypeWood.EnumType.values()) {
            ItemStack stack = new ItemStack((Block)this, 1, blocks$enumtype.getMetadata());
            NBTHelper.setString(stack, "type", blocks$enumtype.func_176610_l());
            list.add((Object)stack);
        }
    }

    @Override
    public ItemStack func_185473_a(World world, BlockPos pos, IBlockState state) {
        TileEntity tile;
        BlockPos blockpos = pos;
        if (TatamiBed.isFoot(state)) {
            blockpos = pos.func_177972_a((EnumFacing)state.func_177229_b((IProperty)BlockHorizontal.field_185512_D));
        }
        if ((tile = world.func_175625_s(blockpos)) != null && !tile.func_145837_r() && tile instanceof ITypeNBT) {
            ItemStack stack = new ItemStack((Block)this, 1, ITypeWood.EnumType.byName(((ITypeNBT)tile).getType()).getMetadata());
            NBTHelper.setString(stack, "type", ((ITypeNBT)tile).getType());
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public void func_180657_a(World world, EntityPlayer player, BlockPos pos, IBlockState state, TileEntity tile, ItemStack stack) {
        if (TatamiBed.isHead(state) && tile instanceof TileTatamiBed) {
            TileTatamiBed tatami = (TileTatamiBed)tile;
            ItemStack itemstack = tatami.getItemStack();
            TatamiBed.func_180635_a((World)world, (BlockPos)pos, (ItemStack)itemstack);
        } else {
            super.func_180657_a(world, player, pos, state, null, stack);
        }
    }

    @Override
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return TatamiBed.isFoot(state) ? Items.field_190931_a : Item.func_150898_a((Block)this);
    }

    public int func_180651_a(IBlockState state) {
        return ((ITypeWood.EnumType)((Object)state.func_177229_b((IProperty)TYPE))).getMetadata();
    }

    public float func_176195_g(IBlockState state, World world, BlockPos pos) {
        return this.getTypeHardness((IBlockAccess)world, pos, world.func_180495_p(pos));
    }

    public float getExplosionResistance(World world, BlockPos pos, @Nullable Entity exploder, Explosion explosion) {
        return this.getTypeResistance((IBlockAccess)world, pos, world.func_180495_p(pos));
    }

    @Override
    public boolean isFlammable(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return this.getTypeFlammability(world, pos, world.func_180495_p(pos)) > 0;
    }

    @Override
    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return this.getTypeFlammability(world, pos, world.func_180495_p(pos));
    }

    @Override
    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return this.getTypeEncouragement(world, pos, world.func_180495_p(pos));
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{ITypeWood.TYPE, BlockHorizontal.field_185512_D, BlockBed.field_176472_a, BlockBed.field_176471_b});
    }

    @Override
    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity tile;
        IBlockState iblockstate;
        if (TatamiBed.isFoot(state) && (iblockstate = world.func_180495_p(pos.func_177972_a((EnumFacing)state.func_177229_b((IProperty)BlockHorizontal.field_185512_D)))).func_177230_c() == this) {
            state = state.func_177226_a((IProperty)BlockBed.field_176471_b, iblockstate.func_177229_b((IProperty)BlockBed.field_176471_b));
        }
        if ((tile = world.func_175625_s(pos)) != null && !tile.func_145837_r() && tile instanceof ITypeNBT) {
            String type = ((ITypeNBT)tile).getType();
            return state.func_177226_a((IProperty)TYPE, (Comparable)((Object)ITypeWood.EnumType.byName(type)));
        }
        return state;
    }
}

