/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.blocks.machines;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemHandlerHelper;
import nmd.primal.core.api.interfaces.IPickup;
import nmd.primal.core.api.interfaces.types.ITypeWood;
import nmd.primal.core.common.PrimalCore;
import nmd.primal.core.common.blocks.AbstractContainer;
import nmd.primal.core.common.helper.NBTHelper;
import nmd.primal.core.common.helper.PlayerHelper;
import nmd.primal.core.common.helper.RecipeHelper;
import nmd.primal.core.common.init.ModConfig;
import nmd.primal.core.common.tiles.machines.TileStorageCrate;

public class StorageCrate
extends AbstractContainer<TileStorageCrate>
implements ITypeWood,
IPickup {
    public StorageCrate() {
        super(Material.field_151573_f, MapColor.field_151670_w);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_149711_c(5.0f);
        this.func_149752_b(20.0f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)TYPE, (Comparable)((Object)ITypeWood.EnumType.LACQUER)));
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileStorageCrate();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable World player, List<String> tooltip, ITooltipFlag advanced) {
        super.func_190948_a(stack, player, tooltip, advanced);
        if (ModConfig.Machines.CRATES_RETAIN_INVENTORY) {
            tooltip.add(TextFormatting.GREEN + I18n.func_74838_a((String)"tooltip.info.primal.storage_crate_inventory"));
        }
        tooltip.add(TextFormatting.BLUE + I18n.func_74838_a((String)"tooltip.info.primal.storage_crate"));
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing face, float hitX, float hitY, float hitZ) {
        super.func_180639_a(world, pos, state, player, hand, face, hitX, hitY, hitZ);
        if (world.field_72995_K) {
            return true;
        }
        player.openGui((Object)PrimalCore.INSTANCE, 4, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        return true;
    }

    @Override
    public boolean doPickup(World world, BlockPos pos, IBlockState state, EnumFacing face, EntityPlayer player, EnumHand hand) {
        if (world.field_72995_K) {
            return true;
        }
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && !tile.func_145837_r() && tile instanceof TileStorageCrate) {
            if (((TileStorageCrate)tile).shouldDrop()) {
                ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)this.func_185473_a(world, pos, state));
            } else {
                this.dropItems(world, pos, state);
            }
            world.func_175666_e(pos, state.func_177230_c());
            world.func_175656_a(pos, this.getReplacementBlock(world, pos, state));
            world.func_175713_t(pos);
            return true;
        }
        return false;
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        this.func_176208_a(world, pos, state, player);
        return this.doPickup(world, pos, state, EnumFacing.UP, player, player.func_184600_cs());
    }

    public ItemStack func_185473_a(World world, BlockPos pos, IBlockState state) {
        return NBTHelper.getStackBlockNBT(world, pos, state, super.func_185473_a(world, pos, state));
    }

    public void func_176208_a(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return null;
    }

    public void func_180653_a(World world, BlockPos pos, IBlockState state, float chance, int fortune) {
    }

    public EnumPushReaction func_149656_h(IBlockState state) {
        return EnumPushReaction.IGNORE;
    }

    public boolean func_149659_a(Explosion explosionIn) {
        return true;
    }

    private void dropItems(World world, BlockPos pos, IBlockState state) {
        TileEntity tile;
        if (!world.field_72995_K && world.func_82736_K().func_82766_b("doTileDrops") && !world.restoringBlockSnapshots && (tile = world.func_175625_s(pos)) != null && !tile.func_145837_r() && tile instanceof TileStorageCrate) {
            float offset = 0.7f;
            RecipeHelper.dropSlotItems(world, pos, offset, ((TileStorageCrate)tile).getStorageHandler());
            PlayerHelper.spawnItemInAir(world, pos, new ItemStack((Block)this));
        }
        super.func_180663_b(world, pos, state);
    }

    public boolean func_149740_M(IBlockState state) {
        return false;
    }

    public int func_180641_l(IBlockState blockState, World world, BlockPos pos) {
        return 0;
    }

    @Override
    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public boolean func_149662_c(IBlockState state) {
        return true;
    }

    public boolean func_149686_d(IBlockState state) {
        return true;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.CENTER;
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing face, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a((IProperty)TYPE, (Comparable)((Object)ITypeWood.EnumType.byMetadata(placer.func_184586_b(hand).func_77952_i())));
    }

    public int func_180651_a(IBlockState state) {
        return ((ITypeWood.EnumType)((Object)state.func_177229_b((IProperty)TYPE))).getMetadata();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        this.getTypes(Item.func_150898_a((Block)this), tab, list);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{TYPE});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)TYPE, (Comparable)((Object)ITypeWood.EnumType.byMetadata(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((ITypeWood.EnumType)((Object)state.func_177229_b((IProperty)TYPE))).getMetadata();
    }
}

