/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.blocks.machines;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemHandlerHelper;
import nmd.primal.core.api.PrimalAPI;
import nmd.primal.core.api.events.BarrelEvent;
import nmd.primal.core.api.events.BarrelPickupEvent;
import nmd.primal.core.api.interfaces.IPickup;
import nmd.primal.core.api.interfaces.ISchedule;
import nmd.primal.core.api.interfaces.types.ITypeBarrels;
import nmd.primal.core.common.blocks.AbstractTank;
import nmd.primal.core.common.compat.vanilla.VanillaTorchItem;
import nmd.primal.core.common.helper.BlockHelper;
import nmd.primal.core.common.helper.DamageHelper;
import nmd.primal.core.common.helper.FXHelper;
import nmd.primal.core.common.helper.FireHelper;
import nmd.primal.core.common.helper.NBTHelper;
import nmd.primal.core.common.helper.PlayerHelper;
import nmd.primal.core.common.init.ModConfig;
import nmd.primal.core.common.items.LitTorch;
import nmd.primal.core.common.potions.ModPotions;
import nmd.primal.core.common.recipes.inworld.BottleRecipe;
import nmd.primal.core.common.tiles.machines.TileBarrel;

public class Barrel
extends AbstractTank<TileBarrel>
implements ITypeBarrels,
IPickup,
ISchedule {
    public Barrel() {
        super(Material.field_151575_d);
    }

    @Nullable
    public TileEntity func_149915_a(World world, int meta) {
        return new TileBarrel();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag advanced) {
        String fluidinfo = I18n.func_74838_a((String)"tooltip.info.primal.abstract_tank_size") + ": " + TileBarrel.getCapacity() + "mb";
        NBTTagCompound nbt = stack.func_179543_a("BlockEntityTag");
        if (nbt != null) {
            FluidStack fluid = FluidRegistry.getFluidStack((String)nbt.func_74779_i("FluidName"), (int)nbt.func_74762_e("Amount"));
            if (fluid != null) {
                fluidinfo = I18n.func_74838_a((String)"tooltip.info.primal.abstract_tank_fluid") + ": " + fluid.getLocalizedName() + " " + fluid.amount + "/" + TileBarrel.getCapacity() + "mb";
            }
            if (nbt.func_74767_n("trapped")) {
                tooltip.add(TextFormatting.RED + I18n.func_74838_a((String)"tooltip.info.primal.barrel_trap"));
            }
        }
        tooltip.add(TextFormatting.BLUE + fluidinfo);
        super.func_190948_a(stack, world, tooltip, advanced);
    }

    public boolean trapBarrel(World world, BlockPos pos, TileBarrel tile) {
        FluidStack trap;
        if (tile.isTrapped() && (trap = tile.getContainedFluid()) != null && trap.getFluid() == FluidRegistry.getFluid((String)"paraffin")) {
            int amount = trap.amount / 125;
            this.playSoundHiss(world, pos);
            if (world.func_175698_g(pos)) {
                return FireHelper.explode(world, pos, null, RANDOM.nextInt(amount < 3 ? amount : amount / 2, amount < 3 ? amount + 1 : amount), (float)ModConfig.Fluids.PARAFFIN_BARREL_EXPLOSION_MODIFIER, true, false);
            }
        }
        return false;
    }

    @Override
    public ItemStack getLid(World world, BlockPos pos, IBlockState state) {
        ITypeBarrels.EnumType type = (ITypeBarrels.EnumType)((Object)state.func_185899_b((IBlockAccess)world, pos).func_177229_b((IProperty)TYPE));
        switch (type) {
            case OAK: {
                return new ItemStack(PrimalAPI.Items.BARREL_LID_OAK);
            }
            case SPRUCE: {
                return new ItemStack(PrimalAPI.Items.BARREL_LID_SPRUCE);
            }
            case BIRCH: {
                return new ItemStack(PrimalAPI.Items.BARREL_LID_BIRCH);
            }
            case JUNGLE: {
                return new ItemStack(PrimalAPI.Items.BARREL_LID_JUNGLE);
            }
            case ACACIA: {
                return new ItemStack(PrimalAPI.Items.BARREL_LID_ACACIA);
            }
            case DARK_OAK: {
                return new ItemStack(PrimalAPI.Items.BARREL_LID_DARK_OAK);
            }
            case YEW: {
                return new ItemStack(PrimalAPI.Items.BARREL_LID_YEW);
            }
            case IRONWOOD: {
                return new ItemStack(PrimalAPI.Items.BARREL_LID_IRONWOOD);
            }
            case CORYPHA: {
                return new ItemStack(PrimalAPI.Items.BARREL_LID_CORYPHA);
            }
            case LACQUER: {
                return new ItemStack(PrimalAPI.Items.BARREL_LID_LACQUER);
            }
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public boolean canPickup(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        TileEntity tile = world.func_175625_s(pos);
        return tile != null && !tile.func_145837_r() && tile instanceof TileBarrel && ((TileBarrel)tile).isCovered();
    }

    @Override
    public boolean doPickup(World world, BlockPos pos, IBlockState state, EnumFacing face, EntityPlayer player, EnumHand hand) {
        if (world.field_72995_K) {
            return true;
        }
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && !tile.func_145837_r() && tile instanceof TileBarrel) {
            if (((TileBarrel)tile).isCovered() && face == EnumFacing.UP) {
                BarrelEvent.Open open = new BarrelEvent.Open((TileBarrel)tile, player);
                if (MinecraftForge.EVENT_BUS.post((Event)open)) {
                    return false;
                }
                if (!this.trapBarrel(world, pos, (TileBarrel)tile)) {
                    ((TileBarrel)tile).setCovered(false);
                    ((TileBarrel)tile).updateBlock();
                    this.playSoundLid(world, pos);
                    ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)this.getLid(world, pos, state));
                }
                return true;
            }
            ItemStack pickup_stack = this.func_185473_a(world, pos, state);
            BarrelPickupEvent.Pre pre = new BarrelPickupEvent.Pre((TileBarrel)tile, player, pickup_stack);
            if (MinecraftForge.EVENT_BUS.post((Event)pre)) {
                return false;
            }
            ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)pickup_stack);
            world.func_175666_e(pos, state.func_177230_c());
            world.func_175656_a(pos, this.getReplacementBlock(world, pos, state));
            world.func_175713_t(pos);
            MinecraftForge.EVENT_BUS.post((Event)new BarrelPickupEvent.Post((TileBarrel)tile, player, pickup_stack));
            return true;
        }
        return super.removedByPlayer(state, world, pos, player, true);
    }

    @Override
    public boolean shouldSchedule(World world, BlockPos pos, IBlockState state) {
        TileEntity tile = world.func_175625_s(pos);
        return tile != null && !tile.func_145837_r() && tile instanceof TileBarrel && FireHelper.isFluidVolatile(((TileBarrel)tile).getContainedFluid());
    }

    @Override
    public boolean shouldScheduleOnPlacement() {
        return false;
    }

    @Override
    public int scheduledTicks(World world, BlockPos pos, IBlockState state) {
        return RANDOM.nextInt(ModConfig.Machines.BARREL_TICK_RATE / 2, ModConfig.Machines.BARREL_TICK_RATE);
    }

    @Override
    public void func_176224_k(World world, BlockPos pos) {
        if (world.field_72995_K) {
            return;
        }
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && !tile.func_145837_r() && tile instanceof TileBarrel && !((TileBarrel)tile).isCovered()) {
            ((TileBarrel)tile).fillWithRain();
        }
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random random) {
        super.func_180650_b(world, pos, state, random);
        if (world.field_72995_K) {
            return;
        }
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && !tile.func_145837_r() && tile instanceof TileBarrel) {
            FluidStack fluidStack;
            PrimalAPI.logger(25, "barrel is updating");
            BarrelEvent.Update update = new BarrelEvent.Update((TileBarrel)tile);
            if (MinecraftForge.EVENT_BUS.post((Event)update)) {
                return;
            }
            FluidStack fluid = ((TileBarrel)tile).getContainedFluid();
            if (FireHelper.isFluidHot(fluid)) {
                int fireSides = 0;
                for (EnumFacing facing : EnumFacing.field_176754_o) {
                    Block temp = world.func_180495_p(pos.func_177972_a(facing)).func_177230_c();
                    if (temp == Blocks.field_150480_ab) {
                        ++fireSides;
                        continue;
                    }
                    if (temp instanceof BlockFluidBase) {
                        if (((BlockFluidBase)temp).getFluid().getTemperature() < FluidRegistry.LAVA.getTemperature()) continue;
                        ++fireSides;
                        continue;
                    }
                    if (!(temp instanceof BlockLiquid) || temp.func_149688_o(world.func_180495_p(pos.func_177972_a(facing))) != Material.field_151587_i) continue;
                    ++fireSides;
                }
                if (fireSides == 4) {
                    Block block = fluid.getFluid().getBlock();
                    if (block == null) {
                        block = FluidRegistry.LAVA.getBlock();
                    }
                    world.func_175656_a(pos, block.func_176223_P());
                } else {
                    for (EnumFacing facing : EnumFacing.field_82609_l) {
                        if (facing == EnumFacing.DOWN || !FireHelper.canCatchFire(world, pos, facing) || !world.func_175623_d(pos.func_177972_a(facing))) continue;
                        FireHelper.setFire(world, pos.func_177972_a(facing));
                    }
                }
            }
            if ((fluidStack = ((TileBarrel)tile).getContainedFluid()) != null && fluidStack.getFluid() == FluidRegistry.getFluid((String)"paraffin") && !BlockHelper.hasStabilizingBlock((IBlockAccess)world, pos, EnumFacing.DOWN) && FireHelper.hasNearByFire(world, pos, ((TileBarrel)tile).isCovered() ? 1 : 4, ((TileBarrel)tile).isCovered() ? 1 : 3)) {
                int amount = fluidStack.amount / 125;
                PrimalAPI.logger(25, "barrel explosion", "fluid: " + fluidStack.getFluid() + ":" + fluidStack.amount + ":" + amount);
                world.func_175698_g(pos);
                FireHelper.explode(world, pos, null, RANDOM.nextInt(amount < 3 ? amount : amount / 2, amount < 3 ? amount + 1 : amount), (float)ModConfig.Fluids.PARAFFIN_BARREL_EXPLOSION_MODIFIER, true, false);
            }
            PrimalAPI.logger(25, "schedule", this.getName() + "@" + pos + ":" + world.field_73011_w.getDimension() + ", AbstractPlantGrowing#updateTick");
            PrimalAPI.scheduleBlock(world, pos, state);
        }
    }

    public void func_180658_a(World world, BlockPos pos, Entity entity, float fallDistance) {
        IFluidHandler fluidHandler;
        super.func_180658_a(world, pos, entity, fallDistance);
        if (world.field_72995_K) {
            return;
        }
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && !tile.func_145837_r() && tile instanceof TileBarrel && ((TileBarrel)tile).isCovered() && (fluidHandler = (IFluidHandler)tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null)) != null) {
            FluidStack fluidStack = fluidHandler.drain(250, false);
            this.playSoundHit(world, pos, fluidStack);
        }
    }

    public void func_180649_a(World world, BlockPos pos, EntityPlayer player) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && !tile.func_145837_r() && tile instanceof TileBarrel) {
            this.playSoundHit(world, pos, ((TileBarrel)tile).getContainedFluid());
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing face, float hitX, float hitY, float hitZ) {
        if (hand == EnumHand.OFF_HAND) {
            return false;
        }
        if (world.field_72995_K) {
            return true;
        }
        TileBarrel tile = (TileBarrel)world.func_175625_s(pos);
        if (tile == null || tile.func_145837_r()) {
            return true;
        }
        if (tile.isCovered()) {
            PrimalAPI.logger(25, "barrel", "is covered");
            this.playSoundHit(world, pos, tile.getContainedFluid());
            return true;
        }
        IFluidHandler handler = (IFluidHandler)tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, face);
        if (handler == null) {
            return true;
        }
        ItemStack stack = player.func_184586_b(hand);
        if (this.isLid(world, pos, state, stack)) {
            BarrelEvent.Close close = new BarrelEvent.Close(tile, player);
            if (MinecraftForge.EVENT_BUS.post((Event)close)) {
                return false;
            }
            tile.setCovered(true);
            tile.updateBlock();
            PlayerHelper.useStack(player, hand, stack);
            this.playSoundLid(world, pos);
            return true;
        }
        if (this.isBottle(stack)) {
            BottleRecipe recipe;
            FluidStack fluidStack = handler.drain(250, false);
            if (fluidStack != null && 250 == fluidStack.amount && (recipe = BottleRecipe.getRecipe(fluidStack)) != null) {
                handler.drain(250, true);
                PlayerHelper.useStackTakeItem(player, hand, recipe.getOutput());
                Barrel.playSoundFill(world, player.func_180425_c(), stack);
            }
            PrimalAPI.scheduleBlock(world, pos, state);
            return true;
        }
        if (BottleRecipe.isOutput(stack)) {
            BottleRecipe recipe;
            FluidStack fluidStack = handler.drain(250, false);
            if (fluidStack != null && handler.fill(fluidStack, false) == fluidStack.amount) {
                BottleRecipe recipe2 = BottleRecipe.getRecipe(fluidStack);
                if (recipe2 != null && recipe2.getOutput().func_77969_a(stack)) {
                    handler.fill(fluidStack, true);
                    PlayerHelper.useStackTakeItem(player, hand, new ItemStack(Items.field_151069_bo));
                    Barrel.playSoundEmpty(world, player.func_180425_c(), stack);
                }
            } else if (fluidStack == null && (recipe = BottleRecipe.getRecipe(stack)) != null && handler.fill(fluidStack = new FluidStack(recipe.getInput(), 250), false) == fluidStack.amount) {
                handler.fill(new FluidStack(recipe.getInput(), 250), true);
                PlayerHelper.useStackTakeItem(player, hand, new ItemStack(Items.field_151069_bo));
                Barrel.playSoundEmpty(world, player.func_180425_c(), stack);
            }
            PrimalAPI.scheduleBlock(world, pos, state);
            return true;
        }
        if (FluidUtil.interactWithFluidHandler((EntityPlayer)player, (EnumHand)hand, (IFluidHandler)handler)) {
            PrimalAPI.scheduleBlock(world, pos, state);
            return true;
        }
        if (face != EnumFacing.UP) {
            this.playSoundHit(world, pos, tile.getContainedFluid());
            return true;
        }
        return super.func_180639_a(world, pos, state, player, hand, face, hitX, hitY, hitZ);
    }

    @Override
    public void onBlockExploded(World world, BlockPos pos, Explosion explosion) {
        FluidStack fluidStack;
        super.onBlockExploded(world, pos, explosion);
        if (world.field_72995_K) {
            return;
        }
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && !tile.func_145837_r() && tile instanceof TileBarrel && (fluidStack = ((TileBarrel)tile).getContainedFluid()) != null && fluidStack.getFluid() == FluidRegistry.getFluid((String)"paraffin")) {
            int amount = fluidStack.amount / 125;
            float factor = (float)ModConfig.Fluids.PARAFFIN_BARREL_EXPLOSION_MODIFIER;
            super.onBlockExploded(world, pos, explosion);
            FireHelper.explode(world, pos, null, RANDOM.nextInt(amount < 3 ? amount : amount / 2, amount < 3 ? amount + 1 : amount), factor, true, false);
            PrimalAPI.logger(25, "barrel explosion", "fluid: " + fluidStack.getFluid() + ":" + fluidStack.amount + ":" + amount);
        }
    }

    @Override
    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        TileEntity tile;
        if (!world.field_72995_K && entity != null && (tile = world.func_175625_s(pos)) instanceof TileBarrel && !((TileBarrel)tile).isCovered()) {
            Fluid fluid;
            Block block;
            FluidStack fluidStack = ((TileBarrel)tile).getContainedFluid();
            float height = (float)pos.func_177956_o() + ((TileBarrel)tile).getFluidHeight() / 16.0f;
            if (fluidStack != null && fluidStack.amount > 100 && entity.func_174813_aQ().field_72338_b <= (double)height && (block = (fluid = fluidStack.getFluid()).getBlock()) != null) {
                Material material = block.func_176223_P().func_185904_a();
                boolean isHot = FireHelper.isFluidHot(fluidStack);
                BarrelEvent.Quench quench = new BarrelEvent.Quench((TileBarrel)tile, entity, fluidStack, material);
                if (MinecraftForge.EVENT_BUS.post((Event)quench)) {
                    return;
                }
                if (material == Material.field_151587_i || isHot) {
                    if (!entity.func_70045_F()) {
                        FireHelper.doLavaDamage(entity, 4.0f);
                        this.playSoundBurn(world, pos);
                        FXHelper.fxLava(world, pos);
                    }
                } else if (material == Material.field_151586_h) {
                    if (entity.func_70027_ad()) {
                        if (fluid == FluidRegistry.getFluid((String)"paraffin") && !BlockHelper.hasStabilizingBlock((IBlockAccess)world, pos, EnumFacing.DOWN)) {
                            int amount = fluidStack.amount / 125;
                            world.func_175698_g(pos);
                            FireHelper.explode(world, pos, null, RANDOM.nextInt(amount < 3 ? amount : amount / 2, amount < 3 ? amount + 1 : amount), (float)ModConfig.Fluids.PARAFFIN_BARREL_EXPLOSION_MODIFIER, true, false);
                        } else if (block.getFireSpreadSpeed((IBlockAccess)world, pos, EnumFacing.UP) > 0) {
                            entity.func_70015_d(fluidStack.amount / 100);
                            if (PrimalAPI.randomCheck(8)) {
                                this.playSoundBurn(world, pos);
                            }
                        } else if (fluidStack.amount >= 250) {
                            entity.func_70066_B();
                            this.playSoundHiss(world, pos);
                            FXHelper.fxWater(world, pos);
                        }
                    } else if (entity instanceof EntityItem) {
                        ItemStack entityStack = ((EntityItem)entity).func_92059_d();
                        if (entityStack.func_77969_a(new ItemStack(Blocks.field_150478_aa))) {
                            ((VanillaTorchItem)entityStack.func_77973_b()).douseTorchEntity((EntityItem)entity);
                        } else if (entityStack.func_77973_b() instanceof LitTorch) {
                            ((LitTorch)entityStack.func_77973_b()).douseTorchEntity((EntityItem)entity);
                        }
                    } else if (entity instanceof EntityLivingBase && ((EntityLivingBase)entity).func_70644_a((Potion)ModPotions.WATER_BURN) && PrimalAPI.randomCheck(8)) {
                        DamageHelper.applyWaterDamage((EntityLivingBase)entity, 1, true);
                    }
                }
            }
        }
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        this.func_176208_a(world, pos, state, player);
        return this.doPickup(world, pos, state, EnumFacing.DOWN, player, player.func_184600_cs());
    }

    @Override
    public void func_176208_a(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        super.func_176208_a(world, pos, state, player);
        if (world.field_72995_K) {
            return;
        }
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && !tile.func_145837_r() && tile instanceof TileBarrel) {
            this.trapBarrel(world, pos, (TileBarrel)tile);
        }
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return null;
    }

    public void func_180653_a(World world, BlockPos pos, IBlockState state, float chance, int fortune) {
    }

    public void playSoundHit(World world, BlockPos pos, FluidStack fluid) {
        SoundCategory category = SoundCategory.BLOCKS;
        float variation = RANDOM.nextFloat() * 0.4f;
        float volume = 0.4f;
        if (fluid != null && fluid.amount > 0) {
            world.func_184133_a(null, pos, PrimalAPI.Sounds.SOUND_BLOCK_BARREL_FILLED, category, volume, variation + 0.8f);
        } else {
            world.func_184133_a(null, pos, PrimalAPI.Sounds.SOUND_BLOCK_BARREL_EMPTY, category, volume, variation + 0.8f);
        }
    }

    public void playSoundLid(World world, BlockPos pos) {
        world.func_184133_a(null, pos, PrimalAPI.Sounds.SOUND_BLOCK_BARREL_LID, SoundCategory.BLOCKS, 0.5f, RANDOM.nextFloat() * 0.4f + 0.8f);
    }

    public void playSoundHiss(World world, BlockPos pos) {
        world.func_184133_a(null, pos, SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 0.5f, RANDOM.nextFloat() * 0.4f + 0.8f);
    }

    public void playSoundBurn(World world, BlockPos pos) {
        world.func_184133_a(null, pos, SoundEvents.field_187659_cY, SoundCategory.BLOCKS, 0.5f, RANDOM.nextFloat() * 0.4f + 0.8f);
    }

    public void playSoundTrap(World world, BlockPos pos) {
        world.func_184133_a(null, pos, SoundEvents.field_187905_ge, SoundCategory.BLOCKS, 0.5f, RANDOM.nextFloat() * 0.4f + 0.8f);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return PrimalAPI.Bounds.AABB_BARREL;
    }

    @Override
    public void func_185477_a(IBlockState state, World world, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean isActualState) {
        if (this.isCovered((IBlockAccess)world, pos, state)) {
            super.func_185477_a(state, world, pos, entityBox, collidingBoxes, entityIn, isActualState);
        } else {
            Barrel.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.125));
            Barrel.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)new AxisAlignedBB(0.0, 0.0, 0.875, 1.0, 1.0, 1.0));
            Barrel.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)new AxisAlignedBB(0.875, 0.0, 0.0, 1.0, 1.0, 1.0));
            Barrel.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)new AxisAlignedBB(0.0, 0.0, 0.0, 0.125, 1.0, 1.0));
        }
    }

    @Override
    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing face) {
        return face == EnumFacing.UP && !this.isCovered(world, pos, state) ? BlockFaceShape.BOWL : BlockFaceShape.UNDEFINED;
    }

    @Override
    public boolean func_176205_b(IBlockAccess worldIn, BlockPos pos) {
        return true;
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing face, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a((IProperty)TYPE, (Comparable)((Object)ITypeBarrels.EnumType.byMetadata(placer.func_184586_b(hand).func_77952_i())));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        this.getTypes(Item.func_150898_a((Block)this), tab, list);
    }

    @Override
    public ItemStack func_185473_a(World world, BlockPos pos, IBlockState state) {
        ItemStack stack = super.func_185473_a(world, pos, state);
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && !tile.func_145837_r() && tile instanceof TileBarrel && ((TileBarrel)tile).isCovered()) {
            NBTHelper.getStackBlockNBT(world, pos, state, stack);
        }
        return stack;
    }

    public int func_180651_a(IBlockState state) {
        return ((ITypeBarrels.EnumType)((Object)state.func_177229_b((IProperty)TYPE))).getMetadata();
    }

    public float func_176195_g(IBlockState state, World world, BlockPos pos) {
        return this.getTypeHardness((IBlockAccess)world, pos, world.func_180495_p(pos));
    }

    public float getExplosionResistance(World world, BlockPos pos, @Nullable Entity exploder, Explosion explosion) {
        return this.getTypeResistance((IBlockAccess)world, pos, world.func_180495_p(pos));
    }

    @Override
    public boolean isFlammable(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return this.getTypeFlammability(world, pos, world.func_180495_p(pos)) > 0;
    }

    @Override
    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return this.getTypeFlammability(world, pos, world.func_180495_p(pos));
    }

    @Override
    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return this.getTypeEncouragement(world, pos, world.func_180495_p(pos));
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{PrimalAPI.States.COVERED, TYPE});
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)TYPE, (Comparable)((Object)ITypeBarrels.EnumType.byMetadata(meta)));
    }

    @Override
    public int func_176201_c(IBlockState state) {
        return ((ITypeBarrels.EnumType)((Object)state.func_177229_b((IProperty)TYPE))).getMetadata();
    }
}

