/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.blocks;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import nmd.primal.core.api.PrimalAPI;
import nmd.primal.core.common.blocks.AbstractContainer;
import nmd.primal.core.common.helper.FluidHelper;
import nmd.primal.core.common.helper.NBTHelper;
import nmd.primal.core.common.tiles.AbstractTileTank;

public abstract class AbstractTank<TILE extends AbstractTileTank>
extends AbstractContainer<TILE> {
    public AbstractTank(Material material) {
        super(material);
        this.func_149713_g(0);
    }

    @Override
    public PathNodeType getAiPathNodeType(IBlockState state, IBlockAccess world, BlockPos pos) {
        return PathNodeType.DAMAGE_FIRE;
    }

    public boolean canCollectRain(World world, BlockPos pos, AbstractTileTank tile) {
        return !tile.isCovered();
    }

    public boolean isLid(World world, BlockPos pos, IBlockState state, ItemStack stack) {
        return this.getLid(world, pos, state).func_77969_a(stack);
    }

    public boolean isBottle(ItemStack stack) {
        return stack.func_77973_b() == Items.field_151069_bo;
    }

    public abstract ItemStack getLid(World var1, BlockPos var2, IBlockState var3);

    public void func_176224_k(World world, BlockPos pos) {
        if (world.field_72995_K) {
            return;
        }
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && !tile.func_145837_r() && tile instanceof AbstractTileTank && this.canCollectRain(world, pos, (AbstractTileTank)tile)) {
            ((AbstractTileTank)tile).fillWithRain();
        }
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
    }

    public void func_176208_a(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
    }

    public void onBlockExploded(World world, BlockPos pos, Explosion explosion) {
    }

    public ItemStack func_185473_a(World world, BlockPos pos, IBlockState state) {
        ItemStack stack = super.func_185473_a(world, pos, state);
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && !tile.func_145837_r() && tile instanceof AbstractTileTank && ((AbstractTileTank)tile).isCovered()) {
            NBTHelper.getStackBlockNBT(world, pos, state, stack);
        }
        return stack;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable World player, List<String> tooltip, ITooltipFlag advanced) {
        tooltip.add(TextFormatting.GOLD + I18n.func_74838_a((String)"tooltip.info.primal.abstract_tank_rain"));
        tooltip.add(TextFormatting.GOLD + I18n.func_74838_a((String)"tooltip.info.primal.abstract_tank_lid"));
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        if (face == EnumFacing.UP) {
            return BlockFaceShape.BOWL;
        }
        return face == EnumFacing.DOWN ? BlockFaceShape.UNDEFINED : BlockFaceShape.UNDEFINED;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean doesSideBlockRendering(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing face) {
        return false;
    }

    public static void playSoundFill(World world, BlockPos pos, ItemStack stack) {
        world.func_184133_a(null, pos, FluidHelper.getSoundFill(stack), SoundCategory.PLAYERS, 0.5f, RANDOM.nextFloat() * 0.4f + 0.8f);
    }

    public static void playSoundEmpty(World world, BlockPos pos, ItemStack stack) {
        world.func_184133_a(null, pos, FluidHelper.getSoundEmpty(stack), SoundCategory.PLAYERS, 0.5f, RANDOM.nextFloat() * 0.4f + 0.8f);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{PrimalAPI.States.COVERED});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P();
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && !tile.func_145837_r() && tile instanceof AbstractTileTank) {
            return state.func_177226_a((IProperty)PrimalAPI.States.COVERED, (Comparable)Boolean.valueOf(((AbstractTileTank)tile).isCovered()));
        }
        return state;
    }

    public boolean isCovered(IBlockAccess world, BlockPos pos, IBlockState state) {
        return (Boolean)state.func_185899_b(world, pos).func_177229_b((IProperty)PrimalAPI.States.COVERED);
    }
}

