/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.client.particles;

import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.ResourceLocation;

public final class ParticleTextureStitcher<T> {
    private final ResourceLocation[] textures;
    private Frame[][] loadedFrames;
    private boolean splitAnimations = false;

    public static <T extends Particle> ParticleTextureStitcher<T> create(Class<T> cls, ResourceLocation ... textures) {
        return new ParticleTextureStitcher<T>(textures);
    }

    public static <T extends Particle> ParticleTextureStitcher<T> create(Class<T> cls, ResourceLocation texture) {
        return ParticleTextureStitcher.create(cls, new ResourceLocation[]{texture});
    }

    private ParticleTextureStitcher(ResourceLocation[] textures) {
        this.textures = textures;
    }

    public ParticleTextureStitcher<T> setSplitAnimations(boolean split) {
        this.splitAnimations = true;
        return this;
    }

    public void setFrames(Frame[][] frames) {
        this.loadedFrames = frames;
    }

    public boolean shouldSplitAnimations() {
        return this.splitAnimations;
    }

    public ResourceLocation[] getTextures() {
        return this.textures;
    }

    public Frame[][] getSprites() {
        return this.loadedFrames;
    }

    public static final class Frame {
        private final TextureAtlasSprite sprite;
        private final int duration;

        protected Frame(TextureAtlasSprite sprite, int duration) {
            this.sprite = sprite;
            this.duration = duration;
        }

        public TextureAtlasSprite getSprite() {
            return this.sprite;
        }

        public int getDuration() {
            return this.duration;
        }
    }

    public static interface IParticleSpriteReceiver {
        default public void setStitchedSprites(Frame[][] frames) {
            ((Particle)this).func_187117_a(frames[0][0].getSprite());
        }
    }
}

