/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.api.interfaces.plants;

import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import nmd.primal.core.api.PrimalAPI;
import nmd.primal.core.api.interfaces.plants.IPrimalPlants;

public interface IPerennial
extends IPrimalPlants {
    public IBlockState getNewPlant();

    default public boolean canNewGrow(World world, BlockPos pos, IBlockState state) {
        return true;
    }

    default public boolean growNewPlant(World world, BlockPos pos, IBlockState source) {
        IBlockState soil = this.getSoil((IBlockAccess)world, pos);
        Block child = this.getNewPlant().func_177230_c();
        int age = this.getAge(source);
        if (age > 0 && this.canNewGrow(world, pos, source) && soil.func_177230_c() != child && child instanceof IPlantable && child.canSustainPlant(soil, (IBlockAccess)world, pos.func_177977_b(), EnumFacing.UP, (IPlantable)child)) {
            PrimalAPI.logger(9, "perennial", "pass@" + pos + ", IPerennial#growNewPlant");
            PrimalAPI.logger(5, "schedule", "@" + pos + ", IPerennial#growNewPlant");
            return PrimalAPI.placeScheduledBlock(world, pos, this.getNewPlant(), 3);
        }
        PrimalAPI.logger(9, "perennial", "fail@" + pos + ", IPerennial#growNewPlant");
        return false;
    }
}

