/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.blocks;

import com.direwolf20.buildinggadgets.common.blocks.BlockModBase;
import com.direwolf20.buildinggadgets.common.blocks.ConstructionBlockTileEntity;
import com.direwolf20.buildinggadgets.common.blocks.ModBlocks;
import com.direwolf20.buildinggadgets.common.blocks.Models.BlockstateProperty;
import com.direwolf20.buildinggadgets.common.blocks.Models.ConstructionBakedModel;
import com.direwolf20.buildinggadgets.common.items.FakeRenderWorld;
import com.direwolf20.buildinggadgets.common.items.ModItems;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import team.chisel.ctm.api.IFacade;

@Optional.Interface(iface="team.chisel.ctm.api.IFacade", modid="ctm-api")
public class ConstructionBlock
extends BlockModBase
implements IFacade {
    public static final PropertyBool BRIGHT = PropertyBool.func_177716_a((String)"bright");
    public static final PropertyBool NEIGHBOR_BRIGHTNESS = PropertyBool.func_177716_a((String)"neighbor_brightness");
    public static final IUnlistedProperty<IBlockState> FACADE_ID = new BlockstateProperty("facadestate");
    public static final IUnlistedProperty<IBlockState> FACADE_EXT_STATE = new BlockstateProperty("facadeextstate");

    public ConstructionBlock() {
        super(Material.field_151576_e, 2.0f, "constructionblock");
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)BRIGHT, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)NEIGHBOR_BRIGHTNESS, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        super.initModel();
        StateMapperBase ignoreState = new StateMapperBase(){

            protected ModelResourceLocation func_178132_a(IBlockState iBlockState) {
                return ConstructionBakedModel.modelFacade;
            }
        };
        ModelLoader.setCustomStateMapper((Block)this, (IStateMapper)ignoreState);
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return ModItems.constructionPaste;
    }

    public boolean canSilkHarvest(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        return false;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World worldIn, IBlockState state) {
        return new ConstructionBlockTileEntity();
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        IExtendedBlockState extendedBlockState = (IExtendedBlockState)super.getExtendedState(state, world, pos);
        IBlockState mimicBlock = this.getActualMimicBlock(world, pos);
        if (mimicBlock != null) {
            FakeRenderWorld fakeRenderWorld = new FakeRenderWorld();
            fakeRenderWorld.setState(world, mimicBlock, pos);
            IBlockState extState = mimicBlock.func_177230_c().getExtendedState(mimicBlock, (IBlockAccess)fakeRenderWorld, pos);
            return extendedBlockState.withProperty(FACADE_ID, (Object)mimicBlock).withProperty(FACADE_EXT_STATE, (Object)extState);
        }
        return extendedBlockState;
    }

    @Nullable
    private IBlockState getActualMimicBlock(IBlockAccess blockAccess, BlockPos pos) {
        try {
            TileEntity te = blockAccess.func_175625_s(pos);
            if (te instanceof ConstructionBlockTileEntity) {
                return ((ConstructionBlockTileEntity)te).getActualBlockState();
            }
            return null;
        }
        catch (Exception var8) {
            return null;
        }
    }

    protected BlockStateContainer func_180661_e() {
        IProperty[] listedProperties = new IProperty[]{BRIGHT, NEIGHBOR_BRIGHTNESS};
        IUnlistedProperty[] unlistedProperties = new IUnlistedProperty[]{FACADE_ID, FACADE_EXT_STATE};
        return new ExtendedBlockState((Block)this, listedProperties, unlistedProperties);
    }

    @Deprecated
    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        return true;
    }

    @Deprecated
    public boolean func_149662_c(IBlockState p_isFullBlock_1_) {
        return false;
    }

    @Deprecated
    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public int getLightOpacity(IBlockState state, IBlockAccess world, BlockPos pos) {
        Boolean bright = (Boolean)state.func_177229_b((IProperty)BRIGHT);
        if (bright.booleanValue()) {
            return 0;
        }
        return 255;
    }

    public boolean doesSideBlockRendering(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing face) {
        IBlockState mimicBlock = this.getActualMimicBlock(world, pos);
        return mimicBlock == null ? true : mimicBlock.func_177230_c().doesSideBlockRendering(mimicBlock, world, pos, face);
    }

    @SideOnly(value=Side.CLIENT)
    public void initColorHandler(BlockColors blockColors) {
        blockColors.func_186722_a((state, world, pos, tintIndex) -> {
            IBlockState mimicBlock = this.getActualMimicBlock(world, pos);
            return mimicBlock != null ? blockColors.func_186724_a(mimicBlock, world, pos, tintIndex) : -1;
        }, new Block[]{this});
    }

    @Deprecated
    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        IBlockState mimicBlock = this.getActualMimicBlock(worldIn, pos);
        try {
            return mimicBlock == null ? BlockFaceShape.SOLID : mimicBlock.func_177230_c().func_193383_a(worldIn, mimicBlock, pos, face);
        }
        catch (Exception var8) {
            return BlockFaceShape.SOLID;
        }
    }

    @Deprecated
    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean isActualState) {
        IBlockState mimicBlock = this.getActualMimicBlock((IBlockAccess)worldIn, pos);
        if (mimicBlock == null) {
            super.func_185477_a(state, worldIn, pos, entityBox, collidingBoxes, entityIn, isActualState);
        } else {
            try {
                mimicBlock.func_177230_c().func_185477_a(mimicBlock, worldIn, pos, entityBox, collidingBoxes, entityIn, isActualState);
            }
            catch (Exception var8) {
                super.func_185477_a(state, worldIn, pos, entityBox, collidingBoxes, entityIn, isActualState);
            }
        }
    }

    @Nullable
    @Deprecated
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        IBlockState mimicBlock = this.getActualMimicBlock(worldIn, pos);
        if (mimicBlock == null) {
            return super.func_185496_a(blockState, worldIn, pos);
        }
        try {
            return mimicBlock.func_177230_c().func_185496_a(mimicBlock, worldIn, pos);
        }
        catch (Exception var8) {
            return super.func_185496_a(blockState, worldIn, pos);
        }
    }

    @Deprecated
    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        FakeRenderWorld fakeWorld = new FakeRenderWorld();
        IBlockState mimicBlock = this.getActualMimicBlock(blockAccess, pos);
        if (mimicBlock == null) {
            return super.func_176225_a(blockState, blockAccess, pos, side);
        }
        IBlockState sideBlockState = blockAccess.func_180495_p(pos.func_177972_a(side));
        if (sideBlockState.func_177230_c().equals((Object)ModBlocks.constructionBlock) && this.getActualMimicBlock(blockAccess, pos.func_177972_a(side)) != null) {
            sideBlockState = this.getActualMimicBlock(blockAccess, pos.func_177972_a(side));
        }
        fakeWorld.setState(blockAccess, mimicBlock, pos);
        fakeWorld.setState(blockAccess, sideBlockState, pos.func_177972_a(side));
        try {
            return mimicBlock.func_177230_c().func_176225_a(mimicBlock, (IBlockAccess)fakeWorld, pos, side);
        }
        catch (Exception var8) {
            return super.func_176225_a(blockState, blockAccess, pos, side);
        }
    }

    @Deprecated
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        IBlockState mimicBlock = this.getActualMimicBlock(source, pos);
        if (mimicBlock == null) {
            return super.func_185496_a(state, source, pos);
        }
        try {
            return mimicBlock.func_177230_c().func_185496_a(mimicBlock, source, pos);
        }
        catch (Exception var8) {
            return super.func_185496_a(state, source, pos);
        }
    }

    @Deprecated
    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_180640_a(IBlockState state, World worldIn, BlockPos pos) {
        IBlockState mimicBlock = this.getActualMimicBlock((IBlockAccess)worldIn, pos);
        if (mimicBlock == null) {
            return super.func_180640_a(state, worldIn, pos);
        }
        try {
            return mimicBlock.func_177230_c().func_180640_a(mimicBlock, worldIn, pos);
        }
        catch (Exception var8) {
            return super.func_180640_a(state, worldIn, pos);
        }
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        IBlockState mimicBlock = this.getActualMimicBlock(world, pos);
        if (mimicBlock == null) {
            return super.isNormalCube(state, world, pos);
        }
        try {
            return mimicBlock.func_177230_c().isNormalCube(mimicBlock, world, pos);
        }
        catch (Exception var8) {
            return super.isNormalCube(state, world, pos);
        }
    }

    @Deprecated
    @SideOnly(value=Side.CLIENT)
    public float func_185485_f(IBlockState state) {
        Boolean bright = (Boolean)state.func_177229_b((IProperty)BRIGHT);
        Boolean neighborBrightness = (Boolean)state.func_177229_b((IProperty)NEIGHBOR_BRIGHTNESS);
        if (bright.booleanValue() || neighborBrightness.booleanValue()) {
            return 1.0f;
        }
        return 0.2f;
    }

    @Deprecated
    public boolean func_149710_n(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)NEIGHBOR_BRIGHTNESS);
    }

    @Deprecated
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)BRIGHT, (Comparable)Boolean.valueOf(meta % 2 == 1)).func_177226_a((IProperty)NEIGHBOR_BRIGHTNESS, (Comparable)Boolean.valueOf(meta / 2 == 1));
    }

    public int func_176201_c(IBlockState state) {
        int value = (Boolean)state.func_177229_b((IProperty)BRIGHT) != false ? 1 : 0;
        return (Boolean)state.func_177229_b((IProperty)NEIGHBOR_BRIGHTNESS) != false ? value + 2 : value;
    }

    @Nonnull
    @Deprecated
    public IBlockState getFacade(@Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nullable EnumFacing side) {
        IBlockState mimicBlock = this.getActualMimicBlock(world, pos);
        return mimicBlock != null ? mimicBlock : world.func_180495_p(pos);
    }
}

